
/*
 * Calibration Table for SwatchMate Cube
 * This is #included in smcube.c
 *
 * Copyright 2015 Graeme W. Gill
 * All rights reserved
 *
 * This material is licenced under the GNU GENERAL PUBLIC LICENSE Version 2 or later :-
 * see the License2.txt file for licencing details.
 *
 * This calibration is for a Cube with LED wavlengths 630.0 530.0 460.0 nm
 *
 */

typedef struct {
	int res;
	float dpow;
	int   islab;
	float table[17][17][17][3];
} cube_clut;

cube_clut clut = {
	17,
	0.560000,
	1,
	{
		{
			{
				{ 0.000000, 0.000000, 0.000000 },
				{ -3.108725, 6.379437, -16.262457 },
				{ -3.513774, 12.119589, -30.739702 },
				{ -2.115353, 17.935534, -41.855820 },
				{ -0.010341, 24.314871, -50.902515 },
				{ 1.854175, 31.610882, -59.665554 },
				{ 3.449414, 39.690384, -68.404831 },
				{ 4.988287, 47.418373, -76.619690 },
				{ 6.660570, 53.383759, -83.814575 },
				{ 8.526612, 57.535027, -90.003593 },
				{ 10.574578, 60.238720, -95.427658 },
				{ 12.685945, 62.268253, -100.538567 },
				{ 14.754425, 64.383377, -105.725388 },
				{ 16.737513, 66.922600, -111.162636 },
				{ 18.639080, 69.858894, -116.850212 },
				{ 20.484802, 73.024666, -122.704948 },
				{ 22.306879, 76.269745, -128.628067 }
			},
			{
				{ 4.234821, -19.241503, 11.292808 },
				{ 2.843881, -13.871078, -6.200700 },
				{ 2.827496, -7.748870, -22.260107 },
				{ 3.952048, -1.440168, -33.601727 },
				{ 5.672034, 5.117609, -42.689331 },
				{ 7.361498, 11.773417, -51.513256 },
				{ 9.100790, 18.863472, -59.675938 },
				{ 10.697422, 26.752626, -67.525803 },
				{ 12.227798, 32.830032, -74.627243 },
				{ 13.716241, 37.288288, -81.072021 },
				{ 15.297711, 40.708969, -86.998367 },
				{ 16.991249, 44.180187, -92.798790 },
				{ 18.763279, 48.119270, -98.691429 },
				{ 20.576683, 52.399059, -104.699463 },
				{ 22.403513, 56.800434, -110.775215 },
				{ 24.236834, 61.223938, -116.874222 },
				{ 26.075523, 65.651451, -122.975830 }
			},
			{
				{ 10.640698, -37.914284, 21.981108 },
				{ 9.888870, -33.497070, 4.419587 },
				{ 9.632989, -27.494251, -11.957022 },
				{ 10.227860, -20.078138, -25.040745 },
				{ 11.195958, -12.701514, -35.623631 },
				{ 12.744726, -6.568381, -44.244148 },
				{ 14.799405, -0.984663, -51.357300 },
				{ 16.581852, 5.544156, -58.274593 },
				{ 17.951008, 12.551022, -65.364006 },
				{ 19.114931, 17.187794, -71.947189 },
				{ 20.164137, 21.516897, -78.497963 },
				{ 21.407064, 26.724361, -85.085754 },
				{ 22.878307, 32.437378, -91.678307 },
				{ 24.505775, 38.226738, -98.215355 },
				{ 26.228365, 43.882099, -104.651878 },
				{ 28.021624, 49.423836, -110.978996 },
				{ 29.852308, 54.926193, -117.244186 }
			},
			{
				{ 17.840609, -54.014400, 31.482065 },
				{ 17.239162, -49.899727, 14.727889 },
				{ 16.713871, -44.337044, -1.582370 },
				{ 16.983976, -37.032753, -15.767160 },
				{ 17.277546, -29.690071, -27.638208 },
				{ 18.434795, -22.976774, -36.755417 },
				{ 20.241308, -16.644985, -43.990032 },
				{ 21.888008, -11.439743, -50.310852 },
				{ 23.389778, -4.672492, -57.037277 },
				{ 24.390499, -1.550237, -63.394146 },
				{ 25.049068, 3.946567, -70.458015 },
				{ 25.954910, 10.981771, -77.681068 },
				{ 27.184675, 18.032602, -84.781555 },
				{ 28.595022, 24.752199, -91.705009 },
				{ 30.166162, 31.248569, -98.424278 },
				{ 31.870760, 37.613705, -104.930702 },
				{ 33.633942, 43.899342, -111.315231 }
			},
			{
				{ 24.523094, -66.826271, 39.123337 },
				{ 24.155392, -62.930618, 23.907663 },
				{ 23.385942, -58.392117, 8.178281 },
				{ 23.499163, -52.274418, -5.687166 },
				{ 24.152292, -45.770733, -17.248781 },
				{ 25.308041, -38.504848, -26.531488 },
				{ 26.092649, -29.958961, -35.283051 },
				{ 27.132149, -25.425463, -42.373322 },
				{ 28.260490, -21.008181, -49.500965 },
				{ 29.064190, -18.958935, -55.951431 },
				{ 29.684616, -10.219873, -63.695320 },
				{ 30.512142, -2.169182, -71.004639 },
				{ 31.619951, 5.171085, -78.145775 },
				{ 32.792465, 12.050668, -85.208824 },
				{ 34.217468, 18.978827, -92.060959 },
				{ 35.788540, 25.757549, -98.651100 },
				{ 37.384262, 32.303059, -105.080009 }
			},
			{
				{ 30.245825, -77.505936, 44.899803 },
				{ 29.945150, -74.127945, 30.956144 },
				{ 29.422693, -70.561089, 16.842474 },
				{ 29.867500, -64.914642, 4.572066 },
				{ 31.462145, -58.134586, -5.249294 },
				{ 33.357727, -50.895237, -13.638721 },
				{ 33.089081, -39.280712, -24.553354 },
				{ 33.019260, -33.548992, -34.143417 },
				{ 33.317039, -32.300022, -42.273518 },
				{ 33.573269, -31.657618, -49.453796 },
				{ 34.065811, -19.613224, -58.254604 },
				{ 34.934368, -13.305716, -64.859550 },
				{ 35.844479, -6.896156, -71.776550 },
				{ 36.957993, -0.002162, -78.787140 },
				{ 38.346428, 7.100326, -85.557175 },
				{ 39.720154, 13.719435, -92.097511 },
				{ 41.025173, 19.866701, -98.500572 }
			},
			{
				{ 35.235012, -86.441414, 49.726543 },
				{ 34.758579, -85.026138, 36.455482 },
				{ 34.462742, -82.534927, 23.675982 },
				{ 35.611725, -75.017761, 13.446783 },
				{ 37.702091, -65.528801, 5.167120 },
				{ 40.179146, -54.286797, -2.609262 },
				{ 40.901623, -44.071568, -12.577824 },
				{ 40.139965, -41.447945, -22.765736 },
				{ 39.066429, -44.586857, -32.310959 },
				{ 38.215954, -43.197380, -42.328728 },
				{ 38.405800, -30.678701, -52.029255 },
				{ 39.270744, -23.080603, -59.145893 },
				{ 39.820694, -18.002005, -65.778786 },
				{ 41.184551, -11.119964, -72.449829 },
				{ 42.477837, -4.495872, -78.928993 },
				{ 43.501858, 1.116444, -85.279678 },
				{ 44.489861, 6.571913, -91.668831 }
			},
			{
				{ 39.958138, -93.179825, 54.704079 },
				{ 39.555668, -93.157700, 42.108181 },
				{ 39.214561, -92.018959, 29.819813 },
				{ 40.364056, -83.579498, 20.198338 },
				{ 42.055130, -73.175941, 12.419911 },
				{ 45.573200, -59.653439, 5.937179 },
				{ 47.942894, -49.991074, -1.680336 },
				{ 48.170784, -46.276493, -11.122963 },
				{ 45.713558, -49.093582, -23.128136 },
				{ 43.032284, -48.764896, -36.073044 },
				{ 42.848442, -40.468571, -45.971424 },
				{ 43.794662, -32.508579, -53.292789 },
				{ 44.814892, -26.621048, -59.638981 },
				{ 45.709064, -21.018253, -66.044327 },
				{ 46.319767, -16.250605, -72.321960 },
				{ 46.946510, -12.385717, -78.291138 },
				{ 47.852665, -6.934625, -84.808495 }
			},
			{
				{ 44.629810, -97.512657, 60.343151 },
				{ 44.495537, -97.860184, 48.383362 },
				{ 44.423790, -96.815140, 36.808792 },
				{ 44.905434, -90.878922, 26.749361 },
				{ 46.081753, -81.581528, 18.502306 },
				{ 47.897537, -73.804169, 10.768237 },
				{ 49.712009, -66.343132, 2.913184 },
				{ 51.391113, -57.542595, -5.912806 },
				{ 50.904179, -53.260086, -16.853422 },
				{ 47.826492, -52.822918, -29.804100 },
				{ 46.345203, -48.492229, -40.639957 },
				{ 48.398746, -41.844818, -46.582294 },
				{ 50.077869, -35.219254, -52.237839 },
				{ 49.625580, -30.934124, -59.463520 },
				{ 49.808678, -28.108028, -65.701012 },
				{ 50.442028, -25.044247, -71.418922 },
				{ 51.356403, -19.369282, -78.134308 }
			},
			{
				{ 49.270729, -99.759590, 66.688675 },
				{ 49.337383, -100.308464, 55.103058 },
				{ 49.428707, -99.807571, 43.756931 },
				{ 49.838558, -95.655418, 33.235252 },
				{ 50.703857, -88.109573, 24.046219 },
				{ 50.950581, -86.008919, 15.020423 },
				{ 51.044769, -82.859673, 5.777906 },
				{ 52.370487, -72.516121, -2.969076 },
				{ 54.230980, -62.567928, -11.389186 },
				{ 53.761917, -57.989693, -21.253706 },
				{ 52.653187, -53.524620, -31.124254 },
				{ 54.125965, -47.007568, -37.658783 },
				{ 54.943760, -42.044025, -43.944542 },
				{ 54.719326, -39.561131, -50.772568 },
				{ 54.593254, -37.591316, -57.665367 },
				{ 54.861210, -34.177044, -64.452827 },
				{ 55.230713, -29.885284, -71.424011 }
			},
			{
				{ 53.749859, -101.007339, 73.324669 },
				{ 54.037182, -101.500282, 61.988304 },
				{ 54.351585, -101.485573, 50.763695 },
				{ 54.728493, -100.275581, 39.571770 },
				{ 55.182110, -97.096970, 28.963995 },
				{ 55.612743, -93.981888, 20.119753 },
				{ 55.534679, -89.943001, 11.638604 },
				{ 56.984486, -80.488998, 4.237844 },
				{ 59.775852, -67.887016, -2.702181 },
				{ 60.846546, -58.743637, -10.944484 },
				{ 60.257290, -52.556461, -19.970139 },
				{ 59.879021, -47.652100, -27.901505 },
				{ 59.704334, -45.628235, -34.953999 },
				{ 60.177921, -45.100357, -41.311794 },
				{ 60.064106, -44.065216, -48.531544 },
				{ 59.917400, -41.407433, -56.159145 },
				{ 59.860271, -38.118248, -63.809296 }
			},
			{
				{ 57.959553, -102.546158, 79.702118 },
				{ 58.467693, -103.093224, 68.435059 },
				{ 59.052544, -103.585632, 57.205406 },
				{ 59.614182, -104.189972, 45.818848 },
				{ 59.676968, -105.192863, 34.029060 },
				{ 59.924614, -101.542435, 24.995707 },
				{ 60.108082, -95.345459, 17.530905 },
				{ 61.442051, -85.966286, 10.957516 },
				{ 64.263809, -72.848038, 5.029232 },
				{ 66.800751, -60.241428, -1.336677 },
				{ 67.511726, -52.286400, -8.862195 },
				{ 67.081146, -48.533459, -16.744081 },
				{ 66.224373, -47.949566, -24.555666 },
				{ 65.538208, -48.899300, -32.113544 },
				{ 65.567955, -48.106628, -39.325703 },
				{ 65.502762, -46.144470, -47.025230 },
				{ 65.350967, -43.767235, -55.044312 }
			},
			{
				{ 61.895813, -105.321358, 85.412849 },
				{ 62.516296, -106.177589, 74.107948 },
				{ 63.178932, -107.293785, 62.723862 },
				{ 63.767868, -108.630531, 51.311371 },
				{ 64.098648, -109.043663, 40.378693 },
				{ 64.414215, -105.720825, 31.327908 },
				{ 64.761299, -99.257347, 23.988560 },
				{ 65.764763, -90.388802, 17.513399 },
				{ 68.571144, -76.901031, 12.216690 },
				{ 71.551918, -63.674194, 6.957545 },
				{ 72.788559, -55.732986, 0.336008 },
				{ 72.672279, -52.393192, -7.323466 },
				{ 72.037094, -51.219807, -15.259692 },
				{ 71.400864, -50.899494, -23.046545 },
				{ 71.332153, -50.024654, -30.363155 },
				{ 71.474503, -48.580414, -37.788166 },
				{ 71.327637, -47.099865, -45.686085 }
			},
			{
				{ 65.598488, -109.693581, 90.303467 },
				{ 66.294830, -110.335930, 79.263634 },
				{ 67.013908, -111.152596, 68.204987 },
				{ 67.703514, -111.816353, 57.345287 },
				{ 68.293015, -111.143593, 47.252151 },
				{ 68.862648, -107.791237, 38.435230 },
				{ 69.651482, -101.074799, 31.149630 },
				{ 71.128685, -91.379051, 24.969904 },
				{ 73.456062, -79.259766, 19.580812 },
				{ 75.713127, -68.222137, 14.215412 },
				{ 76.748306, -61.720993, 7.848460 },
				{ 76.764755, -58.632881, 0.344270 },
				{ 76.856544, -55.937836, -7.337325 },
				{ 77.160217, -53.299274, -14.535153 },
				{ 77.230278, -51.371181, -21.751291 },
				{ 77.391808, -49.948524, -28.912670 },
				{ 77.257851, -48.938850, -36.447983 }
			},
			{
				{ 69.138222, -115.407463, 94.530319 },
				{ 69.959679, -114.994591, 84.179970 },
				{ 70.797920, -114.599388, 73.895081 },
				{ 71.641388, -113.936798, 63.835060 },
				{ 72.479919, -112.139946, 54.427727 },
				{ 73.405617, -108.114395, 46.073639 },
				{ 74.657585, -101.248184, 38.904060 },
				{ 76.375427, -92.013535, 32.660847 },
				{ 78.273735, -81.927620, 26.830244 },
				{ 79.643272, -73.650864, 20.762907 },
				{ 80.095856, -68.746277, 13.996282 },
				{ 80.237488, -65.328606, 6.593365 },
				{ 80.829597, -61.168301, -0.847144 },
				{ 81.967155, -56.674473, -7.359741 },
				{ 82.741562, -53.372719, -13.773818 },
				{ 82.948288, -51.470921, -20.592533 },
				{ 82.850342, -50.285915, -27.703110 }
			},
			{
				{ 72.591682, -121.923248, 98.382576 },
				{ 73.593880, -119.906700, 88.960213 },
				{ 74.603554, -117.826050, 79.632339 },
				{ 75.632095, -115.451370, 70.543335 },
				{ 76.720016, -112.245041, 61.945644 },
				{ 77.956146, -107.561996, 54.052269 },
				{ 79.407364, -101.229942, 46.834183 },
				{ 80.923347, -93.843704, 40.059162 },
				{ 82.208199, -86.485527, 33.375301 },
				{ 83.020081, -80.255562, 26.494286 },
				{ 83.393234, -75.393074, 19.325455 },
				{ 83.745392, -70.887688, 11.981798 },
				{ 84.426193, -65.981232, 4.849656 },
				{ 86.235596, -60.403255, -0.857586 },
				{ 87.477249, -56.231133, -6.660480 },
				{ 87.960991, -53.619331, -12.939464 },
				{ 88.118187, -51.753475, -19.465408 }
			},
			{
				{ 76.015961, -128.743332, 102.099846 },
				{ 77.222733, -124.923180, 93.688072 },
				{ 78.426880, -120.974251, 85.391876 },
				{ 79.659309, -116.711052, 77.348976 },
				{ 80.990257, -111.981232, 69.624046 },
				{ 82.451942, -106.808617, 62.145725 },
				{ 83.891411, -101.533310, 54.721294 },
				{ 84.959831, -96.684952, 47.167572 },
				{ 85.535416, -92.302246, 39.441597 },
				{ 85.935226, -87.629555, 31.732239 },
				{ 86.558685, -82.017166, 24.319881 },
				{ 87.481041, -75.890518, 17.362139 },
				{ 88.740135, -69.898308, 11.060918 },
				{ 90.419434, -64.218529, 5.507547 },
				{ 91.805351, -59.621750, 0.013592 },
				{ 92.643288, -56.218506, -5.691527 },
				{ 93.189407, -53.454399, -11.539556 }
			}
		},
		{
			{
				{ -0.109722, 12.964268, 4.516390 },
				{ -0.660951, 18.041716, -11.918370 },
				{ 0.003791, 22.950363, -27.032158 },
				{ 1.403321, 28.049053, -38.866135 },
				{ 2.971407, 33.518665, -48.958076 },
				{ 4.291079, 39.762562, -58.772896 },
				{ 5.646095, 46.137688, -67.681908 },
				{ 7.274704, 51.939293, -74.893654 },
				{ 9.175462, 56.472900, -80.800064 },
				{ 11.259534, 60.080914, -86.050377 },
				{ 13.445276, 62.959408, -91.019852 },
				{ 15.543013, 65.496269, -96.086884 },
				{ 17.465246, 68.010544, -101.434532 },
				{ 19.224691, 70.592606, -107.071106 },
				{ 20.874966, 73.205833, -112.907555 },
				{ 22.471581, 75.813858, -118.839966 },
				{ 24.052408, 78.412941, -124.799286 }
			},
			{
				{ 6.727361, -4.663532, 17.602961 },
				{ 6.448769, -0.386471, -0.161296 },
				{ 6.582062, 5.398698, -18.839003 },
				{ 7.765986, 10.174873, -30.236370 },
				{ 9.299706, 15.462027, -39.349197 },
				{ 10.179111, 21.265503, -49.232906 },
				{ 11.351582, 26.229401, -57.799107 },
				{ 12.637918, 31.964056, -65.316002 },
				{ 14.254212, 37.069191, -71.860504 },
				{ 15.845289, 42.339211, -78.106773 },
				{ 17.692101, 45.783108, -83.596008 },
				{ 19.456791, 49.311340, -89.289185 },
				{ 21.127934, 53.087559, -95.247589 },
				{ 22.767759, 56.765354, -101.260284 },
				{ 24.410303, 60.317146, -107.236206 },
				{ 26.067160, 63.855080, -113.180855 },
				{ 27.734791, 67.423645, -119.116615 }
			},
			{
				{ 14.152776, -21.465309, 29.291939 },
				{ 13.953787, -18.502064, 12.135889 },
				{ 13.431262, -15.198259, -6.332568 },
				{ 13.720811, -7.956450, -21.397753 },
				{ 14.754900, -0.191718, -32.763718 },
				{ 15.762719, 3.656883, -41.039291 },
				{ 17.077890, 6.374919, -48.146095 },
				{ 18.095776, 9.619523, -55.350586 },
				{ 19.449051, 16.296291, -62.782795 },
				{ 20.736963, 23.167822, -69.657776 },
				{ 21.976349, 28.129045, -76.072792 },
				{ 23.347792, 33.280758, -82.546509 },
				{ 24.800255, 38.308910, -89.086266 },
				{ 26.344727, 42.966049, -95.414513 },
				{ 27.983362, 47.424789, -101.503319 },
				{ 29.692310, 51.907467, -107.465797 },
				{ 31.432634, 56.457760, -113.395195 }
			},
			{
				{ 21.270660, -36.292389, 38.919945 },
				{ 21.016575, -33.381729, 22.203236 },
				{ 20.238115, -30.629267, 4.818551 },
				{ 19.120800, -25.013151, -12.603518 },
				{ 18.984547, -16.175421, -26.927734 },
				{ 19.989426, -10.840259, -35.730373 },
				{ 22.304512, -8.846658, -41.007481 },
				{ 23.467249, -7.326241, -47.191299 },
				{ 24.429728, 0.189621, -55.007816 },
				{ 25.352819, 5.999861, -62.085197 },
				{ 26.242043, 12.090010, -69.035919 },
				{ 27.335072, 18.170822, -75.944267 },
				{ 28.588709, 23.825348, -82.863823 },
				{ 30.039783, 29.255419, -89.422386 },
				{ 31.660833, 34.633133, -95.626015 },
				{ 33.388287, 40.051426, -101.636810 },
				{ 35.146011, 45.484661, -107.586769 }
			},
			{
				{ 27.545839, -48.871937, 46.338982 },
				{ 26.898664, -45.666077, 30.167574 },
				{ 25.458376, -43.679428, 13.034832 },
				{ 25.289818, -39.786076, -2.052759 },
				{ 24.949835, -34.862461, -16.536722 },
				{ 25.280588, -27.313738, -27.964441 },
				{ 26.894756, -20.516470, -35.373688 },
				{ 28.177526, -17.190155, -41.813789 },
				{ 28.946136, -13.411076, -48.748680 },
				{ 29.929111, -10.218981, -55.002426 },
				{ 30.832394, -2.945107, -62.046577 },
				{ 31.552807, 3.647907, -69.314583 },
				{ 32.595730, 9.699430, -76.433617 },
				{ 33.931698, 15.902310, -83.197861 },
				{ 35.515831, 22.263783, -89.573074 },
				{ 37.191975, 28.443512, -95.668488 },
				{ 38.839813, 34.345196, -101.642899 }
			},
			{
				{ 32.824162, -59.902714, 51.764248 },
				{ 32.316071, -56.329464, 37.105709 },
				{ 31.785854, -53.159557, 22.594913 },
				{ 31.956902, -50.697521, 9.062675 },
				{ 31.638990, -47.666862, -4.450498 },
				{ 31.657951, -40.266228, -16.832432 },
				{ 31.585718, -31.178511, -27.786552 },
				{ 31.798576, -27.714243, -36.478394 },
				{ 33.255405, -26.615278, -42.475090 },
				{ 34.677929, -23.363750, -48.271221 },
				{ 35.794525, -14.450707, -55.341911 },
				{ 35.931828, -9.867313, -62.549294 },
				{ 36.767994, -3.860245, -69.778938 },
				{ 37.964397, 3.296212, -76.853638 },
				{ 39.572792, 10.721520, -83.411667 },
				{ 41.092911, 17.156990, -89.555016 },
				{ 42.447281, 22.770515, -95.525772 }
			},
			{
				{ 37.555626, -69.281143, 56.263180 },
				{ 37.338058, -66.389442, 42.991028 },
				{ 37.232368, -63.723949, 29.965485 },
				{ 37.530113, -60.881599, 17.600735 },
				{ 38.033909, -57.176727, 6.448005 },
				{ 39.606743, -48.073418, -3.336276 },
				{ 40.732307, -37.373260, -13.427800 },
				{ 39.156296, -36.143059, -24.613016 },
				{ 39.195580, -39.853985, -32.753349 },
				{ 39.392818, -36.341888, -41.277798 },
				{ 40.255852, -26.215784, -49.228638 },
				{ 40.425007, -21.494568, -56.337517 },
				{ 40.998665, -16.328390, -63.159996 },
				{ 42.008045, -8.124515, -70.667885 },
				{ 43.735588, -0.008248, -77.213425 },
				{ 44.908211, 5.695886, -83.263741 },
				{ 45.916843, 10.629616, -89.268532 }
			},
			{
				{ 42.147465, -76.766701, 60.789772 },
				{ 42.299606, -74.511528, 48.546928 },
				{ 42.680542, -71.664650, 36.780590 },
				{ 42.632626, -69.321091, 24.549770 },
				{ 42.984146, -64.874771, 14.230529 },
				{ 46.074726, -53.758888, 7.089729 },
				{ 51.096718, -39.566898, 2.165134 },
				{ 50.707195, -36.346497, -8.316802 },
				{ 47.442959, -41.171867, -21.913683 },
				{ 42.755508, -42.518425, -36.689568 },
				{ 42.632286, -35.811646, -45.989227 },
				{ 43.898434, -30.842978, -52.080032 },
				{ 45.236687, -26.553791, -57.309086 },
				{ 46.277924, -18.302681, -64.644577 },
				{ 47.551899, -11.595761, -70.939049 },
				{ 48.216679, -7.295179, -76.814461 },
				{ 49.303459, -1.626661, -83.059784 }
			},
			{
				{ 46.797306, -82.113327, 65.985092 },
				{ 47.033451, -81.177040, 53.767132 },
				{ 47.481213, -79.334969, 42.047043 },
				{ 47.178333, -77.716866, 30.496847 },
				{ 47.269470, -73.222015, 20.729061 },
				{ 48.622013, -66.941208, 12.548149 },
				{ 51.883324, -56.784122, 6.483915 },
				{ 55.790810, -44.951359, 0.086268 },
				{ 53.158058, -46.061443, -13.531353 },
				{ 46.925144, -48.451294, -30.261021 },
				{ 44.608372, -44.204845, -42.466583 },
				{ 48.035027, -38.204216, -46.903751 },
				{ 49.927052, -33.555050, -51.517765 },
				{ 50.282928, -29.511238, -58.053574 },
				{ 50.787457, -25.119465, -64.510788 },
				{ 51.487301, -19.928804, -70.663300 },
				{ 52.675152, -13.315639, -77.167068 }
			},
			{
				{ 51.493137, -85.459854, 72.064362 },
				{ 51.550728, -86.243324, 59.471241 },
				{ 51.346626, -87.506058, 46.928963 },
				{ 51.311836, -86.649879, 35.516239 },
				{ 51.907852, -80.964729, 26.292250 },
				{ 51.813568, -78.481682, 17.138964 },
				{ 52.567123, -73.797798, 9.103230 },
				{ 55.225285, -63.819031, 2.390569 },
				{ 56.310726, -57.706341, -6.933607 },
				{ 54.957817, -54.361889, -18.578909 },
				{ 50.593243, -52.641651, -32.250191 },
				{ 54.304844, -44.332932, -36.933754 },
				{ 55.239887, -39.910801, -42.867847 },
				{ 55.378731, -38.685192, -49.435268 },
				{ 54.855000, -36.205738, -57.380051 },
				{ 55.288586, -30.180481, -64.696053 },
				{ 55.905106, -24.846655, -71.332436 }
			},
			{
				{ 55.956814, -87.956116, 78.583946 },
				{ 55.951458, -89.536247, 65.894104 },
				{ 55.745937, -91.953247, 53.061142 },
				{ 55.692318, -93.895714, 40.732735 },
				{ 56.506737, -88.414177, 31.591509 },
				{ 57.266376, -82.886047, 23.740088 },
				{ 57.495304, -78.910980, 15.539824 },
				{ 59.111946, -71.728149, 8.452766 },
				{ 60.979137, -63.319157, 0.804020 },
				{ 61.443375, -56.433319, -8.248948 },
				{ 59.583656, -52.542572, -18.632784 },
				{ 62.097126, -43.624664, -24.672235 },
				{ 62.627522, -40.016567, -31.555696 },
				{ 62.710709, -40.601006, -38.678001 },
				{ 60.328259, -42.333290, -48.320518 },
				{ 59.827030, -38.607014, -56.820175 },
				{ 59.847618, -34.463291, -64.449989 }
			},
			{
				{ 60.068268, -90.793953, 84.838387 },
				{ 60.192654, -91.867699, 72.754684 },
				{ 60.324646, -93.828621, 60.231186 },
				{ 60.575718, -96.841438, 47.259399 },
				{ 60.726017, -95.176804, 36.974895 },
				{ 61.436455, -89.088951, 29.144070 },
				{ 61.951851, -83.778435, 21.123663 },
				{ 63.845016, -74.660370, 14.288402 },
				{ 65.216415, -66.999649, 7.456645 },
				{ 68.125725, -55.735107, 1.499337 },
				{ 69.251022, -48.719326, -5.498009 },
				{ 70.189156, -43.322033, -12.529144 },
				{ 69.082596, -42.297348, -20.923473 },
				{ 68.525894, -42.538307, -29.228800 },
				{ 67.309402, -43.267155, -38.226288 },
				{ 65.869087, -42.537128, -47.454998 },
				{ 65.015205, -40.900902, -56.037113 }
			},
			{
				{ 63.852764, -94.783005, 90.225807 },
				{ 63.971390, -95.628693, 78.901123 },
				{ 64.149033, -96.903503, 67.372749 },
				{ 64.579300, -99.282082, 54.539188 },
				{ 64.799271, -99.079834, 43.678539 },
				{ 65.079315, -96.510017, 34.479843 },
				{ 65.121437, -92.977661, 25.917637 },
				{ 66.091507, -85.305870, 18.747765 },
				{ 69.334427, -71.213768, 13.885178 },
				{ 72.561859, -58.281437, 8.913195 },
				{ 74.310188, -51.313866, 2.740475 },
				{ 73.969696, -49.620586, -4.987424 },
				{ 73.929848, -47.415058, -12.807284 },
				{ 74.025833, -45.128033, -20.781549 },
				{ 73.090965, -44.432991, -29.403418 },
				{ 72.148270, -44.601425, -37.916103 },
				{ 70.987411, -44.660252, -46.620445 }
			},
			{
				{ 67.349503, -100.061180, 94.650215 },
				{ 67.601540, -100.434921, 83.617081 },
				{ 67.903160, -100.973869, 72.507225 },
				{ 68.354591, -101.984932, 61.023727 },
				{ 68.759125, -102.480919, 50.264988 },
				{ 69.016815, -101.482994, 40.703499 },
				{ 69.324677, -97.733971, 32.336086 },
				{ 71.038406, -88.192230, 25.881205 },
				{ 74.985741, -71.900978, 21.772619 },
				{ 77.482079, -60.222874, 16.449583 },
				{ 77.933144, -56.736950, 9.423805 },
				{ 76.813301, -58.797630, 2.149310 },
				{ 77.355469, -55.228737, -6.327007 },
				{ 78.259544, -50.391342, -13.713044 },
				{ 78.103210, -48.086994, -21.148453 },
				{ 78.002663, -47.081196, -28.671013 },
				{ 77.030518, -47.001961, -37.058868 }
			},
			{
				{ 70.605003, -106.439667, 98.235733 },
				{ 71.140068, -105.973495, 87.486649 },
				{ 71.694679, -105.471542, 76.829102 },
				{ 72.323982, -104.921577, 66.701965 },
				{ 72.968239, -104.236778, 57.044533 },
				{ 73.590027, -102.457184, 48.004147 },
				{ 74.561729, -97.738243, 40.070148 },
				{ 76.610374, -88.369049, 33.687614 },
				{ 79.365761, -76.003113, 28.395283 },
				{ 80.942566, -67.236389, 22.230713 },
				{ 80.441360, -65.912842, 14.429005 },
				{ 80.244576, -65.192047, 6.871123 },
				{ 81.199265, -60.701340, -0.728169 },
				{ 82.711586, -54.392048, -6.819124 },
				{ 83.609283, -50.680126, -12.874462 },
				{ 83.095512, -49.684742, -20.470055 },
				{ 82.480148, -49.196350, -28.229549 }
			},
			{
				{ 73.684883, -113.550720, 101.266472 },
				{ 74.626152, -111.773849, 91.339706 },
				{ 75.592712, -109.830963, 81.652618 },
				{ 76.607193, -107.591873, 72.505096 },
				{ 77.654190, -105.035706, 63.792137 },
				{ 78.738289, -101.704308, 55.492760 },
				{ 80.045647, -96.695099, 47.840370 },
				{ 81.571915, -89.846458, 40.910126 },
				{ 82.833275, -82.680305, 34.199139 },
				{ 83.401482, -77.321457, 27.011520 },
				{ 83.379631, -74.066193, 19.249519 },
				{ 84.194870, -70.010719, 12.123606 },
				{ 84.990082, -64.780075, 5.048793 },
				{ 87.093262, -58.014503, -0.075778 },
				{ 88.201401, -53.856739, -5.644595 },
				{ 87.616577, -52.735920, -13.246017 },
				{ 87.337021, -51.746410, -20.465263 }
			},
			{
				{ 76.684563, -120.966629, 104.093536 },
				{ 78.093948, -117.602921, 95.307915 },
				{ 79.545799, -113.991295, 86.722534 },
				{ 81.063217, -109.926338, 78.470009 },
				{ 82.615700, -105.414131, 70.545959 },
				{ 84.114738, -100.665062, 62.867340 },
				{ 85.422188, -96.014442, 55.340061 },
				{ 86.284492, -91.952156, 47.838909 },
				{ 86.657570, -88.576141, 40.181431 },
				{ 86.881157, -85.085617, 32.401379 },
				{ 87.432716, -80.339417, 24.811174 },
				{ 88.704414, -74.038391, 18.005541 },
				{ 90.213524, -67.554886, 12.052963 },
				{ 91.620010, -62.085636, 6.675619 },
				{ 92.291824, -58.350330, 0.847642 },
				{ 92.037338, -56.386528, -6.154075 },
				{ 91.936905, -54.630192, -13.065011 }
			}
		},
		{
			{
				{ 2.194631, 25.095215, 9.179912 },
				{ 2.535604, 28.960636, -7.282309 },
				{ 3.353140, 33.036476, -22.606419 },
				{ 4.573775, 37.572872, -35.686512 },
				{ 5.676416, 42.495136, -47.258976 },
				{ 6.610404, 47.420284, -57.757523 },
				{ 7.818703, 51.882191, -66.543503 },
				{ 9.515291, 55.643257, -72.815201 },
				{ 11.606574, 58.869347, -77.634598 },
				{ 13.890020, 62.074142, -82.079819 },
				{ 16.160198, 65.357147, -86.746582 },
				{ 18.225294, 68.515205, -91.824394 },
				{ 20.022654, 71.423988, -97.299744 },
				{ 21.598852, 74.056053, -103.086853 },
				{ 23.042112, 76.400558, -109.033325 },
				{ 24.432238, 78.536957, -115.013809 },
				{ 25.812370, 80.586716, -120.984123 }
			},
			{
				{ 9.901916, 8.968406, 23.153603 },
				{ 10.358676, 12.571314, 5.857030 },
				{ 10.570131, 16.108046, -11.906166 },
				{ 11.461482, 20.904707, -25.971270 },
				{ 12.730595, 26.082245, -37.043167 },
				{ 12.714532, 31.786831, -48.192539 },
				{ 13.684689, 34.340706, -56.575371 },
				{ 14.829589, 37.366947, -63.120487 },
				{ 16.488838, 41.572044, -68.774307 },
				{ 18.501955, 46.352768, -74.186302 },
				{ 20.389347, 50.655849, -79.800995 },
				{ 22.014421, 54.539814, -85.720810 },
				{ 23.503624, 58.037853, -91.802032 },
				{ 24.956276, 61.020641, -97.805519 },
				{ 26.417416, 63.753407, -103.685410 },
				{ 27.900967, 66.489265, -109.498505 },
				{ 29.398708, 69.283798, -115.296959 }
			},
			{
				{ 17.451143, -6.325978, 35.710957 },
				{ 18.003298, -3.016162, 18.793209 },
				{ 17.896296, -0.078914, 0.028142 },
				{ 17.471020, 4.411031, -17.127514 },
				{ 18.982416, 8.579102, -27.946648 },
				{ 19.038702, 14.572520, -38.390671 },
				{ 19.704178, 16.331751, -45.886612 },
				{ 20.004011, 19.128130, -53.421867 },
				{ 21.045374, 25.227642, -60.787697 },
				{ 22.801613, 31.111900, -67.068665 },
				{ 24.249241, 35.682217, -73.315773 },
				{ 25.547836, 40.101151, -79.811272 },
				{ 26.858282, 44.392147, -86.431282 },
				{ 28.268349, 47.748821, -92.534111 },
				{ 29.797926, 50.983318, -98.277176 },
				{ 31.393112, 54.455765, -103.931427 },
				{ 33.007431, 58.105129, -109.601860 }
			},
			{
				{ 24.292648, -20.138687, 45.617935 },
				{ 24.971777, -16.802303, 29.347603 },
				{ 25.346998, -13.742940, 12.478652 },
				{ 21.122198, -13.227751, -9.132559 },
				{ 22.305494, -6.659871, -22.702999 },
				{ 23.011808, -1.123648, -32.047771 },
				{ 25.525679, -0.211187, -36.241470 },
				{ 25.756536, 4.644544, -44.602814 },
				{ 25.840973, 11.298232, -53.517941 },
				{ 26.829462, 16.430367, -60.688976 },
				{ 27.652020, 21.782227, -67.751640 },
				{ 28.910469, 26.301149, -74.379189 },
				{ 30.146084, 30.179363, -81.058609 },
				{ 31.579718, 33.976017, -87.102821 },
				{ 33.238701, 38.112206, -92.703529 },
				{ 34.947792, 42.564442, -98.278885 },
				{ 36.640854, 47.154568, -103.910927 }
			},
			{
				{ 30.301794, -32.328533, 53.148087 },
				{ 30.405544, -28.283329, 37.291245 },
				{ 29.676292, -25.656490, 20.496344 },
				{ 27.777134, -27.602325, 2.952641 },
				{ 27.557623, -25.159525, -12.110916 },
				{ 26.518534, -17.454735, -26.993191 },
				{ 28.999338, -10.260637, -33.469845 },
				{ 30.414633, -6.226771, -39.660065 },
				{ 30.276592, -2.275715, -47.689045 },
				{ 31.098280, 1.345354, -54.325443 },
				{ 31.976587, 5.175725, -60.724094 },
				{ 32.615475, 10.754633, -68.118881 },
				{ 33.737099, 14.980473, -74.908112 },
				{ 35.131855, 20.051573, -81.156303 },
				{ 36.868195, 25.572502, -86.913742 },
				{ 38.607178, 31.061434, -92.574371 },
				{ 40.259167, 36.369659, -98.238182 }
			},
			{
				{ 35.382980, -43.329361, 58.613159 },
				{ 35.207798, -39.057785, 43.838673 },
				{ 35.050964, -35.084080, 29.248339 },
				{ 34.968304, -35.820610, 14.351086 },
				{ 33.223244, -37.257790, -1.493230 },
				{ 30.949011, -31.828493, -17.702541 },
				{ 31.174631, -23.175850, -29.025476 },
				{ 32.263760, -20.181923, -37.010376 },
				{ 34.674049, -16.877617, -41.970982 },
				{ 35.586941, -12.644517, -47.552761 },
				{ 37.087936, -8.336677, -53.200623 },
				{ 37.083496, -3.730099, -61.019989 },
				{ 37.831272, 0.247786, -67.973015 },
				{ 39.022266, 6.754309, -74.784615 },
				{ 40.780113, 13.971962, -81.055656 },
				{ 42.366253, 20.086637, -86.884544 },
				{ 43.796871, 25.481882, -92.556931 }
			},
			{
				{ 39.948502, -52.952614, 62.897900 },
				{ 39.628967, -49.796329, 48.918201 },
				{ 39.688084, -46.726738, 35.430050 },
				{ 39.375797, -47.028996, 20.873234 },
				{ 38.475773, -48.905254, 6.884608 },
				{ 39.458763, -43.291008, -3.572394 },
				{ 39.489826, -36.093319, -14.410599 },
				{ 37.602917, -33.218281, -26.926895 },
				{ 38.817688, -33.080070, -34.469784 },
				{ 40.318954, -27.357950, -40.574001 },
				{ 41.810589, -20.104589, -46.785088 },
				{ 41.829170, -15.665214, -54.446774 },
				{ 41.763390, -12.290133, -61.611927 },
				{ 42.733498, -5.432084, -68.789139 },
				{ 44.726223, 3.366291, -75.443398 },
				{ 46.009464, 9.140537, -81.228241 },
				{ 47.211384, 14.207494, -86.838799 }
			},
			{
				{ 44.469303, -60.942226, 67.033600 },
				{ 44.072899, -59.545395, 53.454151 },
				{ 43.589680, -59.275539, 39.789970 },
				{ 44.173740, -56.968903, 27.566654 },
				{ 44.255180, -55.819550, 15.700629 },
				{ 45.512672, -49.237385, 6.715030 },
				{ 50.048660, -35.835350, 1.199268 },
				{ 48.057964, -35.218792, -10.832495 },
				{ 44.178928, -40.510128, -25.550926 },
				{ 43.465389, -37.455090, -35.874447 },
				{ 43.969254, -30.261490, -43.930126 },
				{ 43.710777, -25.991590, -51.519974 },
				{ 46.010311, -23.513035, -55.455326 },
				{ 46.719158, -15.558161, -63.210384 },
				{ 48.003292, -7.677940, -70.166420 },
				{ 49.113945, -2.992069, -75.562256 },
				{ 50.520443, 2.628662, -81.191345 }
			},
			{
				{ 49.053989, -67.339638, 71.702660 },
				{ 48.946247, -66.777161, 58.507133 },
				{ 49.001602, -65.950226, 45.870338 },
				{ 48.869263, -65.330559, 33.801479 },
				{ 48.924679, -63.406174, 23.124716 },
				{ 49.280014, -58.823711, 13.704093 },
				{ 51.454487, -51.239620, 6.639690 },
				{ 56.162136, -40.061489, 1.558339 },
				{ 51.062859, -46.689415, -14.372479 },
				{ 48.089073, -46.722515, -27.927631 },
				{ 46.953163, -37.322376, -40.044312 },
				{ 47.695263, -32.370831, -47.063793 },
				{ 49.674248, -30.064732, -51.138908 },
				{ 51.071812, -25.133070, -57.132317 },
				{ 51.369411, -20.790157, -63.808540 },
				{ 52.370518, -15.104189, -69.826317 },
				{ 53.715008, -8.912852, -75.826714 }
			},
			{
				{ 53.667492, -72.006172, 77.333694 },
				{ 53.578102, -73.069977, 63.819088 },
				{ 53.328735, -74.379608, 50.613174 },
				{ 53.386139, -73.728226, 39.010635 },
				{ 53.820370, -70.681190, 29.347925 },
				{ 53.410606, -68.602669, 19.635309 },
				{ 53.799366, -64.811562, 11.000597 },
				{ 56.047768, -57.881500, 4.115935 },
				{ 55.462044, -56.289005, -6.353141 },
				{ 55.409985, -53.160442, -16.191645 },
				{ 52.973038, -49.084675, -28.795504 },
				{ 55.926296, -39.643646, -34.678410 },
				{ 53.981461, -36.194904, -43.723473 },
				{ 55.459995, -34.598022, -49.395664 },
				{ 55.411591, -32.031933, -56.859909 },
				{ 55.956169, -26.336586, -63.916164 },
				{ 56.728645, -20.625961, -70.475304 }
			},
			{
				{ 58.033115, -75.756813, 83.591255 },
				{ 57.842823, -78.319115, 69.722427 },
				{ 57.442631, -81.830055, 55.419949 },
				{ 57.309395, -82.678490, 43.329327 },
				{ 57.720406, -78.288940, 34.737045 },
				{ 58.630104, -72.702286, 26.867136 },
				{ 59.379299, -68.129593, 18.479708 },
				{ 60.060944, -64.735535, 10.138718 },
				{ 60.293015, -61.901642, 1.722394 },
				{ 61.385609, -56.515881, -6.036154 },
				{ 61.516903, -51.733845, -14.463455 },
				{ 64.376671, -39.633358, -21.465460 },
				{ 64.010742, -35.625416, -29.963118 },
				{ 62.376034, -36.676537, -39.230270 },
				{ 60.101643, -38.940693, -48.788219 },
				{ 59.948208, -35.420223, -56.903278 },
				{ 60.187248, -30.912054, -64.303490 }
			},
			{
				{ 62.056602, -79.679520, 89.683746 },
				{ 61.869900, -81.927528, 76.714905 },
				{ 61.526600, -85.526810, 62.680946 },
				{ 61.350494, -88.479546, 49.023941 },
				{ 61.813396, -82.389336, 41.596577 },
				{ 63.236813, -77.776184, 33.562771 },
				{ 63.261086, -75.461021, 23.811033 },
				{ 64.299416, -69.526375, 15.783103 },
				{ 65.437401, -63.085815, 8.809142 },
				{ 67.781418, -55.276165, 2.801233 },
				{ 69.307442, -48.943413, -3.321628 },
				{ 70.953491, -40.664391, -10.525912 },
				{ 69.428200, -39.737701, -19.786943 },
				{ 67.989159, -39.293697, -29.585358 },
				{ 67.638527, -39.054317, -38.505459 },
				{ 65.973038, -38.841251, -48.043533 },
				{ 64.923340, -37.894558, -56.554012 }
			},
			{
				{ 65.737114, -84.598015, 94.810410 },
				{ 65.540222, -85.533203, 83.544983 },
				{ 65.230560, -86.721992, 72.204872 },
				{ 65.257118, -89.631004, 58.255112 },
				{ 65.439896, -88.250008, 47.650379 },
				{ 65.553215, -89.119293, 37.287495 },
				{ 65.257912, -88.506767, 26.953806 },
				{ 66.427071, -80.770760, 19.825281 },
				{ 70.421585, -66.107765, 15.927446 },
				{ 71.516235, -58.012222, 9.095668 },
				{ 75.344673, -48.974476, 4.611082 },
				{ 74.737366, -47.086361, -2.869295 },
				{ 74.877426, -44.999966, -10.993717 },
				{ 73.819298, -44.693714, -20.385696 },
				{ 73.416718, -40.986900, -29.807699 },
				{ 71.755127, -41.214722, -39.230854 },
				{ 70.695229, -42.077965, -47.422150 }
			},
			{
				{ 69.072258, -90.534775, 98.886292 },
				{ 69.056961, -90.705116, 87.911491 },
				{ 68.979012, -90.894714, 76.869583 },
				{ 69.024605, -92.041595, 64.912987 },
				{ 69.304054, -93.726433, 53.204182 },
				{ 69.522881, -94.200539, 43.293697 },
				{ 69.556480, -93.220123, 33.719936 },
				{ 71.453629, -83.581116, 27.105017 },
				{ 76.917679, -65.015106, 24.520969 },
				{ 78.577454, -56.272324, 18.225880 },
				{ 78.572884, -54.228306, 10.668219 },
				{ 77.995499, -57.547890, 5.408533 },
				{ 78.411736, -53.483692, -4.360085 },
				{ 78.496071, -49.117741, -13.108184 },
				{ 78.135521, -46.280880, -21.312641 },
				{ 77.623795, -45.354427, -29.477657 },
				{ 76.794304, -45.041386, -37.654995 }
			},
			{
				{ 72.075340, -97.406487, 101.929771 },
				{ 72.407211, -97.152084, 90.723274 },
				{ 72.667000, -96.972237, 79.360672 },
				{ 72.971550, -96.240379, 69.481636 },
				{ 73.393394, -95.540085, 60.153633 },
				{ 73.849358, -95.912552, 50.358929 },
				{ 74.528046, -94.122581, 41.292908 },
				{ 76.500092, -85.317551, 34.320076 },
				{ 79.044769, -73.388412, 28.958109 },
				{ 80.833748, -64.972137, 22.744417 },
				{ 80.788940, -63.750832, 14.804865 },
				{ 80.836174, -63.386673, 7.686352 },
				{ 81.646385, -59.193317, 0.212945 },
				{ 82.911789, -52.774822, -6.272336 },
				{ 83.513535, -49.207619, -12.943359 },
				{ 82.804749, -48.579193, -20.900297 },
				{ 82.299706, -47.889545, -28.673395 }
			},
			{
				{ 74.799271, -105.043137, 104.165260 },
				{ 75.675255, -103.756248, 93.705460 },
				{ 76.567032, -102.202591, 83.565628 },
				{ 77.554558, -99.933395, 74.484726 },
				{ 78.617561, -97.505600, 65.860451 },
				{ 79.620697, -95.552521, 57.026375 },
				{ 80.554436, -92.507607, 48.704605 },
				{ 81.842400, -86.657944, 41.410156 },
				{ 82.850945, -80.363754, 34.571987 },
				{ 83.029381, -75.999786, 27.154219 },
				{ 83.220375, -72.820343, 19.049273 },
				{ 84.532372, -68.817284, 12.205650 },
				{ 85.923851, -63.227489, 6.058865 },
				{ 86.832962, -57.249149, -0.034191 },
				{ 88.269928, -52.623829, -5.252475 },
				{ 87.259964, -52.059555, -13.713599 },
				{ 86.813766, -51.339622, -21.334677 }
			},
			{
				{ 77.385391, -113.011169, 106.109253 },
				{ 78.937599, -110.230659, 96.961586 },
				{ 80.608109, -107.050621, 88.106422 },
				{ 82.468857, -103.218445, 79.631317 },
				{ 84.396355, -98.898643, 71.429558 },
				{ 86.028198, -94.532646, 63.464943 },
				{ 86.991661, -90.664894, 55.861614 },
				{ 87.681717, -87.002808, 48.568203 },
				{ 88.304604, -83.485542, 41.308357 },
				{ 88.612885, -80.697365, 33.686573 },
				{ 88.476112, -78.461243, 25.592838 },
				{ 89.653885, -73.213661, 18.767080 },
				{ 91.629936, -65.628807, 13.180240 },
				{ 92.446182, -60.526260, 7.562860 },
				{ 92.675156, -57.211643, 1.782133 },
				{ 91.726112, -56.188511, -6.286141 },
				{ 91.172867, -54.933483, -14.135710 }
			}
		},
		{
			{
				{ 6.117427, 35.947819, 14.820762 },
				{ 5.893884, 38.959026, -2.062465 },
				{ 6.399037, 42.215172, -17.978819 },
				{ 7.309673, 45.956497, -32.407795 },
				{ 8.160170, 49.880272, -45.076698 },
				{ 9.032639, 53.327087, -55.509731 },
				{ 10.112206, 56.424629, -63.986366 },
				{ 11.657075, 59.045643, -70.162193 },
				{ 13.746931, 61.395958, -74.579277 },
				{ 16.117617, 64.200249, -78.577148 },
				{ 18.423384, 67.656410, -83.038132 },
				{ 20.479229, 71.191856, -88.062233 },
				{ 22.220304, 74.394951, -93.552605 },
				{ 23.707523, 77.081543, -99.372604 },
				{ 25.046595, 79.266182, -105.330353 },
				{ 26.327345, 81.108589, -111.287659 },
				{ 27.596712, 82.810242, -117.214798 }
			},
			{
				{ 13.252975, 20.825071, 28.595383 },
				{ 13.102325, 23.563944, 10.929248 },
				{ 13.628094, 26.082235, -6.209916 },
				{ 13.964641, 30.279911, -22.407536 },
				{ 14.748767, 36.146362, -36.163464 },
				{ 15.362448, 41.678211, -48.303669 },
				{ 16.265064, 42.768356, -55.843605 },
				{ 17.210234, 44.025738, -61.183208 },
				{ 18.729355, 46.459003, -65.575394 },
				{ 21.122395, 50.734577, -70.330544 },
				{ 23.072115, 55.912136, -76.204330 },
				{ 24.539829, 59.862236, -82.278366 },
				{ 25.830883, 62.628979, -88.348663 },
				{ 27.108751, 64.884575, -94.304382 },
				{ 28.406799, 66.992622, -100.122665 },
				{ 29.731779, 69.140213, -105.862144 },
				{ 31.071486, 71.347107, -111.582214 }
			},
			{
				{ 20.369745, 6.414908, 41.201965 },
				{ 21.389925, 8.453310, 24.397776 },
				{ 21.098978, 10.288438, 6.139821 },
				{ 20.296091, 14.809955, -12.231910 },
				{ 21.618414, 21.086046, -25.679499 },
				{ 21.729513, 30.068419, -41.484005 },
				{ 22.393785, 29.059818, -47.079258 },
				{ 22.804136, 29.010675, -51.641048 },
				{ 23.482136, 32.723495, -57.484764 },
				{ 25.562777, 38.892490, -63.603535 },
				{ 27.275627, 44.531635, -70.156166 },
				{ 28.217356, 48.496689, -76.942970 },
				{ 29.200363, 50.568298, -83.462608 },
				{ 30.390774, 52.362923, -89.331482 },
				{ 31.737116, 54.538116, -94.869263 },
				{ 33.146927, 57.172165, -100.388573 },
				{ 34.571205, 60.047916, -105.958771 }
			},
			{
				{ 26.813593, -6.628572, 51.259621 },
				{ 27.254398, -4.897876, 34.145210 },
				{ 26.920361, -4.127317, 16.370705 },
				{ 27.213533, 0.013652, 0.217647 },
				{ 25.932930, 3.803387, -15.362780 },
				{ 26.468689, 10.412895, -28.976486 },
				{ 28.689941, 10.341507, -32.836239 },
				{ 28.267767, 16.074833, -42.428177 },
				{ 28.402294, 21.692791, -50.986946 },
				{ 29.677740, 26.289900, -57.848465 },
				{ 30.102207, 30.163527, -65.247314 },
				{ 31.076159, 35.264580, -72.482704 },
				{ 32.229809, 37.540363, -78.971107 },
				{ 33.479908, 39.091278, -84.356598 },
				{ 35.042259, 41.817837, -89.467636 },
				{ 36.590073, 45.303188, -94.848785 },
				{ 38.100040, 49.090496, -100.394493 }
			},
			{
				{ 32.713120, -18.190170, 59.253136 },
				{ 33.290630, -14.952955, 43.378284 },
				{ 33.720337, -12.149815, 27.512030 },
				{ 32.290821, -12.725239, 9.619167 },
				{ 32.014450, -11.397281, -4.304647 },
				{ 30.590609, -8.117508, -18.336893 },
				{ 30.052258, -0.832760, -31.381868 },
				{ 32.298267, 4.022144, -37.471176 },
				{ 32.716778, 7.524209, -45.053165 },
				{ 33.341705, 11.049520, -52.027287 },
				{ 33.252228, 14.263353, -59.503117 },
				{ 34.148087, 20.085142, -67.178421 },
				{ 35.496361, 22.618231, -73.323410 },
				{ 36.638462, 25.095512, -78.745567 },
				{ 38.412300, 29.105349, -83.859283 },
				{ 40.068218, 33.739727, -89.324501 },
				{ 41.617702, 38.500278, -94.950722 }
			},
			{
				{ 37.967663, -28.549444, 65.396637 },
				{ 38.229401, -25.047834, 50.444592 },
				{ 38.319019, -22.512388, 35.039700 },
				{ 37.569790, -22.384356, 17.489845 },
				{ 37.830578, -22.407425, 4.507887 },
				{ 36.201469, -20.803926, -8.725446 },
				{ 36.625629, -16.630630, -19.736248 },
				{ 36.625729, -13.264974, -29.655960 },
				{ 36.678921, -7.156029, -39.327106 },
				{ 37.347450, -3.672858, -45.149693 },
				{ 38.903481, -0.336838, -51.196213 },
				{ 40.681744, 7.256486, -58.772343 },
				{ 39.771389, 7.527492, -65.686806 },
				{ 40.389866, 11.291424, -72.255295 },
				{ 41.952377, 16.964848, -78.226967 },
				{ 43.547684, 22.616028, -83.938889 },
				{ 45.059902, 28.049141, -89.618469 }
			},
			{
				{ 42.583622, -38.067104, 69.794952 },
				{ 41.814575, -36.201344, 54.283413 },
				{ 42.057808, -34.007038, 40.136242 },
				{ 41.347168, -33.577206, 24.083548 },
				{ 40.015553, -36.951336, 8.577510 },
				{ 42.291664, -34.696358, 0.885698 },
				{ 40.986336, -34.209999, -10.465726 },
				{ 40.619030, -28.104294, -22.339598 },
				{ 40.283878, -20.321503, -34.189342 },
				{ 41.458935, -15.368311, -40.039028 },
				{ 42.519115, -11.938332, -46.031265 },
				{ 43.535770, -7.938691, -52.590466 },
				{ 42.098309, -6.131143, -60.591217 },
				{ 43.635548, -0.951462, -66.976303 },
				{ 45.503895, 5.926448, -73.012840 },
				{ 46.922329, 11.745834, -78.715187 },
				{ 48.391708, 17.364552, -84.317299 }
			},
			{
				{ 47.036995, -46.502048, 73.542900 },
				{ 45.942348, -46.082409, 58.415070 },
				{ 46.001022, -45.082375, 45.053455 },
				{ 47.150772, -40.875179, 32.964401 },
				{ 46.656933, -42.582630, 18.784992 },
				{ 46.544106, -40.731865, 7.490370 },
				{ 45.632915, -39.982712, -3.381283 },
				{ 43.760845, -39.334488, -15.305373 },
				{ 42.637074, -36.541763, -28.112995 },
				{ 46.235989, -30.468437, -32.136845 },
				{ 45.312366, -22.974550, -41.571220 },
				{ 46.050228, -18.091856, -48.797886 },
				{ 48.021252, -13.571873, -54.257278 },
				{ 48.094105, -8.895799, -61.848476 },
				{ 48.674381, -4.315119, -68.238457 },
				{ 50.050194, 0.809479, -73.635086 },
				{ 51.620659, 6.252522, -79.035057 }
			},
			{
				{ 51.543526, -53.712116, 77.732307 },
				{ 51.096584, -53.475170, 63.787384 },
				{ 51.278469, -52.219025, 51.228817 },
				{ 51.592999, -50.980339, 39.192776 },
				{ 50.508759, -51.913673, 25.566275 },
				{ 50.779716, -47.775322, 14.718497 },
				{ 50.460659, -49.346107, 4.974362 },
				{ 52.683895, -45.378361, -2.137845 },
				{ 50.015160, -42.611443, -15.991169 },
				{ 50.598282, -40.046455, -24.457029 },
				{ 50.429485, -33.937263, -33.839947 },
				{ 50.135254, -28.094063, -42.750465 },
				{ 52.073410, -22.954578, -48.433609 },
				{ 52.339336, -18.396524, -55.676014 },
				{ 52.620033, -14.139872, -62.718872 },
				{ 53.608433, -9.319524, -68.450203 },
				{ 54.715168, -5.263414, -73.838264 }
			},
			{
				{ 55.849358, -59.723293, 82.601425 },
				{ 55.547173, -60.632198, 68.508591 },
				{ 55.270336, -60.885391, 55.096241 },
				{ 54.913963, -61.460869, 42.719887 },
				{ 55.091667, -59.845264, 32.330105 },
				{ 54.839176, -58.499714, 21.380018 },
				{ 55.312771, -56.543930, 12.063778 },
				{ 57.016434, -52.793331, 4.844398 },
				{ 56.181801, -50.056053, -5.819175 },
				{ 56.425949, -47.592072, -14.187377 },
				{ 57.388058, -41.293106, -22.873007 },
				{ 56.529896, -36.116417, -32.502850 },
				{ 55.933380, -33.262894, -40.853798 },
				{ 56.321426, -30.305681, -48.189648 },
				{ 56.346931, -26.734625, -55.683182 },
				{ 56.989059, -21.468363, -62.511627 },
				{ 57.574120, -17.170641, -68.690071 }
			},
			{
				{ 59.903015, -64.806206, 88.134560 },
				{ 59.755989, -66.852829, 74.196327 },
				{ 59.636536, -68.850616, 60.402405 },
				{ 59.094963, -69.401009, 48.409935 },
				{ 59.543911, -65.463264, 39.562447 },
				{ 60.389771, -62.404659, 29.811714 },
				{ 60.088875, -61.203682, 19.292044 },
				{ 60.586674, -58.971989, 10.769589 },
				{ 61.755909, -54.691498, 2.870778 },
				{ 62.393375, -51.545071, -4.703671 },
				{ 63.848419, -44.300224, -12.367669 },
				{ 64.527359, -36.153870, -20.806168 },
				{ 62.858212, -36.767944, -30.212439 },
				{ 61.295643, -36.521793, -39.707775 },
				{ 60.339752, -35.800167, -48.123539 },
				{ 59.933956, -32.129284, -56.536354 },
				{ 60.658714, -27.640661, -63.287815 }
			},
			{
				{ 63.782776, -69.623932, 93.882225 },
				{ 63.731552, -71.628716, 81.092323 },
				{ 63.504131, -74.707497, 67.094780 },
				{ 63.062969, -76.056816, 53.888214 },
				{ 63.966694, -68.212486, 47.465206 },
				{ 66.382332, -67.003174, 37.494850 },
				{ 63.898514, -69.552467, 24.974005 },
				{ 65.808250, -62.777843, 17.931005 },
				{ 67.418358, -55.238293, 10.817096 },
				{ 67.120087, -53.757187, 2.772894 },
				{ 70.598183, -44.876358, -2.051252 },
				{ 71.073242, -39.196213, -9.795617 },
				{ 69.541763, -39.132519, -19.476381 },
				{ 67.551247, -38.176109, -30.130148 },
				{ 67.145706, -35.998146, -38.809280 },
				{ 65.999161, -35.403130, -48.083221 },
				{ 65.046051, -34.754566, -56.433418 }
			},
			{
				{ 67.410187, -75.015121, 98.923820 },
				{ 67.417717, -75.712738, 87.904037 },
				{ 67.168678, -76.967239, 76.002457 },
				{ 66.517403, -78.757553, 62.952511 },
				{ 66.510544, -78.793877, 51.274174 },
				{ 67.254662, -80.184258, 39.615536 },
				{ 65.689796, -81.937576, 28.031570 },
				{ 68.151276, -72.911888, 22.359917 },
				{ 72.592911, -58.883945, 18.786095 },
				{ 72.562057, -54.633446, 10.408222 },
				{ 75.443489, -48.029518, 5.553681 },
				{ 75.764374, -44.613750, -1.603719 },
				{ 76.048904, -41.795113, -9.655909 },
				{ 74.588722, -40.935097, -19.920965 },
				{ 72.612289, -39.328579, -30.775398 },
				{ 70.989578, -38.724747, -40.560711 },
				{ 70.647972, -39.310246, -47.748615 }
			},
			{
				{ 70.670319, -81.230377, 102.820793 },
				{ 70.768417, -81.268265, 92.150124 },
				{ 70.632507, -81.402405, 80.943352 },
				{ 69.931236, -82.322960, 68.864792 },
				{ 69.941223, -83.397575, 56.925262 },
				{ 70.417656, -83.677147, 46.508537 },
				{ 70.502701, -84.892540, 35.746990 },
				{ 71.705818, -78.052948, 28.219292 },
				{ 76.312424, -63.918640, 24.908173 },
				{ 78.271812, -56.380417, 18.689669 },
				{ 78.267784, -54.270096, 10.610400 },
				{ 78.987938, -53.068668, 4.215909 },
				{ 78.376617, -50.977795, -4.442294 },
				{ 79.007057, -47.214874, -12.229679 },
				{ 77.253456, -47.001591, -21.928358 },
				{ 76.030365, -45.510624, -31.187033 },
				{ 76.746834, -42.874187, -37.900669 }
			},
			{
				{ 73.504074, -88.333054, 105.446938 },
				{ 73.817764, -88.464912, 94.174034 },
				{ 73.887596, -89.021172, 82.328743 },
				{ 73.705780, -88.505234, 72.284431 },
				{ 73.711349, -86.292145, 63.642597 },
				{ 74.190125, -88.290268, 53.019722 },
				{ 75.283180, -89.225739, 42.562611 },
				{ 75.617554, -83.192047, 34.117977 },
				{ 75.739449, -77.069138, 27.199215 },
				{ 78.473557, -68.527718, 21.565737 },
				{ 80.298340, -63.106682, 14.602099 },
				{ 81.485573, -59.949066, 7.846957 },
				{ 81.273026, -57.926449, 0.023018 },
				{ 83.259537, -51.539238, -5.420777 },
				{ 83.590004, -48.215237, -12.520311 },
				{ 82.350830, -48.019398, -21.265242 },
				{ 82.222519, -46.428806, -28.998222 }
			},
			{
				{ 75.946709, -96.302673, 107.006424 },
				{ 76.777214, -95.723610, 96.234734 },
				{ 77.553787, -94.934937, 85.663048 },
				{ 78.458504, -92.706795, 76.616440 },
				{ 79.532196, -89.893318, 68.163330 },
				{ 80.775505, -89.225510, 58.488800 },
				{ 80.822090, -89.103615, 49.285824 },
				{ 81.413612, -84.440170, 41.397675 },
				{ 82.748535, -78.715454, 34.620312 },
				{ 83.571503, -74.001213, 27.492136 },
				{ 82.875916, -71.246574, 18.660883 },
				{ 82.739861, -69.323509, 10.841211 },
				{ 84.551140, -63.994465, 5.136941 },
				{ 87.525040, -56.155907, 0.901207 },
				{ 88.706535, -51.101658, -4.419098 },
				{ 87.235985, -51.174274, -13.503173 },
				{ 86.467323, -50.501480, -21.896530 }
			},
			{
				{ 78.188950, -104.636948, 108.176056 },
				{ 79.764343, -102.678467, 98.639297 },
				{ 81.556129, -100.178947, 89.490028 },
				{ 83.763466, -96.793785, 80.791687 },
				{ 86.261673, -92.780998, 72.242188 },
				{ 88.330254, -88.553970, 63.959969 },
				{ 88.536469, -85.683426, 56.516510 },
				{ 89.089180, -81.890968, 49.490833 },
				{ 90.506927, -76.787773, 42.752247 },
				{ 91.018478, -74.347237, 35.295837 },
				{ 89.609779, -76.411629, 26.737776 },
				{ 89.351952, -75.411697, 19.480156 },
				{ 91.353775, -66.683777, 13.682072 },
				{ 92.155846, -60.122658, 7.800332 },
				{ 92.437271, -56.272587, 2.222061 },
				{ 92.050835, -54.660583, -5.662271 },
				{ 91.241249, -53.484787, -14.196399 }
			}
		},
		{
			{
				{ 10.707095, 44.296329, 22.264570 },
				{ 9.582357, 47.116425, 4.165955 },
				{ 9.344697, 49.907036, -13.057452 },
				{ 9.932414, 52.783264, -28.552025 },
				{ 10.786889, 55.483433, -41.635788 },
				{ 11.754217, 57.755638, -51.866360 },
				{ 12.687078, 60.073803, -60.158485 },
				{ 13.896039, 62.276489, -66.699982 },
				{ 15.718280, 64.336876, -71.503906 },
				{ 17.940336, 66.967033, -75.658241 },
				{ 20.178110, 70.275551, -80.068680 },
				{ 22.195814, 73.760109, -84.992401 },
				{ 23.933136, 76.938774, -90.368721 },
				{ 25.446825, 79.585373, -96.060616 },
				{ 26.818800, 81.708786, -101.889458 },
				{ 28.119102, 83.466110, -107.730003 },
				{ 29.396439, 85.066269, -113.549339 }
			},
			{
				{ 16.931627, 30.398083, 34.788761 },
				{ 15.719934, 32.841911, 16.028469 },
				{ 16.056419, 34.461609, -1.803600 },
				{ 16.079805, 37.564243, -19.140537 },
				{ 16.679523, 43.450367, -34.599125 },
				{ 17.722462, 49.045719, -47.173386 },
				{ 18.654381, 51.048634, -54.849335 },
				{ 19.359953, 50.634327, -59.157585 },
				{ 20.296001, 51.698154, -63.443348 },
				{ 22.498806, 55.818031, -68.415161 },
				{ 24.853622, 60.460167, -73.647797 },
				{ 26.594048, 63.873062, -79.154251 },
				{ 27.916265, 66.174141, -84.947403 },
				{ 29.128502, 68.118561, -90.808830 },
				{ 30.326269, 69.973000, -96.605354 },
				{ 31.535580, 71.824295, -102.335945 },
				{ 32.756138, 73.692207, -108.040939 }
			},
			{
				{ 23.055309, 16.577860, 46.212769 },
				{ 23.111469, 17.710171, 28.026049 },
				{ 23.506624, 18.832281, 9.911521 },
				{ 21.821501, 21.494846, -9.042798 },
				{ 22.587229, 30.472300, -25.795622 },
				{ 23.732210, 40.876972, -42.623028 },
				{ 25.159498, 42.060844, -49.435879 },
				{ 25.831684, 38.084431, -50.008224 },
				{ 25.511505, 39.220230, -54.887486 },
				{ 27.372240, 45.338188, -61.472576 },
				{ 29.621941, 50.892681, -67.507973 },
				{ 30.863405, 53.902603, -73.558647 },
				{ 31.730522, 55.212185, -79.779228 },
				{ 32.700447, 56.435398, -85.639671 },
				{ 33.780716, 58.081814, -91.292931 },
				{ 34.940487, 60.159584, -96.911156 },
				{ 36.136112, 62.456451, -102.548996 }
			},
			{
				{ 29.035896, 4.022204, 56.126595 },
				{ 28.875837, 4.347186, 37.627995 },
				{ 29.100513, 4.929775, 19.242447 },
				{ 29.217213, 9.093901, 3.175453 },
				{ 29.285755, 13.163331, -11.081565 },
				{ 29.500809, 23.155403, -28.693342 },
				{ 29.988817, 27.374083, -39.809654 },
				{ 30.447012, 26.835844, -42.662144 },
				{ 31.041098, 29.684601, -48.385685 },
				{ 32.451717, 34.826702, -55.232822 },
				{ 33.195190, 38.545525, -62.401005 },
				{ 34.009300, 41.820183, -69.100929 },
				{ 35.140533, 43.705582, -75.127678 },
				{ 36.074032, 44.248398, -80.477463 },
				{ 37.136875, 45.862499, -85.870399 },
				{ 38.317024, 48.485325, -91.449081 },
				{ 39.543102, 51.542999, -97.132965 }
			},
			{
				{ 35.027088, -6.655026, 64.721664 },
				{ 35.302830, -5.447665, 47.688728 },
				{ 35.570236, -5.126636, 30.879288 },
				{ 35.372959, -4.804170, 14.799982 },
				{ 33.731850, -1.317551, -1.638667 },
				{ 33.247227, 2.411989, -16.210724 },
				{ 33.262104, 6.621255, -28.132992 },
				{ 35.875023, 12.548450, -33.438358 },
				{ 35.806538, 17.245914, -42.039570 },
				{ 36.240868, 20.311512, -49.192459 },
				{ 34.897896, 21.108482, -57.407478 },
				{ 35.794003, 26.992933, -65.070366 },
				{ 38.105282, 30.508247, -70.154297 },
				{ 39.238636, 31.058859, -74.965591 },
				{ 40.377071, 33.282185, -80.315880 },
				{ 41.640770, 36.917545, -86.028687 },
				{ 42.952545, 41.057354, -91.866898 }
			},
			{
				{ 40.546551, -16.096222, 71.734032 },
				{ 41.001419, -13.829608, 56.168636 },
				{ 41.156357, -12.209064, 39.899822 },
				{ 40.262371, -11.646186, 22.712091 },
				{ 40.208672, -11.247257, 9.382845 },
				{ 40.127583, -7.829805, -3.174876 },
				{ 39.072105, -4.325335, -16.219755 },
				{ 38.849461, -1.279088, -26.618858 },
				{ 39.910522, 3.232552, -34.756752 },
				{ 40.512218, 5.471983, -41.606331 },
				{ 40.166744, 7.599446, -49.787891 },
				{ 40.860252, 14.236703, -58.046238 },
				{ 41.088654, 15.097255, -63.849014 },
				{ 42.202866, 17.018044, -69.174072 },
				{ 43.496704, 20.762781, -74.853607 },
				{ 44.885807, 25.672092, -80.784187 },
				{ 46.316307, 30.874447, -86.756996 }
			},
			{
				{ 45.614639, -24.851767, 76.975853 },
				{ 45.390110, -23.277182, 61.306782 },
				{ 46.011768, -21.443399, 46.862160 },
				{ 44.849285, -21.075546, 30.974430 },
				{ 44.437298, -21.020803, 16.905884 },
				{ 47.073944, -17.572451, 7.884696 },
				{ 44.965736, -15.894739, -5.184340 },
				{ 43.632275, -12.967040, -18.478067 },
				{ 44.082035, -8.923743, -28.555559 },
				{ 44.456299, -6.394733, -36.134048 },
				{ 43.784477, -3.534443, -44.702549 },
				{ 43.919510, 1.131871, -52.438583 },
				{ 44.144886, 1.750177, -58.306221 },
				{ 45.247787, 5.401462, -64.364204 },
				{ 46.595852, 9.448371, -69.867569 },
				{ 48.072289, 14.969698, -75.791725 },
				{ 49.583660, 20.607580, -81.712059 }
			},
			{
				{ 50.194347, -33.295071, 80.763428 },
				{ 48.860954, -32.877495, 64.851059 },
				{ 49.810799, -30.240261, 52.694321 },
				{ 50.640705, -26.100996, 40.253532 },
				{ 50.157616, -27.537136, 25.249853 },
				{ 49.026108, -29.550589, 11.674026 },
				{ 49.092258, -28.624846, 1.578097 },
				{ 49.369507, -25.485924, -8.439925 },
				{ 48.527477, -21.890715, -19.766565 },
				{ 48.402042, -19.807060, -28.348969 },
				{ 48.232021, -17.383524, -36.852726 },
				{ 48.826012, -11.410976, -44.860954 },
				{ 49.687580, -5.448225, -52.348354 },
				{ 49.346352, -1.959749, -59.923801 },
				{ 49.928707, -0.272119, -65.225433 },
				{ 51.345531, 5.159173, -71.094276 },
				{ 52.711761, 9.832692, -76.621399 }
			},
			{
				{ 54.488121, -41.062225, 84.515785 },
				{ 54.371887, -40.398663, 70.833443 },
				{ 53.901814, -39.805305, 57.530670 },
				{ 53.949074, -37.950287, 45.224892 },
				{ 52.946053, -38.904533, 30.403837 },
				{ 52.271019, -40.331539, 16.728401 },
				{ 53.168968, -38.016598, 7.730191 },
				{ 54.384945, -35.149933, -0.256731 },
				{ 54.408772, -30.346960, -10.344239 },
				{ 52.329811, -30.823452, -21.300188 },
				{ 52.411316, -29.920118, -29.627213 },
				{ 52.748158, -23.192673, -38.435997 },
				{ 53.615620, -16.190615, -45.918034 },
				{ 53.682907, -11.425670, -53.756401 },
				{ 54.272861, -7.261932, -60.725849 },
				{ 55.009026, -3.584035, -66.458420 },
				{ 55.647671, -1.845111, -71.360580 }
			},
			{
				{ 58.071800, -48.417160, 88.119751 },
				{ 57.269974, -49.669910, 73.302147 },
				{ 56.794724, -50.315701, 59.573555 },
				{ 57.054409, -49.004337, 48.398468 },
				{ 57.232655, -47.555058, 37.029331 },
				{ 57.144775, -47.809032, 24.535660 },
				{ 57.603428, -45.156918, 14.391821 },
				{ 56.775166, -46.056362, 4.309736 },
				{ 57.235924, -43.640347, -3.693494 },
				{ 57.413372, -40.332829, -12.530519 },
				{ 57.546902, -36.649410, -21.307673 },
				{ 56.743481, -32.753578, -31.234413 },
				{ 57.004059, -29.137123, -38.882950 },
				{ 56.997078, -23.286909, -47.461830 },
				{ 57.581593, -19.634535, -54.165333 },
				{ 58.081001, -17.309996, -59.861950 },
				{ 58.394150, -14.136488, -66.028763 }
			},
			{
				{ 61.607265, -54.816444, 92.444824 },
				{ 61.417789, -55.693195, 78.949890 },
				{ 61.551476, -55.917877, 66.533539 },
				{ 61.205612, -55.498501, 54.760303 },
				{ 61.594288, -53.442921, 44.310970 },
				{ 61.539337, -53.988415, 32.301243 },
				{ 61.338734, -53.224430, 21.210047 },
				{ 61.464565, -52.282013, 11.880844 },
				{ 62.199913, -47.826813, 3.568025 },
				{ 60.851231, -47.994034, -6.391453 },
				{ 62.482910, -42.265194, -13.491266 },
				{ 62.275589, -38.345013, -22.389015 },
				{ 61.028782, -37.700050, -31.739872 },
				{ 62.088795, -32.425533, -39.028954 },
				{ 61.589737, -29.421883, -47.035549 },
				{ 60.797390, -27.716232, -54.819675 },
				{ 61.354637, -24.202702, -61.407238 }
			},
			{
				{ 65.263206, -60.497536, 97.427719 },
				{ 65.541512, -60.596855, 85.875511 },
				{ 65.851593, -60.301262, 74.786125 },
				{ 65.233932, -59.681248, 62.729923 },
				{ 65.687546, -57.667736, 51.865322 },
				{ 65.832825, -60.677723, 39.036873 },
				{ 65.176994, -61.039711, 27.534039 },
				{ 66.595627, -56.105263, 20.245136 },
				{ 67.747414, -51.072182, 11.842639 },
				{ 66.901131, -51.078220, 2.589370 },
				{ 68.505608, -45.724178, -3.847238 },
				{ 69.600746, -39.492409, -11.589989 },
				{ 68.343346, -38.497150, -21.409761 },
				{ 68.064705, -36.252441, -29.644789 },
				{ 67.760056, -33.222675, -37.696499 },
				{ 65.859482, -32.256382, -47.743076 },
				{ 65.205177, -31.146301, -55.989521 }
			},
			{
				{ 68.830605, -66.133865, 102.295685 },
				{ 69.277855, -65.385056, 92.797516 },
				{ 69.570038, -64.735893, 82.553261 },
				{ 68.304474, -65.415176, 69.994453 },
				{ 68.176727, -65.907387, 57.017563 },
				{ 68.970131, -66.520721, 44.473366 },
				{ 68.951057, -67.513199, 33.584301 },
				{ 70.112953, -63.742645, 25.868015 },
				{ 70.617668, -58.695599, 17.562489 },
				{ 72.672623, -52.127785, 10.763945 },
				{ 73.728226, -49.131294, 4.210668 },
				{ 74.570709, -44.301090, -3.301145 },
				{ 75.832809, -39.344677, -10.177533 },
				{ 74.937584, -38.066475, -19.211422 },
				{ 73.133118, -36.426620, -29.538193 },
				{ 71.465042, -35.424408, -39.799858 },
				{ 70.664848, -36.130226, -47.815746 }
			},
			{
				{ 72.070488, -72.329025, 106.125923 },
				{ 72.470345, -71.821289, 96.728493 },
				{ 72.568130, -72.002190, 85.981384 },
				{ 71.573715, -73.897270, 72.466797 },
				{ 71.502594, -72.186699, 61.294292 },
				{ 72.113678, -70.773376, 51.181156 },
				{ 71.771637, -73.720551, 39.430214 },
				{ 71.637932, -73.200218, 29.580080 },
				{ 75.745583, -62.231239, 25.299610 },
				{ 79.491180, -52.470627, 19.990473 },
				{ 76.097382, -56.562153, 8.700616 },
				{ 76.466805, -55.638657, 1.443376 },
				{ 78.272491, -48.042385, -4.690130 },
				{ 78.992287, -44.276165, -11.720604 },
				{ 77.746315, -43.551891, -21.316235 },
				{ 77.308472, -41.368240, -30.039696 },
				{ 77.051773, -39.798817, -37.674088 }
			},
			{
				{ 74.830170, -79.429886, 108.488655 },
				{ 75.287315, -79.591125, 98.027199 },
				{ 75.399078, -80.668465, 86.362595 },
				{ 74.938820, -81.565163, 74.632843 },
				{ 74.518730, -79.253998, 65.792290 },
				{ 74.785667, -82.343147, 54.857883 },
				{ 75.250526, -84.416733, 43.726566 },
				{ 75.042877, -80.134140, 34.712891 },
				{ 77.891724, -70.900543, 29.811001 },
				{ 81.405296, -62.820969, 24.260235 },
				{ 80.126129, -61.717327, 14.680842 },
				{ 81.312592, -57.978424, 7.760292 },
				{ 82.065132, -54.029743, 1.074864 },
				{ 83.490257, -49.061722, -4.567120 },
				{ 83.856453, -46.202591, -11.797847 },
				{ 82.363029, -46.087372, -21.320351 },
				{ 81.370270, -45.175522, -30.005693 }
			},
			{
				{ 77.127289, -87.391907, 109.625977 },
				{ 77.975044, -87.307503, 99.066124 },
				{ 78.750832, -87.096779, 88.537422 },
				{ 79.445038, -85.755295, 78.952095 },
				{ 80.163101, -83.276100, 70.334534 },
				{ 81.768799, -83.736168, 59.865997 },
				{ 81.561165, -84.907997, 50.180916 },
				{ 80.580643, -81.744545, 41.437111 },
				{ 81.857925, -75.681305, 34.722118 },
				{ 84.016594, -70.599365, 28.626301 },
				{ 83.865601, -68.807426, 20.295877 },
				{ 83.236534, -66.896507, 11.674018 },
				{ 84.587769, -62.824379, 5.563080 },
				{ 87.263138, -55.302902, 1.523878 },
				{ 88.864319, -49.537407, -3.730699 },
				{ 87.527359, -49.226357, -12.940825 },
				{ 86.225815, -49.004475, -22.283945 }
			},
			{
				{ 79.185631, -95.669052, 110.324493 },
				{ 80.637337, -94.798019, 100.264923 },
				{ 82.386795, -93.366081, 90.679993 },
				{ 84.742004, -90.988647, 81.696899 },
				{ 87.596840, -87.876350, 72.928963 },
				{ 89.754982, -84.368439, 64.778366 },
				{ 89.771133, -81.264816, 58.014950 },
				{ 90.401199, -77.021202, 50.793304 },
				{ 91.533852, -72.318443, 43.674297 },
				{ 91.246941, -70.822891, 36.111324 },
				{ 90.702904, -72.597351, 28.245832 },
				{ 89.608337, -72.956856, 20.222080 },
				{ 89.934181, -67.612831, 13.522446 },
				{ 90.224098, -61.363117, 7.372761 },
				{ 91.846024, -55.596848, 2.344141 },
				{ 92.679237, -52.197529, -4.593371 },
				{ 91.863312, -50.718525, -13.423651 }
			}
		},
		{
			{
				{ 15.171535, 51.116253, 29.247040 },
				{ 13.184265, 53.655426, 10.040959 },
				{ 12.268023, 55.747299, -8.103042 },
				{ 12.539178, 57.786572, -24.019669 },
				{ 13.536759, 59.653328, -36.976196 },
				{ 14.861300, 61.194454, -46.901623 },
				{ 15.906568, 62.857727, -54.942768 },
				{ 16.731459, 64.942108, -61.959385 },
				{ 17.953699, 67.301559, -67.822151 },
				{ 19.759565, 70.029198, -72.702095 },
				{ 21.691589, 73.108086, -77.424980 },
				{ 23.520828, 76.262222, -82.401085 },
				{ 25.227987, 79.166588, -87.665993 },
				{ 26.841341, 81.663177, -93.141373 },
				{ 28.352764, 83.773315, -98.748573 },
				{ 29.784285, 85.606918, -104.408379 },
				{ 31.180830, 87.313736, -110.075226 }
			},
			{
				{ 21.261637, 38.234680, 41.471004 },
				{ 19.060095, 41.288086, 21.999981 },
				{ 18.521610, 41.663757, 2.681612 },
				{ 18.161961, 43.639877, -15.418224 },
				{ 18.670986, 47.701458, -30.575905 },
				{ 20.150053, 51.520092, -41.543777 },
				{ 21.436949, 53.452507, -48.948563 },
				{ 21.302105, 54.156902, -55.182590 },
				{ 21.349895, 56.711468, -61.973763 },
				{ 23.898972, 60.402199, -66.968475 },
				{ 26.034878, 63.599335, -71.613258 },
				{ 27.931141, 66.333344, -76.471306 },
				{ 29.551073, 68.672974, -81.815178 },
				{ 30.894396, 70.761086, -87.488281 },
				{ 32.099747, 72.703857, -93.256027 },
				{ 33.274307, 74.538414, -99.004990 },
				{ 34.452766, 76.324120, -104.729774 }
			},
			{
				{ 27.177967, 25.088507, 52.604343 },
				{ 26.595186, 26.501245, 33.880806 },
				{ 25.253735, 27.651640, 13.637393 },
				{ 23.939644, 29.332691, -5.733518 },
				{ 24.005289, 34.742844, -22.471970 },
				{ 24.747044, 41.307941, -35.755970 },
				{ 26.492706, 44.182671, -43.357246 },
				{ 26.683985, 43.314285, -47.748383 },
				{ 25.927219, 46.119778, -54.885841 },
				{ 27.955147, 50.654915, -61.218723 },
				{ 30.016973, 53.777687, -65.999290 },
				{ 32.211445, 56.033436, -70.546143 },
				{ 33.892796, 57.911919, -75.906326 },
				{ 34.887390, 59.721371, -81.839706 },
				{ 35.773895, 61.544067, -87.767387 },
				{ 36.728828, 63.437710, -93.601669 },
				{ 37.737415, 65.411476, -99.400803 }
			},
			{
				{ 32.425632, 13.047461, 61.907333 },
				{ 32.192646, 13.417386, 43.326698 },
				{ 31.999411, 14.630102, 24.588945 },
				{ 31.293152, 16.657337, 7.423706 },
				{ 29.901037, 19.823711, -10.294174 },
				{ 29.688967, 26.047039, -24.850920 },
				{ 30.260469, 31.253548, -35.484772 },
				{ 30.827305, 34.704765, -42.106960 },
				{ 32.320198, 36.537331, -47.427418 },
				{ 32.981220, 40.332851, -54.542152 },
				{ 35.034164, 43.040806, -59.597843 },
				{ 36.420361, 45.087776, -64.866692 },
				{ 37.947441, 46.660324, -70.192055 },
				{ 38.599728, 48.400932, -76.285400 },
				{ 39.265736, 50.107998, -82.277138 },
				{ 40.104942, 52.245724, -88.205627 },
				{ 41.046600, 54.714027, -94.132919 }
			},
			{
				{ 37.531731, 2.593933, 69.721901 },
				{ 37.463905, 2.872678, 51.723965 },
				{ 37.201969, 3.013987, 33.766075 },
				{ 37.509560, 4.776138, 18.107302 },
				{ 38.172981, 8.242288, 5.262514 },
				{ 37.501213, 10.959918, -9.005936 },
				{ 36.959965, 15.151305, -22.063185 },
				{ 37.387924, 22.292717, -31.339088 },
				{ 38.650356, 25.566254, -39.489643 },
				{ 37.890347, 27.508865, -47.741676 },
				{ 38.273308, 28.735567, -54.026772 },
				{ 39.594414, 33.506180, -60.187843 },
				{ 41.049297, 35.999172, -65.448822 },
				{ 41.824013, 36.613098, -70.896454 },
				{ 42.492027, 38.147324, -76.783173 },
				{ 43.364883, 40.982307, -82.870796 },
				{ 44.374760, 44.379299, -88.986977 }
			},
			{
				{ 42.790516, -6.138625, 76.707527 },
				{ 42.778091, -5.036102, 59.491562 },
				{ 42.433228, -3.941388, 42.096657 },
				{ 42.018017, -2.455482, 25.927553 },
				{ 42.191715, -2.689432, 13.407433 },
				{ 41.639065, 0.134130, -0.901397 },
				{ 42.113083, 2.398638, -10.752243 },
				{ 42.672859, 6.067034, -20.476099 },
				{ 41.972488, 11.961906, -32.798065 },
				{ 41.614632, 14.624765, -41.030437 },
				{ 42.371067, 17.767159, -48.470436 },
				{ 43.854500, 23.896564, -55.175255 },
				{ 44.537907, 24.921423, -60.322296 },
				{ 44.696152, 23.731743, -65.442490 },
				{ 45.428848, 25.912668, -71.433609 },
				{ 46.498661, 29.978226, -77.732872 },
				{ 47.684959, 34.399353, -83.985207 }
			},
			{
				{ 48.443211, -13.763400, 83.100700 },
				{ 49.048397, -11.886261, 67.393929 },
				{ 48.232689, -11.600213, 50.838352 },
				{ 47.592499, -11.415878, 35.344753 },
				{ 47.301178, -11.016311, 21.771540 },
				{ 47.310440, -10.606135, 9.277176 },
				{ 46.379341, -7.346323, -4.178150 },
				{ 46.044380, -4.976894, -15.671826 },
				{ 46.125404, -1.614655, -24.791096 },
				{ 45.939636, 1.987963, -34.185513 },
				{ 46.903042, 7.021880, -42.067520 },
				{ 47.683537, 10.617798, -48.526707 },
				{ 47.247673, 10.979310, -54.847706 },
				{ 47.399441, 12.142595, -60.668274 },
				{ 48.368065, 15.156878, -66.599556 },
				{ 49.621460, 19.712208, -72.862183 },
				{ 50.900509, 24.426441, -79.053558 }
			},
			{
				{ 53.601414, -21.582518, 88.228249 },
				{ 55.233204, -19.140266, 76.047493 },
				{ 53.284317, -19.360411, 59.235271 },
				{ 52.859161, -18.252472, 44.039158 },
				{ 51.767754, -18.063086, 28.789248 },
				{ 51.092236, -19.359201, 15.909953 },
				{ 51.309685, -19.108953, 4.747419 },
				{ 47.998795, -17.938093, -10.139971 },
				{ 50.830948, -12.553975, -16.718109 },
				{ 49.399464, -10.220109, -27.653168 },
				{ 50.038750, -6.498425, -35.645332 },
				{ 50.813366, -2.248663, -42.617889 },
				{ 51.190628, 1.470468, -50.086159 },
				{ 51.287117, 4.893336, -56.851318 },
				{ 51.798454, 6.241453, -62.064316 },
				{ 52.865971, 10.077030, -68.116974 },
				{ 53.933735, 13.956697, -74.051910 }
			},
			{
				{ 57.278793, -29.996033, 91.362312 },
				{ 57.595490, -29.353128, 78.487595 },
				{ 56.548031, -29.083374, 64.151001 },
				{ 56.800190, -27.309122, 50.746315 },
				{ 55.671963, -28.065762, 35.564526 },
				{ 55.603096, -29.264875, 22.556105 },
				{ 56.040783, -26.968807, 12.175274 },
				{ 56.549759, -23.928793, 3.228627 },
				{ 56.381752, -21.431168, -6.146933 },
				{ 53.510220, -20.475225, -20.143126 },
				{ 53.807690, -18.992413, -28.675516 },
				{ 53.932957, -13.806589, -37.128368 },
				{ 54.572479, -8.528724, -44.745586 },
				{ 55.340500, -4.466234, -51.506386 },
				{ 55.806858, -2.130621, -57.296227 },
				{ 56.238010, 0.206538, -63.146770 },
				{ 56.781776, 2.631722, -68.816124 }
			},
			{
				{ 60.212791, -38.157043, 93.894127 },
				{ 59.004967, -39.748547, 79.028137 },
				{ 58.427048, -40.548615, 65.431190 },
				{ 59.221722, -38.578388, 53.908398 },
				{ 59.586029, -37.849182, 41.343948 },
				{ 59.799694, -36.591976, 29.293777 },
				{ 59.291435, -34.919460, 17.853476 },
				{ 58.275642, -36.011017, 7.267899 },
				{ 60.265091, -30.709497, 0.247331 },
				{ 59.653801, -30.008652, -9.740839 },
				{ 59.087433, -28.004183, -19.368567 },
				{ 58.680794, -24.212685, -29.286285 },
				{ 58.550449, -20.458855, -37.477718 },
				{ 58.685211, -14.988180, -45.839081 },
				{ 59.020531, -12.147471, -52.348736 },
				{ 59.427055, -11.565362, -57.178921 },
				{ 59.587574, -9.141247, -63.458073 }
			},
			{
				{ 63.315788, -45.372917, 97.079887 },
				{ 63.099751, -45.481800, 83.646675 },
				{ 63.585030, -44.479496, 71.680115 },
				{ 63.068180, -44.278141, 59.714535 },
				{ 62.633015, -44.269203, 46.813416 },
				{ 63.245644, -43.209255, 35.463478 },
				{ 63.679813, -42.955791, 24.872061 },
				{ 63.271400, -43.164673, 14.665695 },
				{ 63.838238, -39.826969, 6.392663 },
				{ 63.758541, -38.443390, -3.218791 },
				{ 63.482910, -36.972061, -11.727401 },
				{ 62.978607, -35.370350, -20.505636 },
				{ 63.149059, -31.396929, -29.225237 },
				{ 62.998783, -25.412037, -38.398453 },
				{ 62.322979, -22.435949, -46.714252 },
				{ 62.676662, -22.004869, -51.924206 },
				{ 62.472496, -18.974174, -59.202522 }
			},
			{
				{ 66.727013, -51.684471, 101.039932 },
				{ 66.915131, -50.924301, 89.036179 },
				{ 67.312553, -49.562649, 78.232300 },
				{ 66.663849, -49.511826, 67.176437 },
				{ 66.378036, -50.605595, 53.681393 },
				{ 66.782310, -52.288750, 40.949615 },
				{ 67.075287, -51.863510, 29.986593 },
				{ 67.123009, -50.016556, 20.334219 },
				{ 67.288368, -48.043816, 11.399524 },
				{ 67.600922, -46.212494, 3.443305 },
				{ 67.702530, -43.942688, -5.053601 },
				{ 68.360260, -38.839802, -13.463100 },
				{ 67.141891, -37.584736, -23.018967 },
				{ 67.372765, -32.761574, -30.968979 },
				{ 67.119713, -29.720833, -38.626038 },
				{ 66.268898, -27.902147, -47.089046 },
				{ 65.653641, -26.151730, -55.370129 }
			},
			{
				{ 70.157761, -57.683495, 105.225723 },
				{ 70.603485, -56.339458, 95.604836 },
				{ 71.120544, -55.151386, 85.902641 },
				{ 70.669182, -55.372387, 74.110443 },
				{ 70.499992, -55.596012, 60.884842 },
				{ 70.960480, -56.113686, 48.242031 },
				{ 71.402176, -56.476109, 37.868240 },
				{ 70.765244, -57.556717, 26.975601 },
				{ 69.452194, -56.416542, 15.655796 },
				{ 72.205505, -50.394650, 10.199559 },
				{ 71.931602, -48.606647, 1.898732 },
				{ 73.358589, -42.764797, -5.475290 },
				{ 74.662239, -38.167072, -11.675998 },
				{ 74.991783, -35.064121, -18.997124 },
				{ 75.729797, -31.499870, -26.314262 },
				{ 72.530235, -31.468716, -38.081955 },
				{ 70.526352, -32.228596, -48.052589 }
			},
			{
				{ 73.339386, -63.998039, 108.680710 },
				{ 73.887604, -62.997318, 100.061432 },
				{ 74.250603, -62.723984, 90.515717 },
				{ 73.769081, -64.852234, 76.661537 },
				{ 73.646591, -63.142246, 65.080475 },
				{ 74.361557, -60.211227, 55.071903 },
				{ 74.209061, -63.543308, 43.109047 },
				{ 72.934677, -68.210411, 31.723492 },
				{ 74.992676, -60.315441, 25.229677 },
				{ 79.832428, -50.438061, 20.208681 },
				{ 79.212708, -48.704678, 11.497374 },
				{ 79.745895, -46.614990, 5.354442 },
				{ 80.518555, -42.293221, -1.566539 },
				{ 80.085915, -39.695698, -10.191355 },
				{ 79.846909, -37.609840, -18.691387 },
				{ 77.949371, -36.555855, -28.991995 },
				{ 76.734062, -36.538002, -38.172523 }
			},
			{
				{ 76.081223, -70.962761, 110.857964 },
				{ 76.697250, -70.601242, 101.592163 },
				{ 77.096176, -70.682861, 91.567146 },
				{ 76.821465, -72.101791, 79.476425 },
				{ 76.024773, -72.729843, 67.772774 },
				{ 76.061890, -71.715088, 57.817734 },
				{ 74.789223, -76.237091, 45.615170 },
				{ 75.233315, -76.382713, 36.456875 },
				{ 80.793495, -64.058350, 33.035873 },
				{ 81.899826, -58.736763, 25.090233 },
				{ 81.874596, -55.450092, 16.450014 },
				{ 82.644653, -53.089642, 9.954061 },
				{ 83.346725, -49.019512, 3.234946 },
				{ 84.505264, -44.770443, -3.093738 },
				{ 84.202934, -42.485233, -11.314644 },
				{ 82.894844, -41.687126, -20.890644 },
				{ 81.710373, -41.419697, -29.928415 }
			},
			{
				{ 78.385612, -78.442879, 111.949028 },
				{ 79.202728, -78.550011, 101.807610 },
				{ 79.999435, -78.584221, 91.686752 },
				{ 80.730247, -78.477043, 81.627617 },
				{ 81.612236, -78.358673, 71.448540 },
				{ 82.607002, -78.966988, 61.298401 },
				{ 81.688698, -80.389427, 51.572922 },
				{ 80.565590, -77.204109, 42.361088 },
				{ 83.705399, -69.963242, 37.027374 },
				{ 83.711266, -67.209167, 29.229139 },
				{ 84.959541, -62.762032, 22.041525 },
				{ 85.357216, -60.481693, 14.075327 },
				{ 85.974571, -54.774204, 7.135396 },
				{ 87.237686, -50.729660, 1.827203 },
				{ 88.953072, -46.920734, -3.576680 },
				{ 88.016342, -45.737972, -12.398099 },
				{ 86.422600, -45.679787, -22.154167 }
			},
			{
				{ 80.449974, -86.107094, 112.589050 },
				{ 81.609520, -86.546509, 101.744202 },
				{ 83.084793, -86.667824, 91.356773 },
				{ 85.243141, -86.097946, 81.829498 },
				{ 88.044014, -84.572639, 73.202591 },
				{ 90.243843, -81.716225, 65.946480 },
				{ 90.936996, -77.400291, 60.066841 },
				{ 91.922333, -72.233170, 52.722866 },
				{ 91.827194, -69.323875, 44.662212 },
				{ 91.374817, -68.149353, 36.933880 },
				{ 91.791168, -66.457352, 29.612379 },
				{ 90.581787, -64.974136, 21.350443 },
				{ 90.573715, -60.902378, 14.327712 },
				{ 90.455696, -57.884319, 8.153493 },
				{ 92.423027, -53.111992, 3.207753 },
				{ 93.118599, -49.355648, -4.009439 },
				{ 92.228096, -47.949505, -12.833318 }
			}
		},
		{
			{
				{ 19.034538, 55.794464, 34.948952 },
				{ 16.364002, 58.103600, 14.824910 },
				{ 14.978411, 59.943146, -3.686313 },
				{ 15.228142, 61.540451, -19.157833 },
				{ 16.368336, 62.957863, -31.547512 },
				{ 17.940754, 64.226303, -41.273922 },
				{ 19.133850, 65.664093, -49.300461 },
				{ 19.785538, 67.812225, -56.773735 },
				{ 20.419201, 70.342072, -63.625179 },
				{ 21.512993, 72.982979, -69.436256 },
				{ 22.961273, 75.778709, -74.732178 },
				{ 24.608727, 78.567245, -79.911438 },
				{ 26.310045, 81.150345, -85.156044 },
				{ 28.029253, 83.476852, -90.477081 },
				{ 29.705936, 85.605812, -95.892052 },
				{ 31.324781, 87.600311, -101.378464 },
				{ 32.912258, 89.528053, -106.893532 }
			},
			{
				{ 25.637766, 43.650597, 47.511311 },
				{ 23.908987, 45.814251, 28.281658 },
				{ 22.173576, 46.702087, 8.280941 },
				{ 20.374342, 48.580902, -10.925291 },
				{ 20.493999, 51.262077, -25.703995 },
				{ 22.859112, 52.881031, -34.276554 },
				{ 24.627245, 54.018234, -40.830864 },
				{ 23.760069, 56.823330, -49.700420 },
				{ 24.295036, 61.013729, -58.503624 },
				{ 26.366560, 63.755520, -63.924438 },
				{ 27.436979, 65.925674, -69.007477 },
				{ 29.057062, 68.310959, -73.932861 },
				{ 30.801884, 70.762535, -79.077423 },
				{ 32.326939, 73.100006, -84.545082 },
				{ 33.659721, 75.276733, -90.219101 },
				{ 34.914066, 77.276993, -95.956543 },
				{ 36.153072, 79.183182, -101.698036 }
			},
			{
				{ 31.397179, 31.671803, 58.504593 },
				{ 32.903469, 32.501293, 42.302139 },
				{ 30.229212, 33.371964, 21.114813 },
				{ 25.115168, 35.722004, -2.594494 },
				{ 25.197536, 39.718399, -19.146631 },
				{ 26.543022, 42.788349, -28.220964 },
				{ 28.291285, 45.216618, -35.386833 },
				{ 26.791779, 46.740726, -44.039734 },
				{ 28.063614, 51.377735, -52.672909 },
				{ 30.706631, 54.243633, -58.392223 },
				{ 31.800362, 55.691536, -63.118969 },
				{ 33.470570, 57.679226, -67.809235 },
				{ 35.408337, 60.158665, -72.786072 },
				{ 36.597713, 62.687595, -78.578880 },
				{ 37.539906, 64.933517, -84.576653 },
				{ 38.457817, 66.928490, -90.560120 },
				{ 39.397640, 68.851326, -96.516106 }
			},
			{
				{ 35.878220, 20.646679, 67.145386 },
				{ 37.707504, 21.441824, 51.276245 },
				{ 35.554138, 22.450064, 30.932764 },
				{ 32.582787, 23.835394, 9.393064 },
				{ 31.874016, 28.164154, -8.197860 },
				{ 31.638256, 30.673218, -18.814413 },
				{ 32.443333, 35.006386, -29.455605 },
				{ 32.377281, 39.268459, -39.317455 },
				{ 33.628193, 42.296780, -46.390018 },
				{ 34.784653, 44.154736, -52.516151 },
				{ 37.050705, 45.330704, -56.380844 },
				{ 37.913906, 47.092381, -61.759678 },
				{ 39.911476, 49.424446, -66.459373 },
				{ 40.612167, 52.328335, -72.753883 },
				{ 41.213676, 54.471664, -79.034843 },
				{ 41.899868, 56.479126, -85.220016 },
				{ 42.658848, 58.599937, -91.369270 }
			},
			{
				{ 39.983021, 10.695342, 74.183853 },
				{ 40.389122, 11.438374, 56.764015 },
				{ 40.278191, 12.168593, 39.054417 },
				{ 40.741940, 14.248710, 23.551594 },
				{ 40.540440, 16.802883, 9.731924 },
				{ 39.036728, 18.515253, -6.079650 },
				{ 37.290527, 20.962702, -21.111143 },
				{ 38.325661, 29.493248, -32.625290 },
				{ 39.297592, 33.670559, -41.677322 },
				{ 39.181965, 33.071377, -46.447071 },
				{ 40.070782, 34.722969, -51.698265 },
				{ 41.419918, 38.668949, -57.341656 },
				{ 43.264160, 41.110958, -61.649216 },
				{ 44.075577, 42.203278, -67.416336 },
				{ 44.576828, 43.669239, -73.664536 },
				{ 45.201488, 45.912556, -79.985176 },
				{ 45.946129, 48.560841, -86.287079 }
			},
			{
				{ 45.110703, 2.248554, 81.526428 },
				{ 45.094456, 3.106265, 63.997684 },
				{ 44.808941, 3.914896, 46.227791 },
				{ 44.850704, 4.608475, 30.822945 },
				{ 44.098549, 3.359068, 17.158653 },
				{ 43.563175, 6.191427, 1.975811 },
				{ 43.298908, 10.351061, -10.252332 },
				{ 44.656372, 18.575195, -23.918438 },
				{ 44.914127, 24.480682, -36.442577 },
				{ 44.403728, 22.583565, -38.765503 },
				{ 43.836605, 24.790651, -46.221653 },
				{ 45.619324, 30.019415, -51.759789 },
				{ 46.971828, 31.929829, -56.554600 },
				{ 47.176918, 31.279234, -62.335007 },
				{ 47.608677, 32.709064, -68.614906 },
				{ 48.364510, 35.550800, -74.966301 },
				{ 49.233265, 38.809242, -81.295296 }
			},
			{
				{ 50.768288, -5.050275, 88.487762 },
				{ 50.575573, -4.071877, 71.884186 },
				{ 49.481644, -4.196733, 54.215614 },
				{ 48.749962, -4.030553, 37.302940 },
				{ 48.785107, -3.340346, 23.935827 },
				{ 48.855339, -1.853385, 11.751066 },
				{ 48.993690, 0.021251, 0.605007 },
				{ 48.553944, 2.686957, -9.857680 },
				{ 48.838802, 6.442230, -20.326260 },
				{ 48.668530, 9.689689, -30.293995 },
				{ 49.055107, 14.929786, -38.937824 },
				{ 50.078220, 19.153624, -45.429287 },
				{ 49.999973, 19.920715, -51.724533 },
				{ 50.009060, 19.764284, -57.575279 },
				{ 50.622787, 22.544392, -63.929756 },
				{ 51.514313, 25.805288, -70.179893 },
				{ 52.429684, 29.165018, -76.390930 }
			},
			{
				{ 55.814316, -12.392011, 93.976334 },
				{ 56.748859, -10.479889, 80.491920 },
				{ 55.234360, -11.448774, 63.695190 },
				{ 54.576397, -11.194774, 47.053570 },
				{ 54.171432, -10.267787, 32.849602 },
				{ 52.932232, -10.657630, 19.255049 },
				{ 52.517433, -9.600789, 5.858270 },
				{ 52.084057, -7.134286, -6.068578 },
				{ 52.437912, -3.186725, -16.269077 },
				{ 51.846226, -1.206105, -24.724976 },
				{ 52.818493, 2.430471, -32.073601 },
				{ 53.117512, 6.443723, -39.964607 },
				{ 52.766762, 9.943978, -48.013859 },
				{ 53.237747, 11.837888, -53.965569 },
				{ 54.051594, 13.957688, -59.391029 },
				{ 54.735020, 16.522703, -65.458855 },
				{ 55.421703, 19.285957, -71.546295 }
			},
			{
				{ 59.343079, -20.708681, 97.233299 },
				{ 58.561954, -20.843771, 82.432648 },
				{ 58.476631, -20.357260, 68.216339 },
				{ 59.019650, -18.774920, 53.893761 },
				{ 58.218365, -18.865339, 39.337605 },
				{ 57.135437, -19.807945, 25.954597 },
				{ 57.974518, -18.707443, 15.619370 },
				{ 56.074230, -17.231468, 1.534578 },
				{ 56.833965, -14.189935, -6.744204 },
				{ 56.360798, -11.097221, -17.558916 },
				{ 56.422791, -8.162517, -26.120060 },
				{ 56.410633, -5.505872, -34.068989 },
				{ 56.878216, -1.162407, -41.717491 },
				{ 57.146675, 2.665321, -48.798553 },
				{ 57.698128, 5.263307, -54.458138 },
				{ 57.953121, 7.230540, -60.628830 },
				{ 58.209221, 9.111048, -66.755936 }
			},
			{
				{ 62.316898, -28.838322, 99.773705 },
				{ 61.188629, -30.237556, 85.271873 },
				{ 60.759773, -30.988791, 71.139969 },
				{ 61.000927, -29.970963, 57.475483 },
				{ 60.881268, -29.331371, 44.063683 },
				{ 61.727345, -26.717340, 32.827011 },
				{ 61.475941, -26.659370, 21.707800 },
				{ 59.838245, -26.525032, 7.872996 },
				{ 58.841309, -24.854527, -4.024179 },
				{ 59.949078, -21.307909, -11.518022 },
				{ 59.507740, -18.471682, -20.809664 },
				{ 60.005253, -15.275764, -28.216574 },
				{ 60.238861, -11.916437, -35.798866 },
				{ 60.675217, -7.837579, -43.081284 },
				{ 61.076870, -4.169600, -49.635635 },
				{ 61.175632, -2.437851, -55.479408 },
				{ 60.930439, -1.063104, -62.109695 }
			},
			{
				{ 65.253036, -36.277145, 102.228401 },
				{ 65.101768, -36.822308, 88.998779 },
				{ 65.519981, -37.201759, 76.197403 },
				{ 64.542717, -37.765728, 62.036121 },
				{ 64.753998, -35.815063, 50.234329 },
				{ 66.075882, -33.403553, 39.371235 },
				{ 65.654053, -34.805984, 28.434584 },
				{ 66.214706, -33.470554, 18.796627 },
				{ 65.757439, -31.742125, 8.323832 },
				{ 63.766048, -30.287333, -4.343806 },
				{ 64.362221, -28.657085, -11.382602 },
				{ 64.483994, -25.901878, -19.618805 },
				{ 63.922359, -22.708250, -29.124546 },
				{ 63.937370, -18.338228, -37.555687 },
				{ 64.341713, -14.491919, -44.422600 },
				{ 64.522034, -12.718247, -50.273609 },
				{ 63.746719, -10.822021, -57.943398 }
			},
			{
				{ 68.401512, -43.033588, 105.125870 },
				{ 68.229492, -43.457859, 92.010963 },
				{ 68.226418, -44.492371, 78.854156 },
				{ 67.673477, -45.528591, 66.349808 },
				{ 67.996300, -45.662132, 53.851776 },
				{ 68.845360, -44.767254, 43.457607 },
				{ 68.681702, -44.091946, 32.960941 },
				{ 68.984657, -41.746349, 23.167225 },
				{ 68.365295, -40.403076, 12.346539 },
				{ 68.016907, -39.719330, 2.844789 },
				{ 67.309746, -38.367863, -7.057399 },
				{ 66.805428, -34.925072, -16.713654 },
				{ 67.226288, -31.154984, -24.277145 },
				{ 67.235596, -28.142117, -31.699152 },
				{ 67.349289, -24.671150, -38.951714 },
				{ 67.642509, -21.447685, -45.630360 },
				{ 67.012184, -19.413673, -53.699406 }
			},
			{
				{ 71.619850, -49.550117, 108.266876 },
				{ 71.664024, -49.140591, 97.460770 },
				{ 71.628258, -49.070004, 86.416878 },
				{ 71.856743, -49.380020, 74.806923 },
				{ 72.898109, -53.547604, 60.088757 },
				{ 72.376595, -53.429237, 47.817993 },
				{ 72.655098, -50.427139, 39.144192 },
				{ 72.289902, -49.253124, 29.103632 },
				{ 71.444923, -48.455791, 17.656567 },
				{ 72.333679, -45.416859, 9.867221 },
				{ 72.690231, -42.908115, 1.833045 },
				{ 70.680412, -42.450439, -9.026088 },
				{ 73.039017, -36.749905, -14.549061 },
				{ 73.769310, -33.306480, -20.791410 },
				{ 73.830444, -29.621799, -28.532333 },
				{ 73.152603, -27.669134, -36.858570 },
				{ 71.290840, -27.131208, -46.962791 }
			},
			{
				{ 74.675369, -56.106964, 111.042473 },
				{ 75.104424, -55.227757, 102.179802 },
				{ 75.587578, -54.177773, 93.462845 },
				{ 75.854820, -54.380871, 82.191551 },
				{ 76.287018, -59.198933, 66.871620 },
				{ 75.885658, -60.639656, 53.513985 },
				{ 76.099731, -59.593281, 43.456913 },
				{ 77.040909, -57.152187, 36.017582 },
				{ 77.512909, -53.455868, 27.884350 },
				{ 79.338860, -48.051392, 20.505379 },
				{ 78.952698, -45.339073, 12.150318 },
				{ 79.981804, -42.740562, 6.085728 },
				{ 81.304138, -38.505394, -0.448045 },
				{ 79.944954, -37.030148, -10.249756 },
				{ 79.646805, -34.235149, -18.893562 },
				{ 78.712997, -32.663376, -27.741959 },
				{ 76.741478, -32.847225, -38.014332 }
			},
			{
				{ 77.424110, -62.781876, 113.017448 },
				{ 77.951607, -62.366570, 103.788269 },
				{ 78.552017, -61.390537, 95.062790 },
				{ 79.157524, -59.445004, 86.797096 },
				{ 78.880409, -60.003654, 74.506676 },
				{ 78.536636, -63.765354, 59.810024 },
				{ 76.438141, -69.096298, 47.922573 },
				{ 78.641525, -66.432434, 40.977886 },
				{ 82.136841, -58.822517, 34.968971 },
				{ 81.029907, -55.898121, 25.140202 },
				{ 82.337349, -51.399994, 17.794121 },
				{ 82.798393, -48.785885, 10.959743 },
				{ 84.166954, -44.519974, 4.702731 },
				{ 85.028137, -41.201061, -2.253874 },
				{ 84.129318, -39.229931, -11.266446 },
				{ 83.770622, -37.274479, -19.627340 },
				{ 81.847282, -37.532425, -29.627520 }
			},
			{
				{ 79.823341, -69.481667, 114.218529 },
				{ 80.410217, -69.972710, 103.765884 },
				{ 81.065506, -70.241806, 93.614441 },
				{ 81.887428, -70.864899, 83.559540 },
				{ 82.943222, -74.090668, 71.838806 },
				{ 83.920197, -75.713737, 61.804726 },
				{ 82.514877, -75.313293, 53.665710 },
				{ 82.156662, -71.323807, 45.655216 },
				{ 84.309113, -65.377769, 39.727234 },
				{ 84.123695, -63.244267, 30.381268 },
				{ 87.414291, -57.008141, 24.116892 },
				{ 86.232857, -54.681206, 15.489945 },
				{ 87.288055, -48.955585, 9.400198 },
				{ 88.370819, -46.891762, 3.649668 },
				{ 89.228233, -44.043232, -2.811900 },
				{ 88.959892, -41.457874, -11.221086 },
				{ 87.201599, -41.212635, -21.119699 }
			},
			{
				{ 81.997658, -76.195587, 114.969208 },
				{ 82.749046, -77.929733, 103.171219 },
				{ 83.764786, -79.703285, 91.747421 },
				{ 85.404968, -81.244576, 81.457756 },
				{ 87.772072, -81.333069, 73.380363 },
				{ 90.320923, -78.005852, 67.875320 },
				{ 92.257042, -72.102859, 62.349037 },
				{ 93.016663, -67.758835, 55.109409 },
				{ 91.541061, -66.873718, 46.264114 },
				{ 91.507996, -65.057701, 37.804356 },
				{ 91.923897, -62.007954, 30.423775 },
				{ 91.376053, -59.447937, 22.684221 },
				{ 91.890686, -54.599739, 15.924855 },
				{ 92.590393, -51.712933, 10.484353 },
				{ 93.270569, -49.100937, 4.310921 },
				{ 93.210564, -46.606762, -3.538566 },
				{ 92.558090, -44.673969, -12.221533 }
			}
		},
		{
			{
				{ 21.242029, 58.671375, 38.098557 },
				{ 18.647627, 61.062901, 18.032415 },
				{ 17.384050, 63.144939, -0.116550 },
				{ 17.881090, 64.812630, -14.735127 },
				{ 19.246916, 66.370872, -26.285084 },
				{ 20.606205, 68.120636, -36.358562 },
				{ 21.605947, 69.790100, -44.856079 },
				{ 22.260300, 71.571075, -52.407757 },
				{ 22.543472, 73.622055, -59.588966 },
				{ 22.992462, 75.803558, -66.020462 },
				{ 24.134348, 78.273117, -71.793991 },
				{ 25.692661, 80.746513, -77.259293 },
				{ 27.395988, 83.047638, -82.614357 },
				{ 29.169426, 85.233719, -87.934006 },
				{ 30.973192, 87.398300, -93.277359 },
				{ 32.774101, 89.565758, -98.668983 },
				{ 34.564594, 91.730377, -104.090652 }
			},
			{
				{ 28.160099, 47.325104, 50.999489 },
				{ 26.019794, 49.413723, 31.407772 },
				{ 24.892672, 51.274521, 12.257419 },
				{ 23.468517, 53.559879, -6.060460 },
				{ 23.021708, 55.756550, -20.385765 },
				{ 25.145407, 57.745842, -29.628597 },
				{ 26.490824, 59.070049, -36.983669 },
				{ 27.137503, 60.489708, -44.263737 },
				{ 26.302504, 63.294746, -53.221188 },
				{ 26.790834, 65.378441, -60.101406 },
				{ 28.574263, 68.259323, -66.075058 },
				{ 30.250381, 70.702194, -71.437233 },
				{ 31.915974, 73.070251, -76.631256 },
				{ 33.530727, 75.494728, -81.982262 },
				{ 35.036251, 77.852379, -87.550453 },
				{ 36.453259, 80.067123, -93.252998 },
				{ 37.833668, 82.193054, -99.001305 }
			},
			{
				{ 33.554668, 36.915577, 61.870712 },
				{ 34.309090, 38.212025, 45.205563 },
				{ 33.856224, 39.290562, 26.528578 },
				{ 28.900831, 42.566284, 3.218098 },
				{ 25.501646, 45.409241, -15.838064 },
				{ 29.217695, 47.863663, -23.251318 },
				{ 31.112864, 49.066174, -30.186045 },
				{ 30.977709, 50.358910, -38.372158 },
				{ 29.657990, 53.031097, -47.359570 },
				{ 31.485401, 55.800301, -54.346237 },
				{ 33.068371, 58.360245, -60.648987 },
				{ 34.596367, 60.502396, -65.737137 },
				{ 36.356537, 63.099133, -70.633728 },
				{ 37.861309, 65.866928, -76.036758 },
				{ 39.058708, 68.366692, -81.862778 },
				{ 40.096706, 70.560654, -87.872025 },
				{ 41.093704, 72.621582, -93.923767 }
			},
			{
				{ 37.631844, 27.151466, 70.215889 },
				{ 39.374569, 28.387907, 54.712559 },
				{ 40.665386, 29.310165, 38.567337 },
				{ 39.091789, 32.162636, 19.057812 },
				{ 33.122265, 34.506943, -3.452259 },
				{ 34.194519, 36.512756, -14.084903 },
				{ 35.486877, 38.634224, -23.721954 },
				{ 36.768326, 41.919216, -33.348000 },
				{ 35.304928, 44.849251, -42.807331 },
				{ 35.501369, 47.308628, -50.826782 },
				{ 36.742149, 48.407349, -56.209133 },
				{ 38.532288, 50.533291, -60.371990 },
				{ 40.647114, 53.656147, -64.785126 },
				{ 42.049316, 56.582573, -70.252831 },
				{ 42.930984, 58.934212, -76.321739 },
				{ 43.644428, 60.997330, -82.579468 },
				{ 44.350410, 63.019669, -88.862709 }
			},
			{
				{ 41.484703, 17.848423, 77.217911 },
				{ 42.091267, 19.295946, 60.127544 },
				{ 44.078068, 19.885513, 45.134167 },
				{ 42.615669, 20.983412, 28.602468 },
				{ 42.385139, 23.546741, 12.655882 },
				{ 41.214184, 25.043404, -2.248081 },
				{ 39.008373, 27.058624, -18.565428 },
				{ 39.756699, 33.021885, -30.767305 },
				{ 38.576279, 36.716064, -40.567459 },
				{ 38.900669, 38.334751, -47.433235 },
				{ 40.040981, 39.242519, -52.223373 },
				{ 42.471882, 42.180080, -55.344372 },
				{ 44.723232, 45.572132, -59.440186 },
				{ 45.887459, 47.680908, -64.920418 },
				{ 46.511482, 49.432243, -71.077599 },
				{ 47.050900, 51.360546, -77.432007 },
				{ 47.626747, 53.472958, -83.814980 }
			},
			{
				{ 46.629177, 9.286631, 84.991302 },
				{ 47.536926, 10.426832, 68.371994 },
				{ 48.262432, 11.442033, 51.862564 },
				{ 47.727455, 11.976811, 35.366844 },
				{ 48.360130, 12.912247, 23.065294 },
				{ 48.278000, 14.161425, 9.645643 },
				{ 46.968796, 18.885843, -6.229538 },
				{ 45.802811, 23.570934, -21.530659 },
				{ 45.157482, 26.526829, -31.566513 },
				{ 45.304302, 28.037117, -37.405842 },
				{ 45.320866, 30.874302, -44.405468 },
				{ 47.093616, 34.587269, -49.346748 },
				{ 48.509266, 37.338547, -54.492310 },
				{ 49.184460, 38.532124, -60.251282 },
				{ 49.755146, 39.851692, -66.252052 },
				{ 50.337341, 41.817764, -72.478477 },
				{ 50.920570, 44.089161, -78.794876 }
			},
			{
				{ 52.327404, 1.802078, 92.670486 },
				{ 53.001522, 2.329279, 77.158562 },
				{ 53.204021, 3.344283, 60.727524 },
				{ 51.319820, 3.588214, 41.814999 },
				{ 50.766422, 3.683778, 27.702496 },
				{ 50.640182, 2.594172, 15.483907 },
				{ 50.563999, 7.428292, 1.673794 },
				{ 50.089275, 9.562977, -10.138584 },
				{ 50.497021, 13.280174, -17.714634 },
				{ 51.031116, 18.112179, -26.937054 },
				{ 51.325336, 21.996506, -35.493187 },
				{ 51.915714, 25.330851, -42.613907 },
				{ 51.227753, 27.574192, -50.714199 },
				{ 51.836750, 28.872726, -56.398212 },
				{ 52.879021, 30.493879, -61.778431 },
				{ 53.587551, 32.616161, -67.734238 },
				{ 54.146904, 34.862396, -73.869865 }
			},
			{
				{ 57.284794, -5.278331, 98.610481 },
				{ 57.032101, -4.934063, 83.353409 },
				{ 57.094711, -4.635664, 67.874748 },
				{ 56.178959, -4.147811, 50.049759 },
				{ 55.962509, -4.079034, 35.934227 },
				{ 55.257557, -5.197304, 23.146034 },
				{ 54.064556, -3.825206, 9.126607 },
				{ 54.695000, -0.865704, 0.207445 },
				{ 53.968987, 2.434925, -11.982265 },
				{ 55.206306, 7.193859, -20.409134 },
				{ 55.066467, 10.054757, -28.813541 },
				{ 55.527798, 13.679075, -36.600159 },
				{ 55.350292, 17.552004, -45.290127 },
				{ 55.423244, 19.608093, -51.867664 },
				{ 56.278778, 21.845955, -57.428432 },
				{ 56.777424, 23.800512, -63.245808 },
				{ 57.164280, 25.672028, -69.166397 }
			},
			{
				{ 61.348145, -12.792622, 102.753555 },
				{ 60.585163, -13.113472, 87.616287 },
				{ 60.591133, -12.830815, 72.975365 },
				{ 60.237778, -12.109795, 56.711536 },
				{ 59.438137, -12.170056, 41.843189 },
				{ 58.868591, -11.764441, 29.086685 },
				{ 58.954758, -10.545603, 17.329546 },
				{ 59.286163, -8.923271, 7.000441 },
				{ 59.209194, -6.253306, -3.026552 },
				{ 57.202347, -5.684169, -15.364072 },
				{ 58.140430, -1.104546, -23.588757 },
				{ 58.732765, 3.008621, -31.326845 },
				{ 59.298618, 6.459970, -38.505230 },
				{ 59.259373, 10.419160, -46.564499 },
				{ 59.969501, 13.427204, -52.779766 },
				{ 59.865910, 15.085155, -58.897873 },
				{ 59.930660, 16.467985, -64.799461 }
			},
			{
				{ 64.571938, -20.414406, 105.474457 },
				{ 63.823742, -21.180201, 91.091072 },
				{ 63.475163, -21.898968, 76.391747 },
				{ 63.631329, -21.603689, 62.269020 },
				{ 63.063156, -21.495016, 47.801426 },
				{ 62.904209, -20.158907, 35.562962 },
				{ 62.356571, -19.493986, 22.427639 },
				{ 60.614029, -18.859890, 7.762762 },
				{ 61.606037, -16.002468, -0.330170 },
				{ 61.721420, -14.054977, -7.763490 },
				{ 62.360989, -10.565592, -15.871692 },
				{ 62.159966, -6.795721, -25.539904 },
				{ 62.385567, -3.662393, -33.211739 },
				{ 62.847805, -0.156859, -40.293259 },
				{ 63.086555, 3.599843, -47.608971 },
				{ 62.886959, 6.105682, -54.428730 },
				{ 62.516216, 7.198389, -60.773129 }
			},
			{
				{ 67.370102, -27.890945, 107.281158 },
				{ 66.801949, -28.759846, 93.201973 },
				{ 66.847496, -29.263878, 79.863228 },
				{ 66.537254, -29.865034, 65.750175 },
				{ 66.699570, -28.858755, 53.091068 },
				{ 67.526878, -28.031555, 42.132118 },
				{ 67.196732, -27.721407, 30.390858 },
				{ 65.963554, -26.954388, 17.482035 },
				{ 64.997421, -25.368252, 5.990734 },
				{ 66.443687, -22.278423, -0.222201 },
				{ 66.511055, -19.624739, -8.691319 },
				{ 65.689308, -16.692709, -19.206881 },
				{ 65.552589, -14.249682, -27.432945 },
				{ 65.646881, -11.188313, -34.888599 },
				{ 66.312065, -7.097910, -41.563492 },
				{ 66.546188, -3.550147, -48.871326 },
				{ 65.036598, -2.342919, -56.819710 }
			},
			{
				{ 70.284592, -34.959034, 109.300621 },
				{ 69.934280, -35.941544, 95.848381 },
				{ 69.668602, -37.073154, 82.692444 },
				{ 69.531555, -37.602551, 69.632980 },
				{ 69.557518, -37.017860, 57.057098 },
				{ 69.678314, -36.779480, 46.351070 },
				{ 70.017189, -35.734451, 35.509880 },
				{ 68.727066, -35.416698, 22.292242 },
				{ 67.258568, -34.491596, 8.648561 },
				{ 67.377548, -32.448418, -0.390660 },
				{ 67.648712, -29.634050, -8.075483 },
				{ 67.904884, -27.159584, -15.782437 },
				{ 69.268074, -24.051737, -21.209251 },
				{ 68.983910, -21.200445, -29.228401 },
				{ 69.107407, -17.749487, -36.544437 },
				{ 69.294472, -14.446359, -43.637066 },
				{ 68.978302, -12.017539, -51.110981 }
			},
			{
				{ 73.295776, -41.757282, 111.643776 },
				{ 73.178070, -42.229801, 99.787338 },
				{ 73.176399, -42.509007, 88.322556 },
				{ 73.220940, -42.762104, 76.166527 },
				{ 74.001389, -44.869343, 62.483299 },
				{ 74.152733, -44.661430, 51.580173 },
				{ 73.242607, -44.266392, 40.055641 },
				{ 72.598053, -43.567532, 28.820049 },
				{ 72.069466, -41.575771, 17.815071 },
				{ 71.276161, -40.211803, 7.926930 },
				{ 74.748993, -34.960556, 4.472855 },
				{ 72.539246, -35.028469, -7.234648 },
				{ 71.393669, -33.222916, -17.150360 },
				{ 71.895073, -30.876669, -23.597635 },
				{ 72.865738, -26.019325, -30.249760 },
				{ 72.978180, -23.076387, -37.171936 },
				{ 72.448273, -21.187256, -45.189518 }
			},
			{
				{ 76.268997, -48.267338, 113.956642 },
				{ 76.404617, -48.392010, 103.506950 },
				{ 76.655983, -48.175571, 93.236366 },
				{ 77.156288, -47.897129, 82.560661 },
				{ 77.929756, -50.838455, 69.002388 },
				{ 78.011848, -53.012993, 56.907211 },
				{ 77.508446, -53.215729, 45.461388 },
				{ 77.338142, -51.139069, 36.118961 },
				{ 78.343010, -47.660637, 28.996298 },
				{ 78.604568, -44.192097, 20.960020 },
				{ 78.647751, -41.680622, 12.572932 },
				{ 78.267715, -39.962353, 3.714340 },
				{ 79.602531, -36.008438, -3.624578 },
				{ 79.491158, -34.046913, -11.405669 },
				{ 79.390190, -30.727394, -19.692642 },
				{ 78.512543, -28.835051, -28.154161 },
				{ 76.821075, -28.360714, -37.807793 }
			},
			{
				{ 79.047768, -54.490494, 115.745613 },
				{ 79.144638, -55.025524, 104.663322 },
				{ 79.190651, -55.194351, 93.730804 },
				{ 79.135262, -54.645302, 83.622658 },
				{ 79.197716, -54.700108, 71.979736 },
				{ 80.176918, -58.787758, 59.897488 },
				{ 81.087730, -60.190338, 52.194035 },
				{ 81.398781, -57.981262, 43.120155 },
				{ 81.488731, -55.129032, 34.821140 },
				{ 81.614937, -51.054920, 27.139435 },
				{ 83.484871, -46.915684, 19.871271 },
				{ 84.229149, -43.385658, 12.720697 },
				{ 84.368881, -39.974163, 4.824435 },
				{ 85.499924, -37.493015, -1.447459 },
				{ 84.661186, -35.067036, -10.603116 },
				{ 84.544670, -32.800446, -18.609152 },
				{ 82.748039, -32.662365, -28.423271 }
			},
			{
				{ 81.519875, -60.459637, 116.841370 },
				{ 81.679306, -61.843075, 104.984886 },
				{ 81.758881, -63.137207, 93.079506 },
				{ 81.840530, -64.978241, 81.191833 },
				{ 82.012329, -69.482971, 68.575485 },
				{ 82.618713, -70.032394, 60.183876 },
				{ 83.602577, -68.091011, 55.778343 },
				{ 86.454384, -60.310925, 51.464279 },
				{ 86.684235, -58.978699, 42.726753 },
				{ 86.097260, -57.932060, 32.424545 },
				{ 88.425446, -52.446751, 25.665751 },
				{ 86.711029, -50.700222, 17.922495 },
				{ 87.985931, -44.506031, 11.076668 },
				{ 89.226700, -42.720467, 5.047579 },
				{ 89.738144, -39.808197, -2.052273 },
				{ 89.565056, -37.388283, -10.161007 },
				{ 88.032379, -36.722309, -19.753677 }
			},
			{
				{ 83.768600, -66.312790, 117.458328 },
				{ 84.171097, -68.960510, 104.973923 },
				{ 84.767227, -71.800385, 92.891197 },
				{ 85.964455, -74.417236, 82.369057 },
				{ 88.090744, -74.942284, 75.171806 },
				{ 90.656822, -70.907486, 71.467339 },
				{ 91.542969, -66.114624, 64.949585 },
				{ 91.169067, -62.752789, 57.172794 },
				{ 90.331917, -63.507023, 48.111320 },
				{ 91.320129, -61.139301, 38.716896 },
				{ 91.736877, -58.372959, 31.098906 },
				{ 90.878334, -56.562820, 24.001402 },
				{ 92.605667, -50.709686, 18.063587 },
				{ 93.827560, -46.625515, 12.816621 },
				{ 93.953003, -44.499645, 5.404109 },
				{ 93.627007, -42.893295, -2.932820 },
				{ 93.252998, -40.807869, -11.335409 }
			}
		},
		{
			{
				{ 22.233261, 61.381172, 39.479225 },
				{ 20.198397, 63.924400, 20.139065 },
				{ 19.627892, 66.257126, 2.815093 },
				{ 20.498571, 68.301636, -11.157679 },
				{ 21.913271, 70.426727, -22.293200 },
				{ 23.056396, 72.671700, -32.405704 },
				{ 23.703993, 74.558464, -41.423546 },
				{ 24.346081, 75.938698, -49.063305 },
				{ 24.446268, 77.298302, -56.154945 },
				{ 24.552280, 78.955795, -62.762192 },
				{ 25.458206, 80.993027, -68.796196 },
				{ 26.927034, 83.097435, -74.499794 },
				{ 28.605307, 85.118271, -80.028130 },
				{ 30.392344, 87.167679, -85.460312 },
				{ 32.267529, 89.345840, -90.862106 },
				{ 34.191311, 91.641914, -96.280228 },
				{ 36.127720, 93.990158, -101.719139 }
			},
			{
				{ 28.570162, 51.351055, 52.534332 },
				{ 25.360645, 53.568565, 31.938477 },
				{ 26.346964, 55.918606, 14.319298 },
				{ 28.284502, 58.526070, -0.462777 },
				{ 27.805767, 60.993305, -13.933685 },
				{ 28.379484, 63.370785, -25.069202 },
				{ 27.506037, 65.269981, -35.402153 },
				{ 28.955416, 66.088608, -42.507286 },
				{ 28.962873, 67.471619, -49.825821 },
				{ 29.138094, 69.357727, -56.781548 },
				{ 30.236502, 71.585403, -63.100613 },
				{ 31.606815, 73.637360, -68.793831 },
				{ 33.095612, 75.785095, -74.208885 },
				{ 34.717506, 78.145042, -79.626488 },
				{ 36.356510, 80.577827, -85.192688 },
				{ 37.933670, 82.967834, -90.907463 },
				{ 39.464222, 85.311043, -96.693001 }
			},
			{
				{ 34.319492, 42.086193, 64.138336 },
				{ 32.034039, 43.602032, 44.213921 },
				{ 33.464550, 45.513248, 26.925381 },
				{ 35.604488, 48.898960, 10.874666 },
				{ 32.668076, 51.189701, -6.636473 },
				{ 33.344261, 53.361874, -18.051075 },
				{ 32.773533, 54.724361, -28.373755 },
				{ 33.006004, 56.283436, -36.966995 },
				{ 33.578403, 58.478470, -44.281254 },
				{ 34.673103, 60.699326, -51.139679 },
				{ 34.982040, 62.310772, -57.899696 },
				{ 35.921284, 64.066940, -63.347443 },
				{ 37.441589, 66.588631, -68.482491 },
				{ 39.045647, 69.332336, -73.835190 },
				{ 40.448975, 71.926369, -79.568466 },
				{ 41.653961, 74.305222, -85.572975 },
				{ 42.773987, 76.571022, -91.679810 }
			},
			{
				{ 39.222282, 33.137245, 73.340019 },
				{ 39.693985, 34.275482, 56.236320 },
				{ 41.435677, 35.373863, 40.599892 },
				{ 38.249786, 37.776909, 19.952599 },
				{ 35.062637, 40.229534, -0.046389 },
				{ 36.410774, 42.405869, -11.448063 },
				{ 35.849369, 44.287441, -23.397053 },
				{ 35.314289, 46.975845, -33.875404 },
				{ 37.911179, 50.380878, -39.853672 },
				{ 38.497776, 52.267735, -47.273720 },
				{ 38.104523, 51.918911, -53.497929 },
				{ 39.546612, 54.399105, -58.250053 },
				{ 41.708469, 57.966995, -62.945892 },
				{ 43.375595, 60.970959, -68.206551 },
				{ 44.473907, 63.444218, -74.100662 },
				{ 45.293484, 65.632690, -80.339882 },
				{ 46.047390, 67.732201, -86.679283 }
			},
			{
				{ 43.201641, 24.107630, 80.613327 },
				{ 44.204460, 25.331579, 64.465843 },
				{ 46.970497, 26.054340, 50.712654 },
				{ 45.576942, 26.738562, 33.251106 },
				{ 45.272930, 28.699244, 16.505136 },
				{ 43.042969, 30.846701, 0.168094 },
				{ 40.395882, 33.621578, -16.763741 },
				{ 39.993198, 36.129471, -27.210968 },
				{ 42.103382, 39.888760, -33.707428 },
				{ 40.649509, 42.262226, -43.537407 },
				{ 40.941959, 41.551731, -48.549530 },
				{ 43.516838, 46.235115, -53.285152 },
				{ 46.068752, 50.280243, -57.715771 },
				{ 47.537148, 52.974899, -62.939068 },
				{ 48.275028, 55.024570, -68.931129 },
				{ 48.801235, 56.919453, -75.260010 },
				{ 49.316280, 58.834873, -81.669891 }
			},
			{
				{ 47.978260, 15.582159, 88.209007 },
				{ 50.079704, 16.872740, 73.768509 },
				{ 52.091835, 17.563772, 59.540222 },
				{ 51.530502, 18.435993, 42.449787 },
				{ 49.993176, 20.080406, 26.184364 },
				{ 50.076336, 22.357746, 13.321969 },
				{ 48.257889, 24.118984, -2.240062 },
				{ 48.568836, 25.772430, -11.917989 },
				{ 46.760284, 28.183489, -25.117485 },
				{ 46.700172, 32.312195, -35.122704 },
				{ 46.625889, 36.768620, -43.301342 },
				{ 48.034248, 39.775417, -48.420975 },
				{ 50.215294, 43.027626, -52.947784 },
				{ 51.229824, 45.006981, -58.245960 },
				{ 51.775013, 46.536934, -64.129028 },
				{ 52.211216, 48.192062, -70.333267 },
				{ 52.613571, 49.968334, -76.641083 }
			},
			{
				{ 53.753548, 8.122277, 96.340240 },
				{ 55.319729, 9.097333, 81.705681 },
				{ 55.302593, 9.595975, 65.565437 },
				{ 55.121212, 10.140774, 48.972389 },
				{ 52.524338, 9.941346, 32.248936 },
				{ 52.609364, 11.375159, 19.462379 },
				{ 51.683537, 15.249152, -2.210033 },
				{ 51.534546, 17.326174, -9.355920 },
				{ 51.682297, 19.257179, -16.302111 },
				{ 52.562267, 24.356882, -25.196072 },
				{ 52.269657, 27.604280, -34.175968 },
				{ 52.751202, 31.859867, -41.851643 },
				{ 53.846836, 35.596600, -48.555672 },
				{ 54.331005, 37.131241, -54.320820 },
				{ 55.128181, 38.039707, -59.649185 },
				{ 55.603996, 39.547546, -65.549309 },
				{ 55.889103, 41.177044, -71.654099 }
			},
			{
				{ 58.931782, 1.159312, 102.968475 },
				{ 58.863579, 1.888667, 86.978142 },
				{ 58.837818, 2.166058, 70.462936 },
				{ 57.778667, 1.883877, 52.964218 },
				{ 56.985661, 1.941160, 37.934387 },
				{ 57.557114, 2.774801, 26.876730 },
				{ 57.026085, 4.252969, 13.317321 },
				{ 57.868412, 7.459407, 3.629254 },
				{ 57.458099, 9.231683, -5.239428 },
				{ 56.751057, 13.362001, -17.732365 },
				{ 57.184921, 17.017202, -25.893906 },
				{ 57.767120, 20.867817, -33.364273 },
				{ 57.718323, 24.938145, -41.863319 },
				{ 57.643055, 28.467964, -50.125111 },
				{ 58.541149, 29.686718, -55.437096 },
				{ 58.873829, 31.060003, -61.037136 },
				{ 59.008057, 32.410419, -66.859680 }
			},
			{
				{ 63.527649, -5.758629, 107.983017 },
				{ 63.531952, -5.543822, 93.235039 },
				{ 62.144520, -6.247365, 76.149673 },
				{ 60.530869, -6.930553, 58.646793 },
				{ 60.795319, -6.078186, 44.841484 },
				{ 60.858791, -5.352928, 31.605366 },
				{ 60.078587, -5.124370, 19.345955 },
				{ 59.883236, -2.275414, 8.018429 },
				{ 60.457756, 0.446914, -1.498143 },
				{ 58.430347, -0.252345, -12.256646 },
				{ 60.088848, 6.126780, -20.916039 },
				{ 60.496971, 9.614503, -28.690090 },
				{ 60.917343, 12.621602, -35.879917 },
				{ 61.332394, 16.468441, -43.393448 },
				{ 61.638657, 19.904299, -50.528687 },
				{ 61.800373, 22.326252, -56.783165 },
				{ 61.922401, 23.546492, -62.363914 }
			},
			{
				{ 66.733536, -12.974520, 110.444786 },
				{ 66.846176, -13.025797, 96.261993 },
				{ 65.804901, -13.963538, 80.160782 },
				{ 65.280548, -14.213439, 65.406387 },
				{ 65.748093, -13.288476, 52.011677 },
				{ 65.205940, -12.603716, 38.763802 },
				{ 64.211449, -12.664260, 25.525415 },
				{ 63.142174, -11.111007, 12.063438 },
				{ 64.455421, -8.470541, 5.360389 },
				{ 64.901726, -6.682566, -2.151389 },
				{ 64.383232, -3.840443, -12.439588 },
				{ 63.865425, -0.456259, -22.792124 },
				{ 64.196556, 2.418413, -30.294230 },
				{ 64.622604, 5.541286, -37.180096 },
				{ 65.053726, 9.630558, -44.773178 },
				{ 64.785652, 12.713727, -52.086056 },
				{ 64.719673, 14.284692, -57.950775 }
			},
			{
				{ 69.441124, -20.307877, 111.928391 },
				{ 68.960007, -20.911278, 97.177589 },
				{ 68.519569, -21.589457, 82.686005 },
				{ 68.559052, -21.879587, 69.319130 },
				{ 68.328018, -21.588833, 56.054169 },
				{ 68.472763, -21.588648, 43.937717 },
				{ 68.977089, -20.529018, 33.043022 },
				{ 66.580429, -19.608747, 18.097511 },
				{ 67.302574, -17.899616, 10.019985 },
				{ 68.146645, -14.670630, 2.568020 },
				{ 67.666664, -12.582806, -7.319764 },
				{ 67.159950, -10.729312, -16.678013 },
				{ 67.292564, -7.969920, -24.533251 },
				{ 67.522354, -4.612776, -31.989208 },
				{ 68.029953, -0.681761, -39.071857 },
				{ 68.559349, 2.790170, -45.831612 },
				{ 67.480522, 4.671145, -53.377098 }
			},
			{
				{ 72.295341, -27.427048, 113.630814 },
				{ 71.973038, -28.420502, 99.464806 },
				{ 71.834534, -29.383507, 86.315590 },
				{ 71.802284, -29.648380, 73.836494 },
				{ 71.660423, -28.374796, 61.700375 },
				{ 71.117920, -28.770288, 48.920132 },
				{ 71.643761, -27.482374, 37.585674 },
				{ 69.583511, -27.848612, 22.916515 },
				{ 69.402275, -26.464781, 12.241356 },
				{ 69.246620, -24.243692, 3.113623 },
				{ 70.752937, -21.141960, -2.629330 },
				{ 70.807388, -18.947535, -10.493711 },
				{ 70.781731, -16.401628, -18.720413 },
				{ 70.991722, -13.751744, -26.278454 },
				{ 71.118919, -10.520143, -33.650208 },
				{ 71.182358, -7.718868, -40.778610 },
				{ 71.181076, -5.007509, -47.805679 }
			},
			{
				{ 75.255653, -34.192226, 115.644974 },
				{ 74.805656, -35.461979, 101.758919 },
				{ 74.756195, -36.408333, 88.922691 },
				{ 74.775253, -36.626255, 76.668777 },
				{ 74.933594, -37.145245, 64.852432 },
				{ 75.588417, -35.251770, 55.312813 },
				{ 75.703690, -35.552650, 43.723240 },
				{ 74.432663, -35.486477, 30.999527 },
				{ 73.899849, -34.006924, 21.478933 },
				{ 74.779602, -32.075516, 13.455732 },
				{ 74.945999, -28.904444, 5.152813 },
				{ 74.616264, -27.451628, -4.136810 },
				{ 74.146629, -25.700262, -12.823167 },
				{ 73.380035, -23.048746, -22.269676 },
				{ 73.888321, -20.173685, -28.822903 },
				{ 74.323982, -16.799322, -35.287186 },
				{ 74.327019, -14.534536, -42.398872 }
			},
			{
				{ 78.155411, -40.432568, 117.560852 },
				{ 77.674973, -41.965279, 103.843941 },
				{ 77.396667, -43.495262, 90.178543 },
				{ 77.506989, -44.340740, 77.630280 },
				{ 78.952820, -43.350033, 68.528534 },
				{ 80.205368, -40.659786, 61.251511 },
				{ 78.712822, -45.322845, 48.195923 },
				{ 78.452530, -43.509773, 37.547520 },
				{ 79.359871, -40.659378, 31.292709 },
				{ 78.896805, -38.628494, 22.002499 },
				{ 78.430237, -36.800537, 11.582246 },
				{ 77.490082, -35.263470, 1.531599 },
				{ 78.285637, -32.420643, -5.735914 },
				{ 78.427818, -29.252731, -13.396750 },
				{ 78.534515, -27.192913, -20.773666 },
				{ 79.041512, -24.090137, -27.477026 },
				{ 77.789467, -22.655169, -36.223515 }
			},
			{
				{ 80.900818, -46.170341, 119.020462 },
				{ 80.447113, -48.096798, 105.233818 },
				{ 79.673370, -50.137280, 90.297890 },
				{ 78.672760, -51.215893, 75.055290 },
				{ 79.982841, -48.569492, 67.780472 },
				{ 81.867569, -49.797421, 61.560993 },
				{ 83.429268, -50.990768, 54.461159 },
				{ 83.149651, -50.688873, 44.869415 },
				{ 83.130127, -48.314796, 36.928848 },
				{ 83.334023, -44.064240, 28.872965 },
				{ 83.956894, -42.512016, 20.652357 },
				{ 83.937653, -39.665565, 12.847577 },
				{ 83.790642, -37.388634, 4.483292 },
				{ 86.276627, -32.948952, -0.555250 },
				{ 85.559654, -30.826410, -9.389339 },
				{ 84.750130, -29.030441, -18.070053 },
				{ 83.540894, -27.827675, -27.145737 }
			},
			{
				{ 83.385818, -51.553661, 119.796295 },
				{ 83.210884, -53.865250, 106.500748 },
				{ 82.742905, -56.247429, 92.609528 },
				{ 82.178207, -57.879734, 79.019356 },
				{ 82.772232, -56.675144, 70.150162 },
				{ 83.929634, -53.881889, 64.247513 },
				{ 85.422485, -55.748676, 58.416321 },
				{ 87.204887, -54.141254, 51.266396 },
				{ 86.343193, -54.563942, 41.913853 },
				{ 86.680901, -51.221581, 33.695618 },
				{ 88.078972, -47.869335, 26.323996 },
				{ 86.294182, -47.491585, 18.853821 },
				{ 89.065216, -41.861702, 12.876225 },
				{ 90.209305, -38.342556, 6.700346 },
				{ 89.695503, -35.994843, -1.864177 },
				{ 89.339249, -34.243382, -10.326885 },
				{ 88.783401, -32.482193, -18.554493 }
			},
			{
				{ 85.663246, -56.783649, 120.125916 },
				{ 86.014824, -59.612011, 107.766663 },
				{ 86.504395, -62.625870, 95.927773 },
				{ 87.518562, -65.387283, 85.933067 },
				{ 89.440727, -66.102829, 79.458260 },
				{ 91.395950, -63.295391, 75.694397 },
				{ 90.903885, -61.921116, 67.663010 },
				{ 90.901787, -57.779095, 58.429546 },
				{ 90.735962, -57.958569, 48.656040 },
				{ 90.927307, -55.590115, 39.784889 },
				{ 92.248032, -52.919529, 32.479084 },
				{ 91.169762, -52.561005, 25.822456 },
				{ 92.778931, -47.830685, 19.611174 },
				{ 94.061996, -43.202812, 13.385343 },
				{ 94.418816, -40.111801, 6.190876 },
				{ 94.252151, -39.009155, -1.982836 },
				{ 93.708244, -37.158936, -10.344365 }
			}
		},
		{
			{
				{ 23.412098, 65.039368, 41.024754 },
				{ 21.611906, 67.490128, 22.104921 },
				{ 21.719557, 69.887947, 5.495251 },
				{ 23.160534, 72.134003, -7.818851 },
				{ 24.599606, 74.461548, -18.707153 },
				{ 25.589952, 76.717598, -28.583107 },
				{ 26.112144, 78.609192, -37.796562 },
				{ 26.707705, 79.982666, -45.644234 },
				{ 26.660839, 81.166786, -52.787453 },
				{ 26.453346, 82.498672, -59.547722 },
				{ 27.118670, 84.115776, -65.785141 },
				{ 28.476889, 85.836639, -71.692459 },
				{ 30.094322, 87.575020, -77.419708 },
				{ 31.841772, 89.464409, -83.039581 },
				{ 33.702454, 91.605309, -88.616776 },
				{ 35.637428, 93.958122, -94.199394 },
				{ 37.598919, 96.407104, -99.797089 }
			},
			{
				{ 29.830727, 56.157654, 55.224014 },
				{ 26.407715, 58.094757, 34.014389 },
				{ 26.922644, 60.632908, 15.454075 },
				{ 29.425444, 62.971958, 1.739683 },
				{ 30.802530, 65.330002, -9.690248 },
				{ 30.412731, 68.170059, -21.692730 },
				{ 30.039160, 70.152573, -32.699528 },
				{ 32.216076, 71.159332, -39.759785 },
				{ 32.234047, 72.016464, -46.233418 },
				{ 31.557087, 73.541389, -53.361401 },
				{ 32.326740, 75.265030, -59.796654 },
				{ 33.342274, 76.934792, -65.841751 },
				{ 34.545971, 78.831108, -71.633972 },
				{ 36.091293, 81.076981, -77.304871 },
				{ 37.771706, 83.529625, -83.035164 },
				{ 39.420837, 86.036163, -88.882256 },
				{ 41.022583, 88.537987, -94.796730 }
			},
			{
				{ 36.336849, 47.592506, 68.200417 },
				{ 34.071281, 49.365227, 47.632862 },
				{ 32.595383, 51.343945, 26.600996 },
				{ 34.596535, 53.537312, 11.387937 },
				{ 37.136093, 55.346764, -0.309255 },
				{ 35.359180, 57.946560, -14.288342 },
				{ 35.808708, 59.857433, -24.672016 },
				{ 36.739140, 61.382408, -32.993984 },
				{ 37.472797, 62.483326, -39.219090 },
				{ 38.155697, 64.713448, -46.280056 },
				{ 37.912216, 66.466743, -53.747780 },
				{ 37.938492, 68.092438, -60.194607 },
				{ 38.922039, 70.326569, -65.958496 },
				{ 40.406845, 72.944550, -71.622498 },
				{ 41.880821, 75.594894, -77.501404 },
				{ 43.188915, 78.134064, -83.605087 },
				{ 44.400036, 80.593925, -89.812485 }
			},
			{
				{ 42.258934, 39.035580, 78.494797 },
				{ 42.693748, 40.449509, 60.593372 },
				{ 41.946033, 41.687222, 41.490936 },
				{ 38.578568, 43.174889, 20.739519 },
				{ 37.696491, 45.147903, 4.605770 },
				{ 38.524300, 47.272648, -8.432681 },
				{ 41.956024, 49.644844, -16.511272 },
				{ 39.061928, 51.965939, -28.259838 },
				{ 40.872978, 52.692444, -32.948078 },
				{ 41.523361, 55.148251, -40.683594 },
				{ 41.259079, 57.317612, -48.875557 },
				{ 41.881920, 59.608341, -54.968273 },
				{ 43.429245, 62.491604, -60.438786 },
				{ 44.874908, 65.302795, -66.079643 },
				{ 45.986805, 67.871452, -72.118790 },
				{ 46.879837, 70.235977, -78.433174 },
				{ 47.700859, 72.511177, -84.847244 }
			},
			{
				{ 46.834900, 30.151939, 86.580887 },
				{ 48.731758, 31.476402, 71.098015 },
				{ 50.461250, 32.526802, 55.480946 },
				{ 48.415230, 33.398113, 36.667465 },
				{ 46.061230, 35.059486, 18.797882 },
				{ 43.556835, 37.336708, 1.055432 },
				{ 43.877346, 40.536045, -11.206631 },
				{ 42.844929, 41.782898, -22.463974 },
				{ 45.021744, 43.909748, -28.286249 },
				{ 42.897797, 46.104763, -38.100739 },
				{ 43.851341, 48.922634, -44.974491 },
				{ 46.169765, 52.503063, -50.075882 },
				{ 48.214794, 55.485619, -55.143639 },
				{ 49.303455, 58.037968, -60.835625 },
				{ 49.914818, 60.249092, -67.014214 },
				{ 50.429966, 62.291061, -73.415291 },
				{ 50.955769, 64.292679, -79.872818 }
			},
			{
				{ 51.155544, 21.775232, 93.665558 },
				{ 53.795082, 23.130915, 80.118393 },
				{ 54.798908, 24.395023, 63.972412 },
				{ 53.449760, 25.993490, 46.004471 },
				{ 52.237133, 26.311287, 30.030128 },
				{ 51.316021, 28.369825, 15.615261 },
				{ 50.384361, 30.443657, 2.576066 },
				{ 48.920609, 31.561419, -11.627506 },
				{ 47.003036, 33.872242, -25.683661 },
				{ 47.028210, 36.326672, -33.168331 },
				{ 48.785900, 40.818375, -39.253567 },
				{ 51.035248, 45.144512, -44.794800 },
				{ 52.794132, 48.482086, -50.095207 },
				{ 53.246082, 50.677456, -56.028805 },
				{ 53.537060, 52.513962, -62.223839 },
				{ 53.875515, 54.251617, -68.520126 },
				{ 54.231503, 55.983925, -74.844254 }
			},
			{
				{ 55.955650, 14.210527, 100.585930 },
				{ 57.205456, 15.375341, 85.065758 },
				{ 56.996780, 16.186579, 67.707932 },
				{ 57.463551, 16.747389, 52.542618 },
				{ 55.973141, 16.321228, 37.101784 },
				{ 55.121021, 16.853506, 23.647316 },
				{ 55.925964, 20.141315, 12.813906 },
				{ 53.949909, 22.339924, -0.517519 },
				{ 52.917591, 24.766338, -14.107433 },
				{ 53.232330, 27.119019, -22.444090 },
				{ 53.426117, 30.613113, -31.249044 },
				{ 54.671318, 35.790844, -38.699261 },
				{ 56.002762, 40.367859, -45.258572 },
				{ 56.387886, 42.534428, -51.530739 },
				{ 57.027847, 44.433983, -57.543530 },
				{ 57.377354, 46.078636, -63.596260 },
				{ 57.541588, 47.572220, -69.740196 }
			},
			{
				{ 60.657612, 7.101519, 106.714455 },
				{ 60.979027, 7.951259, 90.193153 },
				{ 60.519695, 8.589045, 72.631805 },
				{ 60.395790, 9.026114, 57.230179 },
				{ 60.696465, 10.056228, 43.363350 },
				{ 58.983711, 8.840920, 31.431303 },
				{ 58.660267, 11.364512, 14.274028 },
				{ 60.096127, 14.181482, 5.284166 },
				{ 58.782795, 17.604820, -8.189269 },
				{ 57.833126, 18.608469, -16.264664 },
				{ 58.453388, 23.139177, -24.356987 },
				{ 59.041176, 27.330175, -31.808622 },
				{ 59.444111, 30.820007, -39.303474 },
				{ 59.397133, 33.522305, -46.921402 },
				{ 60.732479, 35.781830, -52.610546 },
				{ 60.962715, 37.646542, -58.488857 },
				{ 60.798695, 38.881298, -64.581802 }
			},
			{
				{ 64.773811, 0.259441, 111.203461 },
				{ 64.593094, 0.542267, 94.777946 },
				{ 65.001068, 1.066077, 79.182991 },
				{ 64.838600, 1.292001, 64.417931 },
				{ 63.271149, 1.306726, 49.429981 },
				{ 63.423801, 1.248771, 36.954247 },
				{ 61.646450, 0.257949, 23.467422 },
				{ 61.226471, 4.374916, 9.928648 },
				{ 62.261063, 7.710450, -0.255517 },
				{ 61.877556, 10.034693, -9.531917 },
				{ 61.795067, 12.853320, -18.601381 },
				{ 62.351814, 16.392628, -26.337473 },
				{ 62.838333, 19.245361, -33.068821 },
				{ 63.273964, 23.076077, -40.405685 },
				{ 63.668831, 25.910566, -47.427559 },
				{ 63.925072, 28.473595, -53.636768 },
				{ 63.948193, 29.629322, -59.356319 }
			},
			{
				{ 68.057777, -6.657614, 113.866226 },
				{ 67.986694, -6.626807, 98.060188 },
				{ 68.714539, -6.501266, 84.429070 },
				{ 68.839928, -6.297818, 70.568367 },
				{ 67.333565, -5.732305, 55.083214 },
				{ 67.319160, -4.888361, 42.949772 },
				{ 65.926407, -4.621775, 28.958605 },
				{ 66.150383, -4.166753, 18.969570 },
				{ 66.557411, -2.015568, 10.528715 },
				{ 66.690788, 0.284221, 0.481741 },
				{ 66.334091, 2.602130, -9.466049 },
				{ 66.369568, 5.936941, -18.599394 },
				{ 66.234535, 8.669911, -26.777996 },
				{ 66.058502, 11.679163, -34.805801 },
				{ 66.582458, 15.326474, -42.100140 },
				{ 66.746696, 18.009691, -48.706032 },
				{ 67.190063, 19.843208, -53.848366 }
			},
			{
				{ 71.188095, -13.584580, 116.135895 },
				{ 71.091438, -13.764445, 101.191269 },
				{ 71.522186, -14.311315, 87.415459 },
				{ 70.496727, -14.462589, 72.486580 },
				{ 68.648239, -14.814835, 56.932415 },
				{ 69.762482, -13.982756, 46.495560 },
				{ 69.503792, -13.201355, 34.515137 },
				{ 68.054451, -12.400944, 21.121201 },
				{ 68.980255, -10.422908, 13.147013 },
				{ 69.481705, -8.306414, 4.908546 },
				{ 69.088272, -5.768641, -5.296941 },
				{ 68.910774, -3.367719, -14.062294 },
				{ 69.565216, -1.068692, -20.989040 },
				{ 69.670784, 2.034774, -28.706064 },
				{ 69.879379, 5.114336, -36.200928 },
				{ 70.079445, 8.238202, -43.101055 },
				{ 70.721077, 10.348651, -48.309875 }
			},
			{
				{ 74.383308, -20.411808, 118.351646 },
				{ 74.341606, -21.102236, 103.663292 },
				{ 74.463722, -21.926397, 89.402557 },
				{ 74.201569, -21.855906, 76.437309 },
				{ 74.423927, -20.371279, 65.610725 },
				{ 73.400772, -21.304836, 52.470379 },
				{ 72.497757, -21.559914, 39.288017 },
				{ 71.265427, -20.643339, 25.773987 },
				{ 72.767982, -18.520800, 18.787903 },
				{ 72.922585, -16.515749, 9.973615 },
				{ 73.471298, -13.891831, 2.427691 },
				{ 73.245369, -12.319766, -5.454950 },
				{ 72.800278, -9.365343, -15.301738 },
				{ 72.621422, -6.647183, -23.820974 },
				{ 72.806511, -4.166758, -31.052971 },
				{ 72.609398, -1.516843, -38.632900 },
				{ 73.328682, 1.157101, -44.051617 }
			},
			{
				{ 77.475296, -26.915995, 120.306870 },
				{ 76.663269, -28.429958, 104.513374 },
				{ 74.990944, -30.021608, 86.890419 },
				{ 73.862984, -31.294836, 71.022865 },
				{ 76.871407, -29.364363, 67.257973 },
				{ 77.693047, -28.303263, 58.795280 },
				{ 75.373291, -28.799631, 43.734997 },
				{ 75.046471, -27.979643, 31.760000 },
				{ 75.646599, -26.707670, 23.557598 },
				{ 75.327873, -24.613256, 14.284280 },
				{ 76.636536, -22.125040, 7.727673 },
				{ 76.429588, -20.788153, -0.306090 },
				{ 76.608269, -18.526485, -8.346106 },
				{ 75.813858, -15.555935, -18.383053 },
				{ 75.971497, -13.115920, -25.757746 },
				{ 76.076904, -10.416206, -32.817562 },
				{ 75.335854, -8.659841, -40.107811 }
			},
			{
				{ 80.209724, -32.865864, 121.489204 },
				{ 79.295914, -35.058151, 105.660797 },
				{ 78.264771, -37.033745, 89.457703 },
				{ 77.965424, -37.638802, 75.738876 },
				{ 81.225861, -36.254883, 71.904861 },
				{ 80.806107, -36.387218, 62.986679 },
				{ 80.472572, -36.945805, 51.744915 },
				{ 78.803856, -36.252014, 37.778008 },
				{ 78.209145, -34.596546, 28.038088 },
				{ 80.180611, -32.081825, 22.652855 },
				{ 78.550049, -30.768814, 11.346856 },
				{ 79.476997, -27.997650, 3.678406 },
				{ 78.649384, -26.590210, -5.374319 },
				{ 79.947739, -23.505293, -11.168122 },
				{ 79.115257, -21.622684, -19.678186 },
				{ 79.475777, -18.710041, -26.839607 },
				{ 79.257668, -16.823723, -34.056736 }
			},
			{
				{ 82.787109, -38.164608, 122.286156 },
				{ 82.148140, -40.681667, 107.217422 },
				{ 81.697945, -43.202614, 92.468758 },
				{ 81.224365, -45.170513, 78.561455 },
				{ 82.893562, -45.345188, 71.694237 },
				{ 83.484093, -45.679699, 64.685936 },
				{ 84.192017, -45.264439, 57.132168 },
				{ 84.002731, -44.418930, 46.068100 },
				{ 83.888321, -41.000492, 36.902946 },
				{ 85.313927, -38.145805, 30.536810 },
				{ 83.288788, -37.501984, 19.931849 },
				{ 84.905357, -34.072899, 13.688304 },
				{ 82.623894, -32.937813, 2.110718 },
				{ 87.289215, -27.571396, 0.268299 },
				{ 85.815025, -26.343197, -8.765968 },
				{ 84.947861, -24.586096, -17.778563 },
				{ 84.196045, -23.015114, -26.168451 }
			},
			{
				{ 85.271446, -43.052429, 122.846283 },
				{ 85.163635, -45.433922, 109.403580 },
				{ 84.867828, -48.202141, 95.834946 },
				{ 84.103111, -52.482399, 81.707161 },
				{ 84.547340, -55.965378, 72.747398 },
				{ 85.610344, -54.508034, 66.680573 },
				{ 87.297134, -50.051254, 61.394131 },
				{ 87.247231, -48.945015, 51.476715 },
				{ 87.636879, -46.236134, 43.736046 },
				{ 87.342155, -43.726334, 34.771854 },
				{ 87.530174, -44.052528, 27.062418 },
				{ 88.145569, -41.399017, 20.887493 },
				{ 88.062912, -38.625431, 11.875647 },
				{ 90.287659, -34.152878, 7.028690 },
				{ 90.829514, -31.557795, -0.280717 },
				{ 90.087822, -30.021772, -9.271255 },
				{ 88.924538, -28.378687, -18.103491 }
			},
			{
				{ 87.611656, -47.857334, 123.118279 },
				{ 88.248322, -50.165211, 111.738853 },
				{ 89.027916, -52.579937, 100.928284 },
				{ 90.062775, -55.419334, 91.507751 },
				{ 90.917610, -58.962433, 83.669708 },
				{ 91.243004, -60.316383, 76.564186 },
				{ 91.518295, -57.591370, 68.357597 },
				{ 92.147049, -53.657009, 59.390919 },
				{ 91.837921, -52.282242, 50.499702 },
				{ 91.440392, -50.556084, 41.436031 },
				{ 92.180687, -48.297699, 33.686180 },
				{ 92.539246, -46.705994, 27.095684 },
				{ 92.445801, -44.277313, 20.125080 },
				{ 93.605164, -40.190285, 14.191375 },
				{ 95.229057, -36.454411, 7.783226 },
				{ 95.207100, -34.713223, -0.738582 },
				{ 94.178101, -33.071693, -9.688408 }
			}
		},
		{
			{
				{ 25.007967, 69.464005, 43.422165 },
				{ 23.364790, 71.789742, 24.868448 },
				{ 24.118303, 74.025200, 8.851120 },
				{ 26.240593, 75.928696, -3.539302 },
				{ 27.843405, 77.689659, -13.897122 },
				{ 28.622723, 79.422653, -23.531513 },
				{ 29.075781, 81.205338, -32.662304 },
				{ 29.484919, 82.893181, -40.804794 },
				{ 29.375208, 84.426559, -48.318935 },
				{ 29.037685, 85.945160, -55.593403 },
				{ 29.448395, 87.522072, -62.401676 },
				{ 30.615078, 89.024895, -68.715942 },
				{ 32.075943, 90.500816, -74.736145 },
				{ 33.666393, 92.203568, -80.637878 },
				{ 35.369701, 94.262726, -86.516640 },
				{ 37.156261, 96.608749, -92.408905 },
				{ 38.977520, 99.082092, -98.314774 }
			},
			{
				{ 31.892046, 61.345623, 59.167629 },
				{ 29.355358, 63.543800, 39.187199 },
				{ 29.116659, 66.046677, 18.029247 },
				{ 31.324451, 67.440010, 4.481884 },
				{ 31.965761, 69.132004, -6.994662 },
				{ 31.815756, 70.933044, -18.098680 },
				{ 32.741112, 72.853004, -27.963467 },
				{ 34.534248, 74.564476, -35.382675 },
				{ 35.222450, 75.995903, -41.911377 },
				{ 35.515823, 77.651657, -48.762436 },
				{ 35.283035, 79.211273, -56.010029 },
				{ 35.459309, 80.441917, -62.659409 },
				{ 36.386574, 82.082306, -68.864578 },
				{ 37.812954, 84.254791, -74.918694 },
				{ 39.399300, 86.727768, -80.986626 },
				{ 40.969494, 89.301285, -87.116425 },
				{ 42.502323, 91.890022, -93.285690 }
			},
			{
				{ 38.913120, 53.199162, 73.216148 },
				{ 39.721397, 55.388912, 55.992340 },
				{ 35.740253, 57.201759, 30.928585 },
				{ 35.755028, 58.233139, 13.587786 },
				{ 35.527306, 60.156376, -0.314968 },
				{ 34.781017, 62.391289, -13.036380 },
				{ 36.574326, 63.936020, -21.849476 },
				{ 38.566586, 65.165459, -28.739990 },
				{ 40.253513, 66.872719, -35.114098 },
				{ 42.999870, 69.330910, -41.314457 },
				{ 41.740574, 70.929863, -49.362629 },
				{ 40.229115, 71.872810, -56.609673 },
				{ 40.731789, 73.915550, -63.038128 },
				{ 42.075840, 76.580772, -69.245132 },
				{ 43.488178, 79.340096, -75.504021 },
				{ 44.769314, 82.010002, -81.861984 },
				{ 45.966316, 84.612984, -88.274635 }
			},
			{
				{ 45.441463, 44.651951, 84.139046 },
				{ 47.289669, 46.172192, 67.507408 },
				{ 43.921989, 47.398956, 44.898079 },
				{ 40.395264, 48.541916, 23.346449 },
				{ 39.387814, 50.042419, 6.840150 },
				{ 38.884407, 52.770229, -7.570076 },
				{ 41.424572, 54.941990, -14.919759 },
				{ 41.152946, 55.147583, -22.689144 },
				{ 43.570881, 57.127594, -29.354103 },
				{ 46.733276, 60.208504, -35.902424 },
				{ 44.901764, 61.854317, -44.138527 },
				{ 44.644886, 63.857815, -50.871082 },
				{ 45.479786, 66.538773, -57.276028 },
				{ 46.592613, 69.422882, -63.681732 },
				{ 47.604870, 72.155029, -70.156647 },
				{ 48.489937, 74.702194, -76.703423 },
				{ 49.318890, 77.165565, -83.287842 }
			},
			{
				{ 50.950405, 35.651489, 92.899040 },
				{ 51.961220, 36.906124, 76.313957 },
				{ 50.619690, 38.512787, 57.027771 },
				{ 49.720043, 39.931210, 39.219994 },
				{ 46.732334, 40.328312, 20.609516 },
				{ 44.665234, 42.863045, 3.935264 },
				{ 45.090748, 45.678631, -7.063705 },
				{ 45.572247, 46.915325, -17.921329 },
				{ 45.548321, 49.402988, -28.196365 },
				{ 44.250206, 51.602707, -37.488342 },
				{ 47.196175, 54.383862, -40.922115 },
				{ 49.826237, 57.666248, -45.503250 },
				{ 50.654819, 60.131859, -51.755722 },
				{ 51.118980, 62.635300, -58.402710 },
				{ 51.560596, 65.032005, -65.056770 },
				{ 52.051754, 67.299202, -71.682808 },
				{ 52.575508, 69.513756, -78.294853 }
			},
			{
				{ 54.275810, 27.399700, 98.585129 },
				{ 54.894577, 28.626717, 82.197350 },
				{ 55.449085, 30.116003, 65.199318 },
				{ 56.437027, 31.508162, 50.188568 },
				{ 56.431740, 31.537140, 36.134270 },
				{ 53.937485, 33.884647, 20.089373 },
				{ 51.855652, 36.133049, 5.761715 },
				{ 50.599224, 37.463192, -9.213829 },
				{ 49.067448, 39.857677, -22.777660 },
				{ 48.652603, 42.287224, -31.533270 },
				{ 51.141716, 45.971596, -35.215313 },
				{ 54.013458, 50.762783, -40.667168 },
				{ 55.162189, 53.657940, -46.932335 },
				{ 55.134697, 55.664875, -53.584202 },
				{ 55.184044, 57.704098, -60.243542 },
				{ 55.444130, 59.712589, -66.777084 },
				{ 55.809288, 61.645344, -73.223381 }
			},
			{
				{ 57.994461, 19.984388, 103.978012 },
				{ 58.254784, 21.068808, 86.735519 },
				{ 58.065983, 22.113817, 68.646881 },
				{ 59.082825, 22.431826, 55.123695 },
				{ 60.582500, 23.338833, 43.134789 },
				{ 60.187325, 24.506983, 30.148380 },
				{ 59.474922, 26.013798, 17.935059 },
				{ 57.533592, 28.938419, 3.309183 },
				{ 56.110477, 31.256676, -9.358533 },
				{ 54.634678, 33.510036, -21.187288 },
				{ 55.471462, 37.778278, -29.140774 },
				{ 56.147717, 41.150238, -35.929401 },
				{ 57.871170, 45.297794, -42.469910 },
				{ 58.303139, 47.543526, -48.984844 },
				{ 58.515434, 49.766319, -55.537151 },
				{ 58.774509, 51.809086, -61.827431 },
				{ 59.092281, 53.460159, -67.965683 }
			},
			{
				{ 62.214386, 12.955357, 109.464493 },
				{ 62.421715, 13.449973, 92.531296 },
				{ 61.952969, 13.856644, 75.310608 },
				{ 61.323696, 14.619529, 59.513798 },
				{ 61.394749, 16.096025, 44.764393 },
				{ 60.440807, 16.155579, 32.932014 },
				{ 57.354038, 15.074121, 17.432964 },
				{ 59.216816, 20.388004, 6.395698 },
				{ 60.176437, 22.512596, -1.824601 },
				{ 59.857822, 24.600956, -12.767461 },
				{ 60.231869, 28.942030, -21.717096 },
				{ 60.970493, 33.137638, -29.187841 },
				{ 61.251923, 36.084469, -36.814167 },
				{ 61.082329, 37.854382, -44.138592 },
				{ 61.972610, 40.783794, -50.370220 },
				{ 62.335735, 43.216122, -56.375328 },
				{ 62.444378, 44.666080, -62.388336 }
			},
			{
				{ 65.907272, 6.069897, 113.835533 },
				{ 65.104149, 5.922807, 96.017586 },
				{ 65.189880, 6.240343, 79.002052 },
				{ 66.108879, 7.595717, 64.264313 },
				{ 65.226761, 8.079943, 50.780010 },
				{ 65.854370, 8.444172, 40.997166 },
				{ 63.948250, 8.638453, 26.610451 },
				{ 64.342476, 11.139557, 14.532111 },
				{ 64.371780, 13.495421, 5.117900 },
				{ 65.257759, 15.026484, -2.936281 },
				{ 63.340641, 17.948792, -15.510667 },
				{ 64.212334, 21.991552, -23.419954 },
				{ 64.668739, 25.757444, -30.563803 },
				{ 64.847084, 28.446585, -37.814976 },
				{ 65.639755, 31.244284, -44.157543 },
				{ 65.889473, 33.700500, -50.405296 },
				{ 65.833344, 34.963390, -56.401882 }
			},
			{
				{ 69.438644, -0.803112, 117.515167 },
				{ 68.870071, -1.169786, 100.852875 },
				{ 69.313713, -1.042704, 86.059708 },
				{ 68.454590, -1.353031, 70.057320 },
				{ 67.351997, -0.740641, 55.191898 },
				{ 69.557045, 1.898953, 46.079128 },
				{ 67.660583, 2.381584, 31.770943 },
				{ 67.981964, 2.761379, 21.590689 },
				{ 68.688896, 4.391176, 13.236986 },
				{ 69.341759, 6.433136, 4.944002 },
				{ 67.793900, 8.077922, -7.094666 },
				{ 67.431290, 10.875298, -16.712900 },
				{ 68.167007, 14.632334, -23.766298 },
				{ 68.115112, 17.406786, -31.624493 },
				{ 68.440613, 21.510239, -39.227249 },
				{ 68.986679, 23.646143, -44.909218 },
				{ 69.327126, 24.731777, -50.081783 }
			},
			{
				{ 72.977760, -7.511087, 120.714355 },
				{ 72.994560, -7.796461, 105.700775 },
				{ 73.725464, -7.592741, 91.856110 },
				{ 72.245209, -8.025189, 76.025795 },
				{ 71.567337, -8.106616, 62.061478 },
				{ 72.422737, -6.254228, 50.514439 },
				{ 70.608009, -5.449243, 36.015137 },
				{ 70.376961, -4.781026, 24.990898 },
				{ 70.374664, -2.846995, 15.115644 },
				{ 70.979706, -2.271999, 7.891921 },
				{ 71.021263, -0.169337, -1.241519 },
				{ 70.734245, 3.106444, -11.274156 },
				{ 71.083984, 5.785175, -19.036058 },
				{ 71.155830, 7.582331, -26.259529 },
				{ 71.386765, 11.143704, -34.145542 },
				{ 71.929642, 14.050611, -40.112915 },
				{ 72.645355, 15.529947, -44.600544 }
			},
			{
				{ 76.440338, -13.949052, 123.184349 },
				{ 76.238197, -14.704484, 107.712906 },
				{ 75.140442, -16.017778, 90.903236 },
				{ 76.059464, -14.315316, 80.472275 },
				{ 77.610680, -12.242366, 72.590866 },
				{ 76.085106, -14.019412, 57.498138 },
				{ 74.807365, -13.833044, 43.024738 },
				{ 75.363579, -12.455353, 33.912308 },
				{ 73.913582, -11.355096, 21.620285 },
				{ 75.041832, -11.155926, 14.902818 },
				{ 74.960106, -8.744184, 5.979811 },
				{ 75.265518, -5.542122, -2.639218 },
				{ 74.721069, -3.791111, -11.920462 },
				{ 74.497276, -1.738834, -20.224245 },
				{ 74.594002, 1.861402, -28.514706 },
				{ 74.338539, 4.738355, -36.113956 },
				{ 75.430466, 6.654724, -40.313274 }
			},
			{
				{ 79.457146, -20.120087, 124.563919 },
				{ 78.850693, -21.498943, 108.671631 },
				{ 77.624916, -22.818111, 91.436401 },
				{ 77.139420, -21.893957, 77.792145 },
				{ 80.025642, -21.152300, 74.432220 },
				{ 79.194595, -21.686518, 62.542557 },
				{ 78.225319, -21.718866, 49.000584 },
				{ 76.680817, -21.600269, 35.410160 },
				{ 76.266747, -20.192253, 24.994980 },
				{ 78.060120, -17.243908, 18.902832 },
				{ 78.411804, -15.576947, 10.976819 },
				{ 78.960335, -13.175617, 3.179472 },
				{ 78.342529, -11.566710, -5.785654 },
				{ 77.685768, -10.011792, -14.882775 },
				{ 77.731110, -6.703271, -22.875017 },
				{ 77.833359, -4.053360, -30.141006 },
				{ 77.602715, -2.492078, -36.483665 }
			},
			{
				{ 82.117142, -25.707586, 125.193619 },
				{ 81.434616, -27.631680, 109.345306 },
				{ 80.726372, -29.199757, 93.464699 },
				{ 80.761620, -28.955439, 81.436440 },
				{ 81.349884, -29.766499, 73.868576 },
				{ 82.277168, -29.242220, 64.973122 },
				{ 82.760162, -27.764271, 55.197605 },
				{ 79.401428, -29.027132, 39.032860 },
				{ 79.934242, -27.962957, 30.085892 },
				{ 82.181366, -24.776962, 25.228275 },
				{ 80.790825, -23.748217, 14.887594 },
				{ 79.886574, -21.694105, 4.922039 },
				{ 80.327660, -20.130560, -2.850766 },
				{ 80.408821, -18.271904, -10.080324 },
				{ 80.645378, -15.273351, -17.763857 },
				{ 80.810303, -12.949855, -24.732086 },
				{ 80.927940, -10.963624, -31.247665 }
			},
			{
				{ 84.671539, -30.649927, 125.670746 },
				{ 84.131874, -32.809994, 110.738960 },
				{ 83.397133, -34.925655, 95.918404 },
				{ 82.743088, -37.206131, 83.409439 },
				{ 83.880295, -38.220650, 75.187187 },
				{ 84.475357, -35.430847, 66.964035 },
				{ 83.673668, -34.511078, 56.494457 },
				{ 82.951385, -36.037548, 44.494762 },
				{ 83.633690, -34.507801, 36.042278 },
				{ 84.841255, -32.855274, 30.376818 },
				{ 84.241173, -31.514208, 21.263172 },
				{ 85.507660, -28.453672, 14.405935 },
				{ 84.742149, -27.279686, 4.896705 },
				{ 85.615234, -24.000864, -0.770090 },
				{ 85.786034, -22.061895, -8.699727 },
				{ 84.967361, -19.994146, -17.587982 },
				{ 84.492516, -18.360004, -25.331232 }
			},
			{
				{ 87.165230, -35.222401, 126.140907 },
				{ 87.295425, -37.154919, 113.411774 },
				{ 87.383163, -39.269794, 100.664398 },
				{ 87.515236, -42.396336, 88.743645 },
				{ 87.826744, -44.405743, 80.551910 },
				{ 87.956352, -41.767754, 71.969635 },
				{ 88.398476, -40.037216, 63.147995 },
				{ 88.191170, -38.995235, 53.821518 },
				{ 88.345970, -37.525116, 45.018848 },
				{ 88.523254, -36.540401, 36.146214 },
				{ 88.890289, -36.602024, 28.152132 },
				{ 87.800468, -36.153778, 20.019840 },
				{ 90.826721, -32.227257, 14.835686 },
				{ 91.108566, -28.648891, 9.342751 },
				{ 92.788185, -25.902777, 3.142650 },
				{ 91.291679, -24.816679, -7.631957 },
				{ 89.394470, -24.036978, -17.453638 }
			},
			{
				{ 89.613396, -39.751347, 126.507233 },
				{ 90.550819, -41.546623, 116.277184 },
				{ 91.700607, -43.150185, 106.605232 },
				{ 93.016029, -44.618073, 97.986023 },
				{ 92.976433, -48.297546, 88.518501 },
				{ 91.950333, -53.082310, 77.867325 },
				{ 92.375824, -51.722019, 68.654221 },
				{ 94.045189, -45.182533, 61.604927 },
				{ 93.277580, -44.706333, 52.781040 },
				{ 93.435692, -43.486782, 44.346863 },
				{ 93.202621, -41.198311, 36.149662 },
				{ 92.585388, -41.339500, 27.802120 },
				{ 93.822662, -38.739204, 21.378626 },
				{ 94.367416, -35.659489, 15.142886 },
				{ 95.283066, -32.576412, 8.065529 },
				{ 95.241486, -30.796267, -0.972884 },
				{ 94.767021, -28.985113, -9.019497 }
			}
		},
		{
			{
				{ 26.351654, 74.282837, 46.054790 },
				{ 25.913986, 76.257156, 29.072365 },
				{ 27.532913, 77.971512, 14.144938 },
				{ 30.235426, 79.196129, 2.655995 },
				{ 31.625452, 80.316994, -7.659795 },
				{ 31.897173, 81.486732, -17.448868 },
				{ 32.255314, 82.966270, -26.273668 },
				{ 32.605499, 84.805801, -34.420315 },
				{ 32.560280, 86.859093, -42.503601 },
				{ 32.365082, 88.997093, -50.678413 },
				{ 32.654060, 90.943069, -58.390842 },
				{ 33.574516, 92.440262, -65.324562 },
				{ 34.718735, 93.766708, -71.825279 },
				{ 35.960201, 95.342216, -78.189705 },
				{ 37.315666, 97.329224, -84.533157 },
				{ 38.770226, 99.638031, -90.881729 },
				{ 40.270947, 102.086571, -97.235313 }
			},
			{
				{ 32.908688, 66.591721, 61.758854 },
				{ 32.051369, 68.474434, 44.069355 },
				{ 33.110264, 70.448509, 23.622545 },
				{ 35.641331, 71.095161, 10.556567 },
				{ 35.023762, 72.177147, -2.043510 },
				{ 33.839577, 73.128891, -13.502933 },
				{ 35.538029, 75.226715, -22.722912 },
				{ 36.681389, 77.505760, -30.447554 },
				{ 37.526886, 79.255280, -37.251186 },
				{ 38.016182, 81.083710, -44.490177 },
				{ 37.065697, 82.917427, -52.771923 },
				{ 37.859940, 83.921417, -59.319023 },
				{ 38.807919, 85.482758, -65.877167 },
				{ 39.972588, 87.664970, -72.461807 },
				{ 41.275520, 90.158958, -79.012794 },
				{ 42.601685, 92.753975, -85.547760 },
				{ 43.915268, 95.367622, -92.083961 }
			},
			{
				{ 40.151424, 58.775597, 76.077438 },
				{ 41.333008, 59.955929, 60.289944 },
				{ 41.770817, 61.148308, 39.541370 },
				{ 39.635899, 62.652065, 18.440424 },
				{ 37.849457, 64.186897, 2.989131 },
				{ 37.500759, 65.726357, -8.971111 },
				{ 39.497890, 68.306740, -18.978588 },
				{ 40.419395, 70.554337, -26.817781 },
				{ 42.164642, 71.782646, -32.475216 },
				{ 44.298290, 72.871834, -37.699966 },
				{ 42.376377, 73.887054, -45.949673 },
				{ 42.134655, 74.938988, -52.983795 },
				{ 42.915726, 77.352478, -59.944775 },
				{ 44.097675, 80.254570, -66.785400 },
				{ 45.302471, 83.127708, -73.530327 },
				{ 46.424660, 85.875267, -80.241302 },
				{ 47.492874, 88.556458, -86.950333 }
			},
			{
				{ 47.404438, 50.323456, 87.513008 },
				{ 49.288006, 51.123802, 72.479034 },
				{ 46.918282, 51.951103, 50.607349 },
				{ 41.698524, 53.416691, 25.268270 },
				{ 41.926121, 55.257504, 10.261526 },
				{ 40.961906, 57.446754, -3.528602 },
				{ 42.230469, 60.349155, -14.202133 },
				{ 43.177631, 61.821335, -22.689360 },
				{ 45.540524, 63.801758, -28.723408 },
				{ 48.150280, 64.136917, -32.318512 },
				{ 45.749844, 62.749195, -39.072674 },
				{ 46.032185, 65.872719, -46.707783 },
				{ 47.365414, 69.907143, -54.082401 },
				{ 48.476608, 73.322548, -61.196487 },
				{ 49.377151, 76.256386, -68.141121 },
				{ 50.176708, 78.942810, -75.002464 },
				{ 50.938187, 81.546112, -81.842285 }
			},
			{
				{ 54.637455, 41.079052, 97.850212 },
				{ 55.316067, 41.590557, 81.801720 },
				{ 53.042591, 42.983753, 61.496937 },
				{ 52.136070, 44.451992, 42.684700 },
				{ 48.886726, 46.318794, 24.058582 },
				{ 45.674667, 48.787254, 7.039194 },
				{ 47.897240, 50.992065, -3.289209 },
				{ 45.612343, 52.470669, -17.999046 },
				{ 46.897060, 54.981281, -26.880684 },
				{ 47.080879, 54.995869, -31.659754 },
				{ 49.371246, 55.422100, -34.821095 },
				{ 51.375996, 59.618801, -41.056770 },
				{ 52.398956, 63.526924, -48.437153 },
				{ 52.880161, 66.661362, -55.827473 },
				{ 53.309898, 69.358040, -62.932861 },
				{ 53.768688, 71.843781, -69.860367 },
				{ 54.243649, 74.260834, -76.729042 }
			},
			{
				{ 58.440125, 32.821079, 104.307579 },
				{ 59.042603, 33.184628, 88.956291 },
				{ 58.660770, 34.871525, 70.277809 },
				{ 58.451069, 35.864536, 53.944908 },
				{ 58.440384, 36.699497, 39.795498 },
				{ 55.583145, 38.157249, 22.844913 },
				{ 55.531090, 40.896717, 10.894418 },
				{ 51.957172, 41.953888, -5.862464 },
				{ 50.767830, 45.151928, -19.686340 },
				{ 53.062916, 47.441238, -25.314528 },
				{ 54.715649, 50.643517, -31.066290 },
				{ 56.889149, 53.964737, -35.985294 },
				{ 56.938068, 57.264042, -43.563328 },
				{ 56.819801, 59.801449, -50.938038 },
				{ 56.924751, 62.186928, -57.967670 },
				{ 57.149300, 64.463867, -64.801453 },
				{ 57.462536, 66.629105, -71.528336 }
			},
			{
				{ 60.924023, 25.931244, 108.367424 },
				{ 60.792053, 26.980116, 91.417099 },
				{ 62.292328, 27.645771, 75.999100 },
				{ 61.484524, 27.839846, 59.800228 },
				{ 60.990864, 28.557320, 45.113365 },
				{ 58.114052, 28.894320, 29.311800 },
				{ 59.612728, 32.017719, 18.433598 },
				{ 58.138355, 33.978661, 5.101844 },
				{ 57.389099, 36.031963, -7.055630 },
				{ 56.108440, 38.434914, -19.230646 },
				{ 56.704334, 42.411251, -27.173285 },
				{ 58.939186, 45.581398, -32.286461 },
				{ 59.174744, 49.354992, -39.986046 },
				{ 60.121685, 52.116440, -46.384102 },
				{ 60.178711, 54.429302, -53.155926 },
				{ 60.314964, 56.646759, -59.744560 },
				{ 60.680614, 58.508995, -66.111389 }
			},
			{
				{ 64.253601, 19.164999, 112.739883 },
				{ 64.622887, 20.116644, 96.307007 },
				{ 65.333138, 20.191437, 81.768150 },
				{ 64.546234, 20.080067, 65.136024 },
				{ 63.697052, 21.450920, 49.140305 },
				{ 64.294029, 22.824596, 37.818665 },
				{ 60.260223, 22.124716, 21.943392 },
				{ 60.526443, 25.851137, 8.636040 },
				{ 61.252930, 27.885906, -0.531921 },
				{ 60.543259, 30.134155, -11.908601 },
				{ 61.718212, 34.688251, -19.475567 },
				{ 62.674747, 38.476330, -26.809889 },
				{ 61.552532, 40.731117, -35.733913 },
				{ 63.406548, 43.169521, -41.221634 },
				{ 63.195118, 45.611671, -48.127514 },
				{ 63.508301, 47.886211, -54.349358 },
				{ 63.992695, 49.667202, -60.323090 }
			},
			{
				{ 67.776848, 12.147257, 117.400253 },
				{ 67.822235, 12.417422, 100.957726 },
				{ 68.208496, 12.466556, 85.982124 },
				{ 68.043922, 13.257519, 70.357841 },
				{ 68.128197, 14.028598, 56.351036 },
				{ 68.018860, 14.410491, 45.080933 },
				{ 66.978432, 15.005687, 31.390064 },
				{ 64.889420, 15.128798, 18.686832 },
				{ 67.550743, 19.054811, 10.577631 },
				{ 66.542450, 21.715752, -0.385467 },
				{ 65.720207, 23.153378, -11.271565 },
				{ 65.807388, 27.077784, -20.616201 },
				{ 66.405937, 31.177004, -27.938356 },
				{ 66.940674, 33.771568, -34.773960 },
				{ 66.926270, 35.961617, -41.876949 },
				{ 66.923485, 38.251770, -48.430092 },
				{ 67.431343, 40.035831, -54.099918 }
			},
			{
				{ 71.449654, 5.113166, 122.099983 },
				{ 71.046494, 4.771172, 105.678947 },
				{ 70.518440, 4.529061, 89.079002 },
				{ 70.992912, 5.435867, 74.919266 },
				{ 70.983055, 6.509124, 60.948284 },
				{ 70.905365, 7.645839, 48.456375 },
				{ 69.228828, 7.667200, 35.280479 },
				{ 68.924095, 7.711247, 24.136127 },
				{ 70.001694, 9.841759, 15.141670 },
				{ 70.543892, 13.053610, 6.555123 },
				{ 69.304153, 14.513955, -5.103370 },
				{ 68.354637, 16.673639, -15.820370 },
				{ 69.371048, 20.329355, -22.293394 },
				{ 69.621635, 24.111851, -29.852989 },
				{ 70.150589, 27.078165, -36.758556 },
				{ 70.448792, 28.849226, -42.571087 },
				{ 71.001724, 30.057327, -47.602268 }
			},
			{
				{ 75.036118, -1.624073, 125.851448 },
				{ 75.118958, -1.705128, 111.003471 },
				{ 74.905304, -1.671213, 94.147217 },
				{ 75.292465, -1.014112, 81.452675 },
				{ 75.329445, -0.577583, 68.084015 },
				{ 73.373512, -0.135392, 52.196167 },
				{ 72.405487, 0.759259, 38.641960 },
				{ 72.109482, 1.655148, 27.688370 },
				{ 71.979301, 3.241300, 17.399471 },
				{ 72.185196, 3.538825, 10.260357 },
				{ 73.473450, 6.201486, 2.916248 },
				{ 73.144241, 8.578148, -6.982240 },
				{ 72.694122, 11.639373, -16.438938 },
				{ 73.122963, 14.045359, -23.616646 },
				{ 73.052017, 17.085407, -31.627655 },
				{ 73.681557, 19.613543, -37.316708 },
				{ 74.149292, 20.854475, -42.024258 }
			},
			{
				{ 78.280701, -7.948785, 127.728271 },
				{ 78.660477, -8.214056, 113.315193 },
				{ 78.900063, -8.135404, 98.598167 },
				{ 77.568962, -7.712784, 85.273674 },
				{ 78.904144, -7.056312, 75.103325 },
				{ 76.864716, -7.899720, 59.490894 },
				{ 76.322357, -7.248685, 46.317581 },
				{ 75.908241, -6.210074, 35.084202 },
				{ 76.737679, -4.257768, 26.825771 },
				{ 76.540543, -3.558687, 17.564074 },
				{ 76.644623, -1.226961, 8.373695 },
				{ 77.130554, -0.036326, 0.568014 },
				{ 76.265617, 2.250453, -9.473095 },
				{ 76.632080, 4.670366, -16.886034 },
				{ 76.202324, 8.025668, -26.174667 },
				{ 76.094345, 10.578829, -33.322891 },
				{ 77.006310, 11.974966, -37.412346 }
			},
			{
				{ 81.109039, -13.783945, 128.280121 },
				{ 81.187965, -14.887539, 113.845100 },
				{ 81.687813, -15.351720, 101.431610 },
				{ 80.273277, -14.422202, 87.809959 },
				{ 80.827400, -14.525190, 75.848663 },
				{ 80.265656, -15.412390, 63.422115 },
				{ 79.715004, -15.042517, 50.963032 },
				{ 79.158363, -13.721757, 39.806538 },
				{ 79.614487, -13.313353, 30.592739 },
				{ 79.000931, -11.654818, 20.881538 },
				{ 80.224823, -9.791836, 14.705762 },
				{ 79.985329, -7.819576, 5.375648 },
				{ 79.451782, -5.478598, -4.091660 },
				{ 79.393410, -3.979418, -11.962180 },
				{ 79.294830, -1.011921, -20.398760 },
				{ 79.439240, 1.562109, -27.559746 },
				{ 79.570656, 2.930991, -33.141178 }
			},
			{
				{ 83.816696, -18.978056, 128.739395 },
				{ 83.378349, -20.884031, 113.908813 },
				{ 82.938339, -22.708714, 99.677505 },
				{ 83.510445, -21.493986, 88.319832 },
				{ 82.494202, -21.904905, 76.057724 },
				{ 82.625671, -21.790504, 65.314507 },
				{ 82.534431, -21.489923, 54.542454 },
				{ 81.348389, -21.469578, 42.705540 },
				{ 81.684372, -21.171715, 33.907990 },
				{ 81.154541, -19.452320, 24.269367 },
				{ 83.390625, -17.377327, 19.985826 },
				{ 83.322563, -15.771656, 11.069608 },
				{ 82.932526, -13.542207, 2.088606 },
				{ 82.947403, -11.471736, -5.909942 },
				{ 82.061508, -9.254006, -15.449494 },
				{ 82.651657, -6.924056, -21.990507 },
				{ 82.801567, -5.169322, -27.971844 }
			},
			{
				{ 86.445183, -23.711655, 129.181763 },
				{ 86.265175, -25.368652, 115.695107 },
				{ 86.312874, -26.804962, 102.641319 },
				{ 85.554184, -29.615185, 88.262840 },
				{ 85.433655, -28.590906, 78.309662 },
				{ 85.257240, -26.981339, 68.507851 },
				{ 86.000755, -27.357851, 59.720078 },
				{ 85.416214, -27.899193, 49.087551 },
				{ 86.318398, -27.656605, 40.852581 },
				{ 85.169846, -26.713058, 30.800051 },
				{ 86.904991, -24.811754, 25.269497 },
				{ 87.660240, -22.480265, 18.159054 },
				{ 86.759575, -20.890743, 8.913417 },
				{ 87.878593, -17.999716, 3.032734 },
				{ 86.779602, -16.434050, -6.995498 },
				{ 85.673912, -15.006666, -16.482714 },
				{ 85.770248, -13.025072, -23.197727 }
			},
			{
				{ 89.048347, -28.188982, 129.615845 },
				{ 89.432159, -29.725164, 118.219452 },
				{ 90.050873, -31.459944, 107.066895 },
				{ 89.841103, -35.344761, 93.778000 },
				{ 89.401138, -33.798130, 83.932487 },
				{ 88.708931, -30.980247, 73.837990 },
				{ 88.326607, -31.701872, 63.329784 },
				{ 89.043892, -32.350544, 55.256157 },
				{ 89.413979, -32.322601, 46.165806 },
				{ 89.667953, -30.018860, 37.383106 },
				{ 89.323418, -31.259150, 27.745817 },
				{ 89.914543, -29.188772, 21.035374 },
				{ 90.592758, -26.175180, 14.516978 },
				{ 91.479393, -23.957165, 9.283149 },
				{ 92.661552, -22.000874, 2.658437 },
				{ 91.629677, -20.634771, -7.389530 },
				{ 89.868378, -19.780340, -16.458124 }
			},
			{
				{ 91.669159, -32.659683, 130.083542 },
				{ 92.562874, -34.493126, 120.366623 },
				{ 93.442719, -36.484867, 110.572624 },
				{ 93.941933, -38.962139, 100.187103 },
				{ 93.558144, -41.666553, 89.217216 },
				{ 93.002373, -44.388439, 78.667770 },
				{ 93.069420, -43.074135, 69.247093 },
				{ 93.615646, -39.792099, 61.277847 },
				{ 93.493767, -38.749821, 52.535633 },
				{ 94.564667, -36.227482, 46.108345 },
				{ 94.509247, -36.712101, 38.425930 },
				{ 94.773346, -35.641140, 30.699978 },
				{ 95.395927, -34.050320, 22.105692 },
				{ 94.833611, -32.128971, 13.451624 },
				{ 94.350334, -29.740150, 5.682088 },
				{ 95.724167, -26.806129, -0.768476 },
				{ 95.355064, -24.844921, -7.891024 }
			}
		},
		{
			{
				{ 27.925890, 79.308090, 48.903442 },
				{ 29.203428, 80.458466, 34.479736 },
				{ 31.910540, 81.458084, 21.593855 },
				{ 34.715725, 82.229721, 10.359000 },
				{ 35.686134, 83.004440, -0.658385 },
				{ 35.598576, 83.884148, -10.867059 },
				{ 35.900780, 84.991295, -19.453968 },
				{ 36.248554, 86.727341, -27.557894 },
				{ 36.318180, 89.004822, -36.100563 },
				{ 36.457024, 91.588272, -45.000423 },
				{ 36.786816, 93.899025, -53.526150 },
				{ 37.361000, 95.636711, -61.291191 },
				{ 38.001766, 97.110527, -68.571396 },
				{ 38.703629, 98.753792, -75.645050 },
				{ 39.533047, 100.748276, -82.629532 },
				{ 40.486900, 103.030701, -89.569305 },
				{ 41.502052, 105.441246, -96.491875 }
			},
			{
				{ 34.567726, 71.900719, 63.343224 },
				{ 34.639168, 72.520164, 48.076775 },
				{ 37.826382, 73.320221, 32.978508 },
				{ 39.654171, 73.979462, 18.449701 },
				{ 38.332626, 75.236099, 3.817724 },
				{ 36.705265, 76.234100, -8.174713 },
				{ 38.652306, 77.761040, -16.223284 },
				{ 39.161411, 79.868103, -24.434696 },
				{ 39.669125, 81.701744, -31.966278 },
				{ 40.755745, 83.892006, -39.849178 },
				{ 40.769119, 85.756859, -48.030422 },
				{ 41.241623, 87.223091, -55.456944 },
				{ 41.747784, 89.038925, -62.803909 },
				{ 42.466503, 91.288300, -70.028099 },
				{ 43.359386, 93.777222, -77.112221 },
				{ 44.318588, 96.352547, -84.114380 },
				{ 45.288071, 98.946968, -91.090225 }
			},
			{
				{ 42.251587, 64.332375, 78.421623 },
				{ 43.464226, 64.649139, 63.602745 },
				{ 43.301334, 65.188698, 44.135109 },
				{ 40.713177, 66.047287, 22.773685 },
				{ 40.109982, 67.609222, 7.532554 },
				{ 39.971645, 68.323387, -3.278451 },
				{ 41.644936, 71.393120, -13.428162 },
				{ 41.417736, 73.752113, -23.250820 },
				{ 43.479877, 75.132690, -29.219551 },
				{ 45.355453, 75.735413, -34.331291 },
				{ 45.140179, 76.561989, -41.515568 },
				{ 45.034294, 78.324066, -49.338943 },
				{ 45.458675, 81.040146, -57.068481 },
				{ 46.318657, 84.016365, -64.443726 },
				{ 47.256104, 86.905746, -71.603584 },
				{ 48.149994, 89.665077, -78.669182 },
				{ 49.008327, 92.360779, -85.707420 }
			},
			{
				{ 50.347969, 55.879402, 90.721298 },
				{ 52.157253, 55.570507, 76.183975 },
				{ 49.965778, 56.322620, 55.667847 },
				{ 42.242836, 56.960587, 28.274488 },
				{ 43.354847, 58.753128, 14.041889 },
				{ 43.884399, 61.501251, 2.199585 },
				{ 45.240780, 64.713615, -9.184464 },
				{ 44.064850, 66.746216, -21.268532 },
				{ 46.443279, 68.064842, -27.174875 },
				{ 48.563477, 66.726540, -29.254543 },
				{ 47.522362, 66.488136, -35.828873 },
				{ 47.899109, 69.349007, -43.756798 },
				{ 49.272419, 73.490715, -51.465603 },
				{ 50.394264, 77.074806, -58.872597 },
				{ 51.230782, 80.123833, -66.110542 },
				{ 51.931061, 82.890373, -73.252319 },
				{ 52.587154, 85.560341, -80.357140 }
			},
			{
				{ 56.951385, 47.237396, 99.929451 },
				{ 56.416367, 48.183636, 82.104195 },
				{ 55.991783, 48.774719, 65.914421 },
				{ 54.120850, 48.826126, 46.298428 },
				{ 50.551136, 51.103046, 26.703760 },
				{ 48.418377, 53.231083, 11.003249 },
				{ 47.191620, 55.550594, -2.876891 },
				{ 45.770664, 56.896042, -17.033371 },
				{ 47.483536, 58.922367, -25.072594 },
				{ 49.328236, 58.089012, -26.996264 },
				{ 50.362118, 59.127171, -32.254696 },
				{ 51.794704, 62.519375, -38.894684 },
				{ 53.587273, 66.759216, -45.975143 },
				{ 54.567078, 70.301750, -53.362835 },
				{ 55.133678, 73.247215, -60.687325 },
				{ 55.575356, 75.889885, -67.882751 },
				{ 55.992458, 78.433815, -75.018684 }
			},
			{
				{ 61.630142, 38.869549, 108.416893 },
				{ 60.953701, 39.709728, 91.549179 },
				{ 59.653954, 41.091682, 73.029076 },
				{ 60.266365, 41.496639, 57.175041 },
				{ 59.412212, 42.308556, 41.933578 },
				{ 58.507385, 44.582523, 26.967093 },
				{ 56.112556, 45.820000, 11.559952 },
				{ 53.958961, 46.739586, -3.696073 },
				{ 51.527748, 49.982086, -17.716877 },
				{ 54.589245, 51.617184, -21.988985 },
				{ 54.670631, 54.603195, -29.391401 },
				{ 56.686970, 56.777763, -33.917904 },
				{ 57.994541, 60.202393, -40.679264 },
				{ 58.549011, 63.350815, -48.095226 },
				{ 58.828041, 66.052361, -55.392029 },
				{ 59.034710, 68.510826, -62.542099 },
				{ 59.251652, 70.877602, -69.622276 }
			},
			{
				{ 64.154839, 32.054306, 113.539352 },
				{ 63.220238, 33.082504, 96.507065 },
				{ 63.614601, 33.436516, 79.537521 },
				{ 62.823299, 35.274391, 62.264683 },
				{ 63.466457, 34.896095, 48.581276 },
				{ 61.827610, 35.549309, 34.151115 },
				{ 59.575726, 36.805798, 19.665718 },
				{ 59.892750, 39.111706, 8.113769 },
				{ 58.705853, 40.995586, -4.920856 },
				{ 59.073792, 43.159851, -14.094546 },
				{ 59.907307, 47.986340, -22.744490 },
				{ 61.003212, 50.092743, -28.649052 },
				{ 61.291977, 52.854000, -36.228687 },
				{ 62.204079, 55.849667, -43.077488 },
				{ 62.342846, 58.303509, -50.115990 },
				{ 62.344116, 60.585552, -57.141445 },
				{ 62.438519, 62.785339, -64.066315 }
			},
			{
				{ 67.150696, 25.299534, 117.896156 },
				{ 67.032532, 26.156504, 101.025024 },
				{ 67.313019, 25.947983, 84.840698 },
				{ 67.536308, 26.151041, 70.205025 },
				{ 68.188629, 26.907295, 56.505600 },
				{ 67.738251, 27.755404, 43.776413 },
				{ 67.433128, 28.779659, 31.037706 },
				{ 64.632599, 30.785288, 15.016459 },
				{ 62.652363, 33.455349, 1.981467 },
				{ 62.380695, 35.891548, -8.194896 },
				{ 63.774796, 39.622448, -16.028522 },
				{ 64.245590, 43.214264, -24.028088 },
				{ 63.879425, 44.674667, -32.041027 },
				{ 65.780312, 47.390602, -37.626835 },
				{ 65.829086, 49.757179, -44.587204 },
				{ 65.608597, 51.971504, -51.572613 },
				{ 65.645401, 54.089890, -58.257072 }
			},
			{
				{ 70.235176, 18.074360, 122.390137 },
				{ 70.341660, 18.353453, 106.059914 },
				{ 70.820633, 18.486605, 90.451248 },
				{ 71.052948, 18.401011, 75.805977 },
				{ 70.312363, 18.682680, 60.704758 },
				{ 70.021629, 20.284056, 47.479591 },
				{ 67.891693, 21.167240, 32.623295 },
				{ 65.246643, 20.793428, 19.002302 },
				{ 69.407959, 24.171343, 13.542713 },
				{ 68.188240, 26.752274, 2.311311 },
				{ 66.909286, 29.071388, -9.620070 },
				{ 67.288460, 31.957817, -18.296089 },
				{ 67.859077, 36.248623, -25.798429 },
				{ 68.711212, 38.384750, -32.022015 },
				{ 69.359177, 40.629406, -38.878796 },
				{ 68.871529, 42.885078, -45.896843 },
				{ 68.931091, 44.876736, -52.170582 }
			},
			{
				{ 73.742035, 10.924883, 127.102562 },
				{ 73.792000, 10.742606, 111.013641 },
				{ 73.181595, 10.503487, 93.979492 },
				{ 73.639229, 11.137333, 79.287590 },
				{ 72.415886, 11.546495, 63.667561 },
				{ 71.559418, 12.418291, 51.396717 },
				{ 70.874130, 12.817727, 38.488544 },
				{ 69.864052, 13.415972, 25.190491 },
				{ 69.255646, 14.936735, 15.289963 },
				{ 70.093849, 18.455990, 6.176843 },
				{ 70.877113, 20.892469, -2.934625 },
				{ 70.330399, 22.695250, -12.308628 },
				{ 71.149498, 26.057365, -19.630424 },
				{ 71.309479, 29.263971, -27.323397 },
				{ 71.569496, 31.543638, -34.241127 },
				{ 71.974152, 33.870457, -40.407234 },
				{ 72.270844, 35.426170, -45.959782 }
			},
			{
				{ 77.145760, 4.125189, 130.718674 },
				{ 76.680145, 3.803329, 115.015900 },
				{ 75.634331, 3.557642, 96.422913 },
				{ 75.406433, 4.073395, 81.921562 },
				{ 74.609993, 4.102752, 67.945038 },
				{ 74.598549, 5.015407, 55.305561 },
				{ 73.839668, 6.498601, 41.716160 },
				{ 74.421738, 7.556156, 32.296730 },
				{ 74.256004, 9.062078, 21.715811 },
				{ 75.747917, 10.021764, 15.879640 },
				{ 75.957336, 11.929209, 7.172163 },
				{ 75.945007, 14.079113, -2.089643 },
				{ 74.444351, 16.961361, -13.542546 },
				{ 74.582054, 19.684536, -21.454826 },
				{ 75.028854, 22.742880, -28.637413 },
				{ 74.945602, 24.781666, -35.134159 },
				{ 75.387741, 26.108290, -40.143330 }
			},
			{
				{ 80.156059, -2.082860, 132.219208 },
				{ 79.544388, -2.559040, 116.390266 },
				{ 78.546051, -3.142647, 99.541534 },
				{ 78.128487, -3.585875, 85.620613 },
				{ 78.652191, -2.928148, 74.675064 },
				{ 79.089905, -1.202862, 64.110909 },
				{ 78.865707, -1.114442, 51.628864 },
				{ 79.042053, -0.520996, 41.433865 },
				{ 77.491119, 1.073581, 28.259165 },
				{ 78.340736, 1.240029, 21.571667 },
				{ 78.173775, 3.241282, 11.751502 },
				{ 79.363968, 5.602848, 4.302393 },
				{ 77.392487, 7.074341, -7.635738 },
				{ 77.720047, 11.185871, -15.858249 },
				{ 77.784241, 13.769923, -23.756874 },
				{ 78.045868, 16.067657, -30.187927 },
				{ 78.386063, 17.123993, -34.938210 }
			},
			{
				{ 82.795921, -7.691807, 132.405563 },
				{ 82.526527, -8.807979, 117.188271 },
				{ 83.033844, -9.544059, 104.292915 },
				{ 82.112732, -9.540751, 91.167412 },
				{ 81.631126, -10.191689, 77.322777 },
				{ 81.510849, -9.547421, 65.783401 },
				{ 80.740501, -9.658425, 53.051872 },
				{ 81.297653, -8.410630, 44.120411 },
				{ 80.602966, -7.164869, 33.513256 },
				{ 81.809608, -6.057765, 26.848551 },
				{ 81.774734, -4.055008, 17.420506 },
				{ 81.577721, -2.676889, 8.326609 },
				{ 81.555984, -0.193320, -0.479574 },
				{ 80.978859, 2.485130, -9.846404 },
				{ 81.027466, 4.789695, -17.787258 },
				{ 81.026947, 7.089911, -24.801300 },
				{ 81.216057, 8.644979, -30.323374 }
			},
			{
				{ 85.479446, -12.716874, 132.675690 },
				{ 85.120232, -14.447991, 118.080177 },
				{ 85.160126, -15.772091, 104.688248 },
				{ 85.501587, -15.895485, 93.371948 },
				{ 84.955994, -16.858603, 80.862434 },
				{ 82.801918, -17.551847, 66.073410 },
				{ 82.438988, -16.303961, 54.535744 },
				{ 84.024033, -15.294338, 47.562458 },
				{ 83.906693, -14.320156, 38.017776 },
				{ 84.547943, -13.667382, 30.911058 },
				{ 84.356361, -11.073001, 20.614401 },
				{ 84.168686, -10.170210, 11.514575 },
				{ 85.505348, -7.264184, 6.381373 },
				{ 84.928864, -5.748574, -2.289391 },
				{ 84.346077, -3.718380, -11.079125 },
				{ 84.152405, -1.077293, -19.586811 },
				{ 84.276375, 0.560696, -25.498037 }
			},
			{
				{ 88.223900, -17.428873, 132.957779 },
				{ 87.885780, -19.306015, 119.701294 },
				{ 87.256416, -21.306150, 106.378784 },
				{ 86.682976, -24.695976, 92.337090 },
				{ 87.439552, -24.782314, 81.582832 },
				{ 86.959633, -24.102861, 70.661232 },
				{ 87.136894, -23.620529, 60.566422 },
				{ 86.476082, -22.251194, 51.366814 },
				{ 88.174187, -21.494530, 44.600235 },
				{ 87.565308, -20.400558, 35.054276 },
				{ 86.821098, -18.769255, 24.379831 },
				{ 86.762909, -16.852394, 16.067953 },
				{ 87.203430, -14.714560, 8.956574 },
				{ 88.601288, -12.572814, 3.892202 },
				{ 88.438629, -11.464252, -3.730318 },
				{ 87.040749, -9.336700, -14.456283 },
				{ 87.299530, -7.420515, -20.520845 }
			},
			{
				{ 90.914017, -22.178473, 133.023880 },
				{ 90.987846, -24.121855, 121.763458 },
				{ 90.967148, -26.308052, 111.087975 },
				{ 90.516701, -31.575163, 96.547729 },
				{ 90.006523, -31.967581, 84.925987 },
				{ 90.216850, -28.793781, 75.692444 },
				{ 90.309799, -27.703766, 66.188034 },
				{ 89.975746, -26.361549, 56.743351 },
				{ 91.056183, -25.045124, 49.219528 },
				{ 90.131516, -26.025410, 38.093521 },
				{ 88.203865, -25.964912, 25.525908 },
				{ 88.823914, -23.626913, 18.967491 },
				{ 90.397781, -22.186487, 13.124538 },
				{ 90.304344, -19.959538, 6.126504 },
				{ 91.150581, -18.535589, -0.404581 },
				{ 91.687454, -16.363934, -7.204952 },
				{ 91.339394, -14.423957, -13.844597 }
			},
			{
				{ 93.612740, -27.011936, 133.183456 },
				{ 94.092293, -29.447321, 122.862801 },
				{ 94.417320, -32.333569, 112.049545 },
				{ 94.461128, -36.311378, 99.897285 },
				{ 93.792290, -40.031467, 88.274513 },
				{ 94.136665, -38.605949, 79.925728 },
				{ 94.751633, -36.634022, 72.659912 },
				{ 94.687180, -34.827419, 63.346638 },
				{ 94.529716, -33.404095, 53.671299 },
				{ 94.148216, -34.426041, 44.152557 },
				{ 94.177818, -32.919258, 36.708885 },
				{ 95.778465, -30.315229, 31.499483 },
				{ 95.812202, -29.688925, 21.998251 },
				{ 93.705482, -28.107695, 10.493930 },
				{ 94.879929, -25.341000, 5.124275 },
				{ 96.995857, -21.754984, 0.952446 },
				{ 95.850311, -20.442719, -6.572329 }
			}
		},
		{
			{
				{ 30.062647, 84.432045, 52.523933 },
				{ 32.664944, 84.797958, 40.100929 },
				{ 35.640671, 85.169151, 28.349367 },
				{ 38.228966, 85.581726, 17.144398 },
				{ 39.327961, 86.155060, 5.943547 },
				{ 39.495590, 86.838638, -4.254900 },
				{ 39.881653, 87.749939, -12.975139 },
				{ 40.298439, 89.298943, -21.401516 },
				{ 40.691196, 91.420662, -30.101168 },
				{ 41.190166, 93.930290, -39.121342 },
				{ 41.551823, 96.378235, -48.122128 },
				{ 41.705997, 98.486511, -56.767052 },
				{ 41.735985, 100.368217, -65.024017 },
				{ 41.787067, 102.289200, -72.991196 },
				{ 41.973633, 104.406395, -80.756729 },
				{ 42.302834, 106.712776, -88.399834 },
				{ 42.704887, 109.111031, -95.993927 }
			},
			{
				{ 37.014954, 77.254074, 66.731651 },
				{ 38.173992, 77.440254, 51.988430 },
				{ 40.463032, 77.397926, 38.011532 },
				{ 42.189823, 77.502495, 24.376709 },
				{ 41.494709, 78.688354, 9.936312 },
				{ 41.546108, 79.613312, -0.524954 },
				{ 43.175411, 80.660530, -8.115521 },
				{ 43.596088, 82.680016, -17.464235 },
				{ 43.800518, 84.695229, -26.447718 },
				{ 44.597607, 86.894341, -35.127346 },
				{ 45.016876, 88.800232, -43.470089 },
				{ 45.000565, 90.674080, -51.721046 },
				{ 44.975060, 92.747284, -59.813683 },
				{ 45.190628, 95.055016, -67.648788 },
				{ 45.605576, 97.516335, -75.265892 },
				{ 46.113930, 100.044769, -82.759811 },
				{ 46.647888, 102.590897, -90.210983 }
			},
			{
				{ 44.113281, 69.912682, 80.218071 },
				{ 44.227108, 70.203011, 63.735264 },
				{ 45.068237, 69.801285, 47.125984 },
				{ 44.034664, 69.826683, 29.469381 },
				{ 42.376896, 71.291138, 14.032463 },
				{ 44.375935, 72.449181, 4.123113 },
				{ 45.816673, 74.517998, -5.148723 },
				{ 46.430336, 76.604317, -15.073074 },
				{ 47.147057, 78.542389, -23.852039 },
				{ 47.592468, 79.932938, -31.692564 },
				{ 48.044788, 81.003006, -38.927750 },
				{ 48.079979, 82.740807, -46.709789 },
				{ 48.178967, 85.173508, -54.634434 },
				{ 48.676617, 87.909279, -62.286797 },
				{ 49.308887, 90.666695, -69.744118 },
				{ 49.931744, 93.352577, -77.112228 },
				{ 50.528851, 95.990234, -84.453575 }
			},
			{
				{ 51.987366, 61.445313, 92.514488 },
				{ 51.966850, 61.807220, 75.767014 },
				{ 51.817474, 61.729782, 58.143692 },
				{ 46.734970, 62.593884, 34.955608 },
				{ 46.462597, 63.547844, 20.466396 },
				{ 48.013569, 65.440208, 9.149424 },
				{ 48.345840, 67.886566, -2.236615 },
				{ 48.232410, 69.779495, -13.228966 },
				{ 49.696915, 72.066269, -21.642015 },
				{ 49.063019, 72.892822, -29.339310 },
				{ 48.520290, 73.418976, -36.023170 },
				{ 50.229313, 75.042839, -42.403851 },
				{ 51.420650, 77.841965, -49.534935 },
				{ 52.369843, 80.914261, -56.836124 },
				{ 53.119881, 83.829094, -64.152794 },
				{ 53.723740, 86.553917, -71.457458 },
				{ 54.265450, 89.189407, -78.751343 }
			},
			{
				{ 58.372208, 52.916885, 102.434624 },
				{ 57.141422, 53.893887, 84.531067 },
				{ 56.489048, 54.457977, 67.382469 },
				{ 55.635651, 54.739227, 48.742992 },
				{ 53.559769, 56.029797, 30.794041 },
				{ 50.758484, 57.592384, 15.481993 },
				{ 49.497475, 59.254066, 1.597943 },
				{ 47.479984, 60.652683, -11.722110 },
				{ 52.329891, 63.772064, -18.110826 },
				{ 50.338436, 65.457062, -27.419579 },
				{ 51.550781, 66.393021, -32.636013 },
				{ 53.222507, 68.016922, -38.137955 },
				{ 55.038078, 70.910713, -44.346100 },
				{ 56.252499, 74.005814, -51.263390 },
				{ 56.959621, 76.868797, -58.504436 },
				{ 57.417423, 79.514145, -65.812050 },
				{ 57.801723, 82.068298, -73.111809 }
			},
			{
				{ 62.847313, 44.773815, 110.771576 },
				{ 61.979084, 45.394783, 92.851089 },
				{ 61.945534, 45.896812, 76.309311 },
				{ 62.379761, 46.499554, 59.811699 },
				{ 59.740231, 48.000294, 42.741058 },
				{ 61.457558, 49.529987, 31.766737 },
				{ 57.634727, 50.757854, 14.304282 },
				{ 54.789043, 51.760235, -0.896434 },
				{ 53.905933, 53.362041, -12.376724 },
				{ 54.483845, 55.926140, -22.198902 },
				{ 56.511005, 59.037716, -28.308182 },
				{ 57.490295, 61.341213, -33.137337 },
				{ 59.255814, 64.130692, -38.725319 },
				{ 60.268372, 66.952667, -45.569527 },
				{ 60.722000, 69.595016, -52.852894 },
				{ 60.953377, 72.091835, -60.188690 },
				{ 61.137280, 74.534355, -67.501099 }
			},
			{
				{ 66.138725, 37.464993, 117.381683 },
				{ 65.243523, 37.695702, 98.954857 },
				{ 64.171837, 38.231911, 80.345070 },
				{ 63.217529, 39.834827, 62.740192 },
				{ 62.837982, 40.344219, 49.090893 },
				{ 64.851616, 40.082024, 39.442261 },
				{ 62.297672, 41.638229, 23.687323 },
				{ 61.564934, 45.088234, 10.077301 },
				{ 59.022148, 45.121761, -3.661938 },
				{ 58.738789, 46.257786, -14.181799 },
				{ 59.341442, 49.342136, -22.184439 },
				{ 62.175011, 54.271542, -27.181250 },
				{ 63.570698, 56.864212, -32.838421 },
				{ 64.207245, 59.421150, -39.905994 },
				{ 64.330566, 61.842182, -47.247444 },
				{ 64.330872, 64.199554, -54.573246 },
				{ 64.329971, 66.544792, -61.849319 }
			},
			{
				{ 69.401642, 30.538509, 123.017502 },
				{ 69.492424, 30.979706, 105.245941 },
				{ 68.189369, 31.118032, 86.414505 },
				{ 69.184273, 31.609581, 72.666695 },
				{ 70.385315, 32.383305, 60.607090 },
				{ 69.423592, 33.036758, 47.017960 },
				{ 68.411240, 34.021759, 32.649281 },
				{ 64.124710, 35.764488, 15.175400 },
				{ 63.711681, 37.682220, 4.083631 },
				{ 64.180435, 39.365204, -4.904817 },
				{ 64.424370, 42.716640, -14.671511 },
				{ 65.967003, 47.321777, -21.648548 },
				{ 66.363167, 48.722984, -28.329966 },
				{ 67.491341, 51.217468, -34.699535 },
				{ 67.669350, 53.604210, -41.788265 },
				{ 67.561737, 55.882404, -48.983955 },
				{ 67.460289, 58.122322, -56.085236 }
			},
			{
				{ 72.666206, 23.506348, 127.969658 },
				{ 72.499031, 23.694738, 110.394646 },
				{ 72.219543, 23.856808, 93.481987 },
				{ 73.733620, 24.045805, 80.152512 },
				{ 72.172867, 24.654125, 64.011681 },
				{ 71.603493, 26.105276, 50.423004 },
				{ 69.060616, 27.433615, 34.028385 },
				{ 66.999619, 27.950535, 19.659721 },
				{ 69.871857, 29.991777, 14.137149 },
				{ 69.225342, 31.534288, 4.003752 },
				{ 68.475647, 33.421654, -6.329688 },
				{ 69.045845, 37.985115, -15.505653 },
				{ 69.219803, 40.962059, -23.801281 },
				{ 70.109955, 42.600662, -29.814686 },
				{ 70.537300, 45.194122, -36.792152 },
				{ 70.576035, 47.328491, -43.547134 },
				{ 70.570564, 49.341969, -50.183498 }
			},
			{
				{ 76.034378, 16.455753, 132.191177 },
				{ 74.963989, 15.971539, 113.700661 },
				{ 73.770332, 15.570451, 95.573158 },
				{ 75.721092, 16.734188, 83.030128 },
				{ 73.848534, 17.323000, 66.359161 },
				{ 75.164360, 18.562658, 55.770039 },
				{ 72.201439, 19.233038, 39.131817 },
				{ 71.012131, 20.621521, 26.174261 },
				{ 73.251305, 21.377895, 20.821779 },
				{ 72.181671, 23.544018, 9.136081 },
				{ 72.701584, 25.145643, 0.726014 },
				{ 72.238213, 27.840338, -8.766940 },
				{ 72.806915, 31.516449, -17.023329 },
				{ 73.148178, 34.819153, -24.848103 },
				{ 73.321671, 36.954155, -31.954693 },
				{ 73.406395, 38.676712, -38.226715 },
				{ 73.637184, 40.292950, -44.212864 }
			},
			{
				{ 79.198326, 9.694394, 135.037445 },
				{ 78.236244, 9.085491, 117.299797 },
				{ 77.665901, 9.020238, 100.514870 },
				{ 77.998024, 9.833652, 86.991806 },
				{ 77.919838, 10.551506, 73.555573 },
				{ 77.839867, 11.626030, 61.067780 },
				{ 76.998947, 12.439543, 47.104988 },
				{ 76.925957, 13.138169, 36.132477 },
				{ 77.308258, 14.216971, 27.014124 },
				{ 76.634369, 15.981724, 16.370623 },
				{ 77.496475, 17.401417, 9.024132 },
				{ 77.163933, 19.369453, 0.110649 },
				{ 75.856285, 20.963354, -10.883494 },
				{ 76.368965, 24.817347, -18.547047 },
				{ 76.735291, 28.435942, -26.247158 },
				{ 76.276749, 29.969870, -32.936432 },
				{ 76.678818, 31.075520, -38.273643 }
			},
			{
				{ 82.088341, 3.558457, 136.514145 },
				{ 81.302673, 2.933882, 119.797455 },
				{ 80.439568, 2.566452, 103.665398 },
				{ 80.559807, 2.632506, 90.388863 },
				{ 80.264671, 2.346449, 76.273941 },
				{ 80.334221, 4.041986, 65.088249 },
				{ 79.966057, 5.235857, 52.970341 },
				{ 80.052971, 6.201694, 42.086578 },
				{ 79.270393, 6.100523, 31.913315 },
				{ 78.293396, 8.381777, 19.108316 },
				{ 78.503494, 9.977179, 10.880462 },
				{ 79.327667, 11.715846, 4.225945 },
				{ 79.157219, 12.919312, -5.064711 },
				{ 79.366280, 16.214785, -13.163797 },
				{ 79.305412, 18.619688, -21.325979 },
				{ 79.222168, 20.352642, -27.813866 },
				{ 79.955482, 21.951214, -32.356461 }
			},
			{
				{ 84.715843, -1.935343, 137.025513 },
				{ 83.847771, -3.158774, 120.574257 },
				{ 82.807114, -4.632569, 103.628708 },
				{ 82.466599, -4.957335, 90.215790 },
				{ 82.200211, -5.485223, 78.705925 },
				{ 82.835716, -4.364386, 67.821480 },
				{ 82.448936, -3.608069, 56.505856 },
				{ 82.870407, -1.895870, 47.232300 },
				{ 83.255730, -3.596864, 41.490356 },
				{ 82.944038, -0.337902, 28.495604 },
				{ 82.170525, 2.132328, 17.422829 },
				{ 82.498131, 3.903182, 9.823831 },
				{ 83.205750, 5.981963, 2.116350 },
				{ 83.000473, 7.805793, -6.347284 },
				{ 82.484322, 10.249771, -15.350457 },
				{ 82.607185, 12.509711, -22.362326 },
				{ 82.867043, 13.869382, -27.465961 }
			},
			{
				{ 87.265709, -7.021381, 137.019272 },
				{ 86.571091, -8.756639, 121.762779 },
				{ 86.016624, -11.127107, 105.651390 },
				{ 85.773270, -14.610926, 90.807381 },
				{ 85.972763, -14.253723, 81.995125 },
				{ 85.631912, -12.455323, 71.931900 },
				{ 85.646408, -10.097755, 61.720261 },
				{ 84.625557, -9.676972, 49.565548 },
				{ 85.973305, -8.875876, 42.796188 },
				{ 86.442299, -8.237524, 34.432564 },
				{ 85.676994, -6.079780, 23.796209 },
				{ 86.537430, -4.479478, 17.093664 },
				{ 86.444969, -2.597003, 8.582292 },
				{ 86.642136, -0.474022, 0.613404 },
				{ 86.278366, 1.961852, -7.817488 },
				{ 86.206345, 4.297342, -15.920435 },
				{ 85.853142, 5.817212, -22.666578 }
			},
			{
				{ 89.906700, -12.056197, 136.670975 },
				{ 89.377197, -14.735887, 122.334290 },
				{ 88.747719, -18.855162, 106.727356 },
				{ 88.389610, -25.031736, 90.973946 },
				{ 88.373116, -24.778078, 81.277679 },
				{ 88.492867, -22.438169, 72.739212 },
				{ 87.370140, -18.040453, 61.754314 },
				{ 87.429222, -16.022633, 52.177723 },
				{ 88.662895, -14.996266, 46.064396 },
				{ 88.743454, -14.378586, 37.434925 },
				{ 89.248116, -12.922210, 29.666935 },
				{ 89.532310, -11.082338, 21.877398 },
				{ 88.591331, -9.159850, 11.348819 },
				{ 89.247597, -7.861586, 5.739451 },
				{ 89.669098, -6.138183, -1.726242 },
				{ 88.687157, -3.465939, -11.853051 },
				{ 89.081711, -1.993769, -17.302700 }
			},
			{
				{ 92.581085, -17.461937, 135.949326 },
				{ 92.322060, -20.520540, 123.112122 },
				{ 91.937027, -24.303690, 109.793411 },
				{ 91.674843, -28.991726, 95.451920 },
				{ 91.296295, -28.803314, 85.234612 },
				{ 92.032387, -27.946814, 77.341309 },
				{ 92.279816, -27.803844, 68.236702 },
				{ 91.196007, -26.685093, 57.929508 },
				{ 91.690643, -21.968130, 49.653580 },
				{ 92.115837, -21.694038, 40.835743 },
				{ 92.342834, -19.181198, 34.075752 },
				{ 92.679848, -17.403208, 26.572742 },
				{ 90.716606, -17.017084, 13.773561 },
				{ 91.901703, -14.531446, 8.486763 },
				{ 92.373314, -13.351661, 0.570496 },
				{ 92.382584, -11.884997, -7.231421 },
				{ 92.484436, -9.365681, -11.534941 }
			},
			{
				{ 95.274139, -23.086273, 135.186493 },
				{ 95.335960, -26.271584, 123.435730 },
				{ 95.279037, -29.492870, 111.243538 },
				{ 95.012619, -32.680870, 98.891075 },
				{ 94.701866, -35.057613, 88.707146 },
				{ 95.184288, -33.185085, 81.024986 },
				{ 95.928596, -33.758579, 73.647537 },
				{ 95.270355, -35.142658, 63.783787 },
				{ 95.254234, -31.214428, 53.913357 },
				{ 95.991692, -30.543467, 45.276081 },
				{ 96.183296, -27.322306, 38.461346 },
				{ 96.939697, -24.580149, 34.133701 },
				{ 96.169060, -24.358864, 23.880737 },
				{ 94.909813, -21.703121, 12.793077 },
				{ 95.849594, -19.080359, 6.366665 },
				{ 96.667183, -17.750521, 0.700279 },
				{ 96.828316, -15.439892, -5.042284 }
			}
		},
		{
			{
				{ 32.579304, 89.552208, 56.035770 },
				{ 35.426388, 89.488846, 44.574711 },
				{ 38.177250, 89.473007, 33.356766 },
				{ 40.526928, 89.613411, 22.358313 },
				{ 42.051685, 90.010017, 11.521840 },
				{ 42.994728, 90.544472, 1.527666 },
				{ 43.812145, 91.325844, -7.546438 },
				{ 44.625137, 92.566719, -16.199070 },
				{ 45.487404, 94.272568, -24.758690 },
				{ 46.207878, 96.416031, -33.624264 },
				{ 46.495056, 98.810326, -42.848858 },
				{ 46.253342, 101.219788, -52.182831 },
				{ 45.690262, 103.549156, -61.359009 },
				{ 45.073734, 105.843269, -70.252388 },
				{ 44.568924, 108.177238, -78.869888 },
				{ 44.202412, 110.577301, -87.297653 },
				{ 43.910271, 113.016777, -95.645515 }
			},
			{
				{ 39.791721, 81.999588, 70.136841 },
				{ 40.376461, 82.292046, 54.669304 },
				{ 41.579372, 82.324707, 40.356228 },
				{ 43.400711, 82.215004, 27.938007 },
				{ 44.010365, 82.949562, 15.663681 },
				{ 45.534691, 83.741982, 5.904171 },
				{ 47.577629, 84.687019, -2.298124 },
				{ 48.726421, 86.230713, -11.326203 },
				{ 49.005123, 88.187431, -21.036921 },
				{ 49.131802, 90.255249, -30.504982 },
				{ 49.034534, 92.282715, -39.549141 },
				{ 48.677975, 94.368233, -48.372711 },
				{ 48.298065, 96.573677, -56.978733 },
				{ 48.058292, 98.904137, -65.328445 },
				{ 47.970016, 101.324181, -73.454926 },
				{ 47.974495, 103.788025, -81.443489 },
				{ 48.012451, 106.264458, -89.380028 }
			},
			{
				{ 46.357113, 74.486656, 82.783615 },
				{ 44.851826, 75.294678, 63.913174 },
				{ 44.534809, 75.625259, 46.439545 },
				{ 45.277760, 75.529007, 32.009739 },
				{ 45.585472, 75.959183, 19.786049 },
				{ 48.196884, 76.969795, 10.366276 },
				{ 51.602627, 78.127975, 3.045268 },
				{ 53.411415, 79.745216, -5.807544 },
				{ 52.702690, 82.272781, -17.456924 },
				{ 51.764492, 84.401932, -27.951704 },
				{ 51.076641, 85.923439, -36.691296 },
				{ 50.852627, 87.565132, -44.729214 },
				{ 50.894878, 89.605110, -52.587360 },
				{ 51.127392, 91.966042, -60.329063 },
				{ 51.441582, 94.460281, -67.975822 },
				{ 51.756729, 96.965965, -75.572502 },
				{ 52.055618, 99.455177, -83.154724 }
			},
			{
				{ 53.245369, 66.310692, 94.718002 },
				{ 50.714935, 67.724205, 74.571732 },
				{ 49.516506, 68.643173, 55.047947 },
				{ 48.299770, 69.324226, 36.869804 },
				{ 48.814289, 68.692451, 24.756687 },
				{ 51.266933, 70.192543, 14.602763 },
				{ 53.653934, 71.905312, 6.199538 },
				{ 56.588688, 73.192177, -1.206575 },
				{ 56.040733, 76.142876, -13.917078 },
				{ 53.461624, 78.635628, -26.023994 },
				{ 52.362492, 79.678902, -34.368576 },
				{ 52.810104, 80.815926, -41.240116 },
				{ 53.620644, 82.662041, -48.080772 },
				{ 54.402969, 85.026329, -55.138546 },
				{ 55.037426, 87.544670, -62.362907 },
				{ 55.529099, 90.040016, -69.678978 },
				{ 55.952396, 92.497726, -77.027016 }
			},
			{
				{ 59.253834, 57.879299, 105.147926 },
				{ 58.367641, 58.570015, 87.155609 },
				{ 58.629440, 58.853966, 70.186478 },
				{ 57.144020, 60.200245, 50.775890 },
				{ 54.455845, 60.977272, 33.334293 },
				{ 54.430000, 62.250702, 20.820799 },
				{ 54.072132, 64.697609, 9.045743 },
				{ 56.141777, 65.631523, 1.702120 },
				{ 57.741558, 68.761337, -10.679706 },
				{ 54.849548, 71.704491, -23.514170 },
				{ 54.415947, 72.837334, -31.320635 },
				{ 55.389168, 73.910934, -37.276497 },
				{ 56.789886, 75.739998, -43.194328 },
				{ 57.966259, 78.052635, -49.650948 },
				{ 58.734455, 80.491203, -56.597923 },
				{ 59.229332, 82.909370, -63.788620 },
				{ 59.626213, 85.297943, -71.045586 }
			},
			{
				{ 64.135864, 49.961254, 113.891243 },
				{ 64.549583, 49.882751, 96.357079 },
				{ 65.922058, 50.007530, 81.885422 },
				{ 64.737732, 51.544022, 62.803650 },
				{ 59.504047, 53.171295, 42.527969 },
				{ 62.108788, 54.209068, 33.486950 },
				{ 58.471584, 56.612579, 17.069542 },
				{ 57.772217, 58.389759, 4.162331 },
				{ 57.138126, 59.259655, -7.967973 },
				{ 56.891857, 61.750099, -18.768013 },
				{ 57.493011, 64.576828, -26.823381 },
				{ 58.910542, 66.703209, -32.361481 },
				{ 60.631092, 68.769485, -37.637394 },
				{ 61.813583, 70.906494, -43.818306 },
				{ 62.431496, 73.167831, -50.744232 },
				{ 62.779087, 75.477631, -57.955513 },
				{ 63.049423, 77.793388, -65.221115 }
			},
			{
				{ 67.860489, 42.351601, 121.351509 },
				{ 67.808273, 42.401276, 102.136864 },
				{ 67.700676, 42.844772, 85.176491 },
				{ 64.982315, 44.563274, 66.532555 },
				{ 63.940571, 45.563782, 51.317612 },
				{ 69.634949, 44.833385, 45.544712 },
				{ 64.379768, 46.989311, 27.359346 },
				{ 64.340187, 50.281986, 14.239681 },
				{ 60.686932, 50.615723, -0.793160 },
				{ 59.118370, 51.289707, -12.750944 },
				{ 60.151875, 54.667927, -21.152220 },
				{ 62.974445, 59.324078, -26.508749 },
				{ 64.941414, 61.458122, -31.399519 },
				{ 65.654739, 63.328026, -37.844456 },
				{ 65.953056, 65.469345, -44.969406 },
				{ 66.128708, 67.710136, -52.236561 },
				{ 66.258591, 69.971626, -59.509041 }
			},
			{
				{ 71.132408, 35.265224, 127.874184 },
				{ 71.452782, 35.610317, 109.642303 },
				{ 71.213280, 35.971931, 91.729729 },
				{ 71.304672, 36.794064, 76.068268 },
				{ 72.159264, 37.851089, 63.416775 },
				{ 72.978867, 38.019432, 52.147556 },
				{ 69.936096, 39.452358, 35.329716 },
				{ 68.305885, 41.082378, 21.406406 },
				{ 66.124199, 42.974403, 7.612558 },
				{ 65.072540, 44.750431, -3.971272 },
				{ 64.692986, 46.350502, -13.690434 },
				{ 67.104607, 51.879387, -19.958780 },
				{ 68.721077, 53.112873, -25.166355 },
				{ 68.852692, 55.233994, -32.338444 },
				{ 69.156647, 57.449581, -39.470997 },
				{ 69.278534, 59.661518, -46.662884 },
				{ 69.321243, 61.853458, -53.825951 }
			},
			{
				{ 74.976860, 28.513649, 133.665955 },
				{ 75.497253, 28.917431, 116.493996 },
				{ 75.439560, 29.200321, 99.257927 },
				{ 75.382385, 29.841337, 82.363174 },
				{ 73.432076, 30.704262, 65.799438 },
				{ 72.507729, 31.784481, 52.519035 },
				{ 72.154968, 32.818520, 38.413570 },
				{ 68.619560, 33.692905, 22.196930 },
				{ 68.927963, 35.485455, 12.453566 },
				{ 69.334747, 37.334740, 3.786029 },
				{ 71.432297, 39.266438, -1.881215 },
				{ 70.719292, 43.006783, -12.993345 },
				{ 71.291573, 45.759659, -20.641867 },
				{ 71.374146, 47.370323, -27.712275 },
				{ 72.154510, 49.288864, -34.250153 },
				{ 72.238136, 51.424931, -41.234795 },
				{ 72.292694, 53.461544, -48.086651 }
			},
			{
				{ 78.458221, 21.743614, 137.742493 },
				{ 78.312675, 21.873280, 120.258354 },
				{ 78.131905, 22.111078, 102.771210 },
				{ 77.291786, 22.701187, 85.382584 },
				{ 76.041672, 23.030130, 69.353569 },
				{ 77.041389, 24.020767, 58.682995 },
				{ 74.322052, 25.017729, 42.942280 },
				{ 75.048561, 26.172079, 32.791111 },
				{ 75.252449, 27.050873, 23.396910 },
				{ 74.061234, 28.983372, 11.782925 },
				{ 72.878670, 30.510792, 1.162015 },
				{ 73.659973, 32.970078, -6.723539 },
				{ 74.349747, 36.286827, -14.640405 },
				{ 74.590408, 39.351120, -22.521017 },
				{ 74.740067, 41.377102, -29.597559 },
				{ 75.050972, 43.148682, -35.886566 },
				{ 75.254211, 44.830231, -42.217159 }
			},
			{
				{ 81.438133, 15.193307, 139.907394 },
				{ 80.860657, 15.301330, 122.486244 },
				{ 80.201485, 15.483819, 105.647530 },
				{ 79.826096, 15.840078, 89.991333 },
				{ 80.522247, 16.203064, 76.675751 },
				{ 80.447594, 17.060053, 64.939041 },
				{ 77.929634, 17.963978, 49.399979 },
				{ 77.110405, 18.884802, 36.728634 },
				{ 76.141884, 20.118477, 25.156723 },
				{ 77.520287, 21.450893, 17.638306 },
				{ 77.182770, 23.316341, 8.283276 },
				{ 78.049522, 24.638170, 1.263085 },
				{ 76.833275, 26.657694, -9.190142 },
				{ 77.841377, 29.831444, -16.210226 },
				{ 77.821213, 32.858673, -24.367830 },
				{ 78.195328, 34.787003, -30.151512 },
				{ 78.298721, 36.089943, -36.253155 }
			},
			{
				{ 84.146278, 9.011322, 141.077927 },
				{ 83.438362, 8.644821, 124.894859 },
				{ 82.921921, 8.583144, 108.954826 },
				{ 82.867569, 9.129299, 94.435356 },
				{ 82.002335, 8.925883, 79.091637 },
				{ 81.270660, 9.194602, 66.832794 },
				{ 81.306358, 10.923456, 53.878719 },
				{ 79.483047, 11.711132, 39.859737 },
				{ 80.204422, 12.609529, 31.159622 },
				{ 80.755371, 14.056147, 22.743826 },
				{ 80.041603, 15.180361, 13.116800 },
				{ 80.796547, 17.088343, 5.824527 },
				{ 80.672966, 18.911036, -2.796141 },
				{ 80.961632, 21.169455, -10.363100 },
				{ 81.196732, 23.824848, -18.229797 },
				{ 81.121803, 26.033592, -24.813824 },
				{ 81.446548, 27.441526, -30.395037 }
			},
			{
				{ 86.687035, 3.269228, 141.373108 },
				{ 85.926697, 2.360647, 125.766495 },
				{ 85.039597, 1.361880, 109.645866 },
				{ 83.970863, 1.324487, 94.181145 },
				{ 84.106270, 2.075510, 83.068924 },
				{ 85.064339, 3.132785, 72.971550 },
				{ 83.951927, 3.090848, 58.405323 },
				{ 83.776535, 4.250571, 47.738003 },
				{ 84.283272, 5.469511, 39.028294 },
				{ 83.949265, 6.361766, 29.421879 },
				{ 85.867096, 8.004305, 23.653601 },
				{ 84.842049, 9.778213, 12.690528 },
				{ 84.579109, 11.553860, 4.275308 },
				{ 84.340996, 13.159204, -4.194589 },
				{ 84.230476, 15.453726, -12.515244 },
				{ 84.381966, 17.691807, -19.253601 },
				{ 84.499519, 19.232872, -24.956514 }
			},
			{
				{ 89.069206, -2.316162, 140.739471 },
				{ 88.424088, -3.819083, 125.982506 },
				{ 87.953911, -5.445848, 111.245071 },
				{ 86.746704, -8.363253, 94.733032 },
				{ 87.367737, -6.371851, 86.385323 },
				{ 87.542747, -4.472991, 76.797226 },
				{ 86.810097, -3.613122, 64.083313 },
				{ 87.292191, -3.653660, 54.115067 },
				{ 87.404541, -1.388531, 44.884388 },
				{ 87.015617, -0.610703, 34.620388 },
				{ 87.942299, 1.016125, 27.437696 },
				{ 87.174408, 2.336501, 17.330320 },
				{ 88.931938, 3.619892, 12.261378 },
				{ 88.654373, 4.783853, 4.047585 },
				{ 87.382591, 7.395928, -6.722178 },
				{ 87.479149, 9.678512, -13.975009 },
				{ 87.261208, 11.077826, -20.242617 }
			},
			{
				{ 91.505638, -8.029830, 139.521927 },
				{ 90.976616, -10.822413, 124.865891 },
				{ 90.627319, -14.175793, 109.899406 },
				{ 90.599777, -17.207226, 95.879486 },
				{ 89.611534, -18.573246, 83.649498 },
				{ 90.259552, -17.102844, 75.486176 },
				{ 88.968605, -12.109780, 64.372108 },
				{ 89.152969, -9.820655, 55.759209 },
				{ 89.765175, -8.771997, 47.743279 },
				{ 89.586777, -7.973629, 38.371342 },
				{ 90.146172, -6.470567, 31.663570 },
				{ 90.726753, -4.890988, 23.835268 },
				{ 89.976585, -3.259384, 13.689215 },
				{ 91.052086, -2.659057, 9.253434 },
				{ 91.117950, -0.305192, 0.583791 },
				{ 90.593323, 2.025963, -8.462281 },
				{ 90.725433, 3.225935, -14.874564 }
			},
			{
				{ 94.034470, -14.197973, 137.794342 },
				{ 93.703308, -17.563051, 124.001579 },
				{ 93.514595, -20.938421, 110.260353 },
				{ 93.281090, -23.768316, 96.612526 },
				{ 92.085487, -25.459448, 83.528046 },
				{ 92.588814, -26.155840, 75.529434 },
				{ 93.205589, -24.154205, 68.194206 },
				{ 92.279762, -19.850941, 59.609745 },
				{ 92.073814, -19.919588, 49.099873 },
				{ 92.849075, -19.391876, 40.599472 },
				{ 93.540695, -14.644145, 35.547894 },
				{ 94.358040, -11.510344, 30.220623 },
				{ 92.910965, -10.883237, 17.769566 },
				{ 93.279633, -9.133171, 10.688870 },
				{ 94.101868, -7.660027, 5.360925 },
				{ 93.675758, -6.084884, -3.506273 },
				{ 93.594910, -4.058439, -9.923721 }
			},
			{
				{ 96.629280, -20.626291, 135.871109 },
				{ 96.460548, -24.128927, 123.072029 },
				{ 96.190208, -27.369205, 110.247131 },
				{ 95.731071, -29.838331, 97.924370 },
				{ 95.336586, -30.894073, 87.467644 },
				{ 95.514534, -30.875423, 79.235672 },
				{ 96.139565, -31.637053, 72.245995 },
				{ 95.865288, -30.983143, 63.391613 },
				{ 95.285339, -27.824547, 53.753719 },
				{ 95.713013, -26.042336, 43.280968 },
				{ 96.218536, -22.050125, 36.068275 },
				{ 96.677719, -19.320829, 33.062695 },
				{ 96.577843, -19.182669, 24.935883 },
				{ 97.263222, -16.929379, 16.798399 },
				{ 97.107239, -14.513421, 9.530219 },
				{ 97.419983, -12.642540, 3.178150 },
				{ 98.321411, -9.744149, -2.772919 }
			}
		},
		{
			{
				{ 34.774040, 94.723923, 58.604267 },
				{ 37.205898, 94.593025, 47.476303 },
				{ 39.552464, 94.478806, 36.543777 },
				{ 41.848934, 94.450706, 25.972393 },
				{ 44.050800, 94.573105, 15.871240 },
				{ 46.060791, 94.842377, 6.362512 },
				{ 47.826153, 95.331009, -2.601663 },
				{ 49.377163, 96.153526, -11.172142 },
				{ 50.651379, 97.418617, -19.655272 },
				{ 51.392197, 99.191483, -28.528372 },
				{ 51.444805, 101.451302, -37.960087 },
				{ 50.797489, 104.031616, -47.800747 },
				{ 49.695454, 106.719574, -57.726261 },
				{ 48.445858, 109.379364, -67.474998 },
				{ 47.248329, 111.975273, -76.952904 },
				{ 46.158257, 114.526321, -86.210640 },
				{ 45.132412, 117.060753, -95.367371 }
			},
			{
				{ 41.707844, 86.752197, 72.119400 },
				{ 41.784504, 87.231438, 56.637932 },
				{ 42.455906, 87.588112, 42.267712 },
				{ 43.907562, 87.832092, 29.807781 },
				{ 45.758553, 88.202034, 19.094311 },
				{ 48.249012, 88.662163, 10.102296 },
				{ 50.866096, 89.299133, 1.907016 },
				{ 52.804218, 90.295464, -6.713494 },
				{ 53.652592, 91.743217, -16.171844 },
				{ 53.734554, 93.628410, -25.920345 },
				{ 53.240753, 95.816353, -35.617340 },
				{ 52.488861, 98.115906, -45.067139 },
				{ 51.705261, 100.447639, -54.210384 },
				{ 50.999165, 102.799667, -63.059597 },
				{ 50.397972, 105.171356, -71.674522 },
				{ 49.875668, 107.556068, -80.145790 },
				{ 49.387211, 109.945694, -88.562080 }
			},
			{
				{ 48.487885, 78.751549, 85.248703 },
				{ 46.063820, 79.833015, 65.642075 },
				{ 45.472977, 80.742889, 47.982666 },
				{ 46.181259, 81.351128, 33.512810 },
				{ 47.425697, 81.876274, 22.090834 },
				{ 50.276203, 82.446571, 13.741330 },
				{ 53.966263, 83.181946, 6.688350 },
				{ 56.469967, 84.410866, -1.852795 },
				{ 56.649754, 86.141731, -12.806070 },
				{ 56.053963, 88.273529, -23.537462 },
				{ 54.828842, 90.326775, -33.481480 },
				{ 54.078789, 92.206749, -42.363384 },
				{ 53.755959, 94.110870, -50.594131 },
				{ 53.645256, 96.152504, -58.515736 },
				{ 53.616737, 98.319214, -66.308372 },
				{ 53.603134, 100.553055, -74.064339 },
				{ 53.583805, 102.808044, -81.819321 }
			},
			{
				{ 55.536858, 70.479248, 98.135201 },
				{ 51.909939, 71.838448, 76.557159 },
				{ 50.733135, 73.104652, 56.592770 },
				{ 50.231422, 74.146118, 39.815006 },
				{ 50.158398, 74.873299, 26.753271 },
				{ 52.390762, 75.846588, 17.866951 },
				{ 56.669342, 76.823532, 11.380933 },
				{ 59.333538, 78.373009, 2.911109 },
				{ 58.972015, 80.813568, -9.888577 },
				{ 57.653801, 83.265770, -21.612495 },
				{ 56.096855, 84.804550, -31.400345 },
				{ 55.721931, 86.109810, -39.426445 },
				{ 56.027229, 87.585579, -46.638866 },
				{ 56.518898, 89.361908, -53.666191 },
				{ 56.968449, 91.360954, -60.760921 },
				{ 57.325603, 93.467705, -67.966599 },
				{ 57.630013, 95.606682, -75.233376 }
			},
			{
				{ 60.835617, 62.287186, 108.720810 },
				{ 58.574310, 63.090485, 88.442451 },
				{ 58.632076, 63.610458, 70.191788 },
				{ 57.587654, 64.959602, 52.252445 },
				{ 56.786499, 66.198250, 37.274319 },
				{ 57.142612, 67.595573, 25.797831 },
				{ 59.024761, 69.571693, 16.294189 },
				{ 61.665577, 70.889435, 8.374887 },
				{ 60.929363, 74.194748, -5.421461 },
				{ 57.860466, 77.243713, -19.318659 },
				{ 57.246773, 78.482849, -28.677536 },
				{ 57.789234, 79.487404, -35.748596 },
				{ 58.769154, 80.757904, -42.042507 },
				{ 59.726368, 82.373650, -48.366081 },
				{ 60.454777, 84.242393, -54.999664 },
				{ 60.986080, 86.245728, -61.893181 },
				{ 61.433384, 88.294586, -68.897163 }
			},
			{
				{ 66.152626, 54.728863, 118.419174 },
				{ 65.451439, 55.174313, 99.628922 },
				{ 65.574692, 55.527443, 82.401100 },
				{ 65.027634, 56.286190, 64.758034 },
				{ 62.761868, 57.458168, 47.745918 },
				{ 63.968323, 59.320637, 36.684692 },
				{ 63.738571, 61.626553, 23.884340 },
				{ 62.048912, 63.327644, 10.845825 },
				{ 60.989609, 66.370674, -2.782341 },
				{ 59.164078, 69.071800, -15.253602 },
				{ 59.230465, 70.776108, -24.359180 },
				{ 60.584633, 72.163383, -30.889900 },
				{ 62.108665, 73.564903, -36.599239 },
				{ 63.244358, 75.124565, -42.591801 },
				{ 63.981453, 76.905251, -49.095810 },
				{ 64.498566, 78.840973, -55.922268 },
				{ 64.941475, 80.835503, -62.860661 }
			},
			{
				{ 70.533173, 47.026287, 126.781021 },
				{ 70.670006, 47.323288, 108.234634 },
				{ 70.586021, 48.191380, 90.278442 },
				{ 69.276093, 49.287022, 72.529541 },
				{ 68.664490, 50.515930, 57.527279 },
				{ 68.627258, 51.199047, 45.146477 },
				{ 64.758331, 52.708828, 28.376612 },
				{ 65.339172, 54.419094, 17.194853 },
				{ 64.482262, 56.923347, 4.357445 },
				{ 63.488491, 59.443333, -7.477627 },
				{ 62.071716, 62.020397, -18.473246 },
				{ 64.161232, 64.251869, -24.810232 },
				{ 65.923737, 65.938919, -30.356882 },
				{ 66.826492, 67.528633, -36.538982 },
				{ 67.374374, 69.309746, -43.227570 },
				{ 67.792656, 71.233864, -50.134270 },
				{ 68.166611, 73.208839, -57.096157 }
			},
			{
				{ 73.939934, 39.866127, 133.503311 },
				{ 74.280457, 40.201031, 114.975929 },
				{ 74.623413, 40.956791, 96.343849 },
				{ 71.292961, 42.718601, 76.590363 },
				{ 71.627800, 43.874702, 62.779766 },
				{ 72.951675, 43.995926, 52.728321 },
				{ 69.413620, 44.959126, 36.006973 },
				{ 69.083672, 46.172497, 24.252304 },
				{ 68.446320, 48.536282, 11.912823 },
				{ 68.628586, 51.115795, 1.505455 },
				{ 67.225105, 53.292290, -10.192417 },
				{ 68.382698, 55.863350, -17.726076 },
				{ 69.587059, 57.896118, -23.914392 },
				{ 70.092896, 59.619385, -30.626682 },
				{ 70.515945, 61.489513, -37.585487 },
				{ 70.864883, 63.432163, -44.554520 },
				{ 71.171707, 65.395912, -51.496876 }
			},
			{
				{ 77.459930, 33.389442, 138.909225 },
				{ 77.643188, 34.207474, 120.537880 },
				{ 76.730408, 34.601128, 100.607864 },
				{ 75.827820, 35.661236, 83.329651 },
				{ 75.609306, 36.129303, 69.305710 },
				{ 74.893913, 36.704548, 56.538475 },
				{ 74.224815, 37.623642, 43.095333 },
				{ 74.302284, 38.698273, 31.930655 },
				{ 72.851616, 41.070049, 18.897787 },
				{ 72.271248, 43.026901, 8.202063 },
				{ 72.177193, 45.016754, -1.820263 },
				{ 72.077530, 47.150394, -10.797093 },
				{ 73.118141, 50.124336, -17.979189 },
				{ 73.162987, 51.735378, -25.162161 },
				{ 73.475533, 53.542442, -32.246208 },
				{ 73.770630, 55.451645, -39.130299 },
				{ 74.042282, 57.375195, -45.914577 }
			},
			{
				{ 80.697540, 26.943811, 142.739319 },
				{ 80.454338, 27.482140, 124.555565 },
				{ 79.779663, 27.904547, 105.693771 },
				{ 78.772293, 28.623030, 88.167900 },
				{ 77.800255, 28.845112, 72.593651 },
				{ 78.183121, 29.680038, 61.610630 },
				{ 78.658607, 30.237059, 50.943748 },
				{ 77.909271, 31.065199, 38.987003 },
				{ 77.996765, 32.668633, 28.423588 },
				{ 77.230537, 34.246727, 17.454695 },
				{ 75.450470, 36.590130, 4.673000 },
				{ 75.238144, 38.213917, -4.392149 },
				{ 75.782875, 41.156994, -12.441341 },
				{ 76.341270, 43.939987, -20.030560 },
				{ 76.343506, 45.546459, -27.210552 },
				{ 76.615242, 47.331116, -33.741413 },
				{ 76.888046, 49.155640, -40.223724 }
			},
			{
				{ 83.610336, 20.569952, 144.912766 },
				{ 82.496559, 20.676317, 126.464432 },
				{ 81.376839, 20.864479, 107.652878 },
				{ 81.616272, 21.249910, 92.266243 },
				{ 81.271210, 21.582018, 78.669212 },
				{ 82.938789, 22.651941, 70.114784 },
				{ 82.570847, 23.424118, 57.898521 },
				{ 80.858009, 24.172062, 43.752327 },
				{ 80.229103, 25.692499, 32.034809 },
				{ 81.948334, 26.496731, 25.254341 },
				{ 80.110931, 28.192329, 13.232217 },
				{ 79.036453, 29.082348, 3.402195 },
				{ 79.096375, 32.132870, -5.899352 },
				{ 79.208931, 34.958199, -14.216118 },
				{ 79.346008, 37.331806, -22.005264 },
				{ 79.577980, 39.075371, -28.191719 },
				{ 79.793808, 40.811565, -34.436527 }
			},
			{
				{ 86.310371, 14.305269, 145.775070 },
				{ 84.864708, 14.035273, 127.665421 },
				{ 83.163528, 13.907498, 109.474541 },
				{ 83.840134, 14.252025, 95.793411 },
				{ 84.018166, 14.225272, 82.996414 },
				{ 85.252121, 15.372043, 73.502899 },
				{ 83.145332, 15.937057, 58.298229 },
				{ 81.983795, 17.237209, 44.538807 },
				{ 81.616272, 18.604029, 33.910397 },
				{ 82.762993, 19.852448, 26.991571 },
				{ 82.209915, 20.412176, 17.127321 },
				{ 81.873726, 21.732948, 8.222581 },
				{ 82.376823, 24.338131, 0.036372 },
				{ 82.769989, 26.678829, -7.665060 },
				{ 82.541191, 29.041466, -16.154619 },
				{ 82.470253, 30.773294, -22.756468 },
				{ 82.752739, 32.439934, -28.704720 }
			},
			{
				{ 88.716400, 8.078192, 145.447937 },
				{ 87.786942, 7.744143, 129.649139 },
				{ 86.498070, 7.313774, 113.158730 },
				{ 86.197281, 7.458539, 99.408768 },
				{ 87.373940, 7.927577, 87.944847 },
				{ 87.857292, 8.748639, 77.295929 },
				{ 86.176628, 9.406921, 62.265202 },
				{ 84.742706, 10.177112, 48.930237 },
				{ 85.993462, 11.479807, 41.211060 },
				{ 86.243668, 12.492562, 33.259769 },
				{ 86.283119, 13.734988, 24.581404 },
				{ 85.813988, 15.049564, 14.738050 },
				{ 86.554291, 16.797874, 7.588712 },
				{ 86.121330, 18.519869, -1.251622 },
				{ 85.895439, 20.799885, -9.977022 },
				{ 85.745445, 22.689367, -16.978657 },
				{ 85.728592, 24.129206, -23.110125 }
			},
			{
				{ 90.870033, 1.674960, 143.867218 },
				{ 90.217918, 0.841768, 129.644333 },
				{ 89.827744, 0.337822, 115.945763 },
				{ 89.642502, 0.865822, 103.628685 },
				{ 89.080299, 1.599789, 91.079132 },
				{ 89.022148, 1.717696, 79.840042 },
				{ 89.169930, 2.383740, 68.599930 },
				{ 89.011078, 3.321553, 57.534733 },
				{ 89.214813, 4.140051, 48.821674 },
				{ 89.418823, 4.810682, 39.828049 },
				{ 89.957382, 7.016832, 31.401020 },
				{ 89.794861, 7.817846, 22.352604 },
				{ 90.629784, 9.329934, 15.438860 },
				{ 89.107040, 11.128892, 4.459541 },
				{ 88.945518, 12.479973, -4.248758 },
				{ 88.808136, 14.752637, -11.844296 },
				{ 88.468315, 15.874557, -18.063000 }
			},
			{
				{ 93.089706, -4.920960, 141.618011 },
				{ 92.549927, -6.822685, 127.639893 },
				{ 91.930321, -8.983277, 113.009964 },
				{ 91.746651, -10.007743, 99.709030 },
				{ 91.831970, -8.759332, 90.341927 },
				{ 91.701508, -6.822004, 81.732506 },
				{ 91.583725, -4.443367, 71.928764 },
				{ 91.563530, -3.280141, 61.731621 },
				{ 92.285324, -3.099315, 54.009174 },
				{ 92.453278, -2.610423, 45.394402 },
				{ 92.300430, -0.315785, 35.897743 },
				{ 92.729515, -0.094676, 27.993155 },
				{ 92.376984, 1.137195, 19.531956 },
				{ 92.844994, 3.719659, 11.079104 },
				{ 92.223839, 4.776293, 1.963733 },
				{ 91.898216, 5.875350, -5.877737 },
				{ 91.859802, 8.305871, -13.048352 }
			},
			{
				{ 95.389038, -11.887012, 138.733490 },
				{ 95.024551, -14.562854, 125.112938 },
				{ 94.637260, -17.469717, 111.004051 },
				{ 94.293877, -20.342054, 97.086647 },
				{ 94.369949, -20.079315, 88.326431 },
				{ 94.518585, -18.899935, 80.476196 },
				{ 94.084290, -16.015785, 70.989960 },
				{ 93.635017, -10.989694, 62.743744 },
				{ 94.089104, -11.183307, 54.320065 },
				{ 94.869812, -12.691097, 45.907139 },
				{ 94.877419, -8.977646, 38.931377 },
				{ 95.294907, -7.480052, 33.306877 },
				{ 95.153755, -7.082741, 24.539446 },
				{ 95.130432, -4.066227, 15.134933 },
				{ 95.572708, -1.759585, 8.184630 },
				{ 95.640121, -0.389897, 0.858053 },
				{ 95.292290, 1.468389, -7.590969 }
			},
			{
				{ 97.754158, -19.121099, 135.498337 },
				{ 97.535713, -22.321255, 122.489861 },
				{ 97.244453, -25.190746, 109.739624 },
				{ 96.771004, -27.161884, 97.842773 },
				{ 96.306892, -27.426241, 88.082397 },
				{ 96.729301, -27.640274, 80.065331 },
				{ 97.079948, -26.845785, 72.071732 },
				{ 97.232704, -24.250675, 64.178589 },
				{ 96.918472, -21.464380, 55.986748 },
				{ 97.003487, -21.014576, 45.544643 },
				{ 97.221298, -17.663111, 40.049976 },
				{ 97.778404, -15.158984, 35.137287 },
				{ 98.271477, -14.100187, 28.432560 },
				{ 98.205032, -12.116192, 20.114220 },
				{ 97.820526, -9.019086, 11.347619 },
				{ 98.557121, -7.258503, 5.630774 },
				{ 98.961845, -5.071193, -1.297562 }
			}
		},
		{
			{
				{ 36.688290, 99.915314, 60.605904 },
				{ 38.405041, 99.911804, 49.498276 },
				{ 40.363945, 99.855736, 38.787949 },
				{ 42.764114, 99.725571, 28.728138 },
				{ 45.689537, 99.550819, 19.408138 },
				{ 48.871300, 99.439514, 10.621888 },
				{ 51.865654, 99.505074, 2.159902 },
				{ 54.364132, 99.864731, -6.117496 },
				{ 56.048161, 100.705719, -14.576375 },
				{ 56.720039, 102.143372, -23.587648 },
				{ 56.422596, 104.246841, -33.281822 },
				{ 55.320717, 106.925644, -43.568970 },
				{ 53.693401, 109.904060, -54.147541 },
				{ 51.835804, 112.902466, -64.692070 },
				{ 49.956139, 115.770485, -75.018158 },
				{ 48.137817, 118.498611, -85.120956 },
				{ 46.366421, 121.156288, -95.110138 }
			},
			{
				{ 43.779247, 91.340202, 74.210709 },
				{ 43.673420, 92.019585, 59.207348 },
				{ 43.937229, 92.692245, 44.937794 },
				{ 45.046070, 93.264503, 32.330265 },
				{ 47.319908, 93.627388, 21.986374 },
				{ 50.382042, 93.869087, 13.388393 },
				{ 53.528847, 94.123428, 5.417353 },
				{ 56.083031, 94.514053, -2.833717 },
				{ 57.621758, 95.333252, -11.789394 },
				{ 58.098366, 96.945038, -21.432245 },
				{ 57.543644, 99.270332, -31.570538 },
				{ 56.436348, 101.824768, -41.675404 },
				{ 55.183681, 104.323273, -51.434105 },
				{ 53.971806, 106.713570, -60.813293 },
				{ 52.846706, 109.035828, -69.912788 },
				{ 51.791458, 111.333199, -78.856758 },
				{ 50.767872, 113.626686, -87.745316 }
			},
			{
				{ 50.908531, 82.797966, 87.985077 },
				{ 49.565205, 83.881775, 69.939949 },
				{ 48.189384, 85.106689, 52.194153 },
				{ 48.087772, 86.287483, 37.085712 },
				{ 49.485500, 87.284149, 25.380095 },
				{ 52.013073, 87.995834, 16.660139 },
				{ 55.176651, 88.503082, 9.084156 },
				{ 57.446068, 89.110985, 0.427373 },
				{ 58.721935, 89.865822, -9.217370 },
				{ 59.210979, 91.729500, -19.340094 },
				{ 58.522358, 94.323631, -29.856934 },
				{ 57.556519, 96.644112, -39.650307 },
				{ 56.767887, 98.597023, -48.518520 },
				{ 56.214439, 100.393791, -56.751400 },
				{ 55.806301, 102.221214, -64.699448 },
				{ 55.453465, 104.139832, -72.581078 },
				{ 55.110390, 106.114662, -80.469620 }
			},
			{
				{ 57.589550, 74.492783, 101.255981 },
				{ 56.117180, 75.491013, 81.924316 },
				{ 53.349907, 76.851662, 61.231365 },
				{ 52.713985, 78.266144, 44.614178 },
				{ 53.235329, 79.882942, 31.544313 },
				{ 54.439636, 81.240555, 21.642069 },
				{ 57.164951, 82.024643, 13.781807 },
				{ 58.520176, 83.377686, 3.933977 },
				{ 59.476067, 84.617279, -6.766380 },
				{ 59.583015, 86.940918, -17.613361 },
				{ 59.191063, 89.316048, -28.034195 },
				{ 58.769943, 91.108383, -37.163471 },
				{ 58.608559, 92.483315, -45.065620 },
				{ 58.701042, 93.787582, -52.266064 },
				{ 58.903904, 95.247162, -59.262573 },
				{ 59.110504, 96.894020, -66.305420 },
				{ 59.297115, 98.639069, -73.418228 }
			},
			{
				{ 63.078342, 66.706207, 112.779800 },
				{ 60.384766, 67.576866, 91.493263 },
				{ 58.992680, 68.441406, 71.632027 },
				{ 59.382164, 69.534187, 55.617046 },
				{ 60.196075, 71.135162, 42.607582 },
				{ 59.681320, 72.818253, 30.340641 },
				{ 59.398361, 74.189804, 19.087774 },
				{ 60.622852, 76.283493, 8.810989 },
				{ 60.298103, 79.122032, -3.313244 },
				{ 59.528725, 81.883011, -15.538560 },
				{ 59.886616, 83.652527, -25.491989 },
				{ 60.309978, 84.839958, -33.736359 },
				{ 60.864922, 85.782570, -40.755859 },
				{ 61.517384, 86.808174, -47.191830 },
				{ 62.149132, 88.083214, -53.562660 },
				{ 62.709053, 89.589195, -60.086075 },
				{ 63.222687, 91.206520, -66.727097 }
			},
			{
				{ 68.666924, 59.281513, 123.489960 },
				{ 66.332207, 60.022392, 102.351601 },
				{ 65.184837, 60.601086, 82.644226 },
				{ 65.956032, 61.286366, 66.825439 },
				{ 66.684204, 62.426003, 53.508125 },
				{ 65.059586, 63.967663, 39.629475 },
				{ 64.360023, 65.546425, 26.806763 },
				{ 63.495804, 68.109818, 14.464160 },
				{ 62.720928, 71.632545, 1.323473 },
				{ 61.840694, 74.758194, -11.109055 },
				{ 61.766720, 76.552025, -21.086550 },
				{ 62.568394, 77.574295, -28.875895 },
				{ 63.658833, 78.440384, -35.424267 },
				{ 64.645805, 79.470703, -41.532303 },
				{ 65.463821, 80.747421, -47.675133 },
				{ 66.162994, 82.226448, -54.013344 },
				{ 66.811958, 83.800270, -60.478565 }
			},
			{
				{ 73.467705, 51.774593, 132.458008 },
				{ 72.516724, 52.408562, 112.369865 },
				{ 71.521828, 53.191143, 92.542213 },
				{ 70.190758, 54.234955, 74.409828 },
				{ 70.007393, 54.752945, 60.417217 },
				{ 69.775673, 55.917053, 47.547375 },
				{ 68.694466, 57.637142, 33.997166 },
				{ 67.044823, 59.366432, 21.230635 },
				{ 67.245377, 62.029091, 9.274958 },
				{ 67.201637, 65.059464, -2.324881 },
				{ 65.052094, 67.781143, -14.294370 },
				{ 65.916313, 69.279709, -22.414417 },
				{ 67.079613, 70.556053, -29.160650 },
				{ 67.970322, 71.860336, -35.476749 },
				{ 68.718773, 73.267464, -41.760941 },
				{ 69.398834, 74.789436, -48.165668 },
				{ 70.053658, 76.375740, -54.655243 }
			},
			{
				{ 77.132301, 44.598946, 139.086624 },
				{ 76.853912, 45.092968, 118.976257 },
				{ 75.480499, 46.204479, 97.992218 },
				{ 70.671471, 48.439346, 76.953476 },
				{ 73.807594, 48.262123, 67.259491 },
				{ 75.214035, 48.568665, 56.600399 },
				{ 74.149460, 49.499374, 43.198547 },
				{ 73.892120, 50.624458, 31.581890 },
				{ 71.902626, 52.690929, 18.329330 },
				{ 71.634789, 55.115467, 7.289275 },
				{ 69.327019, 58.092880, -5.728639 },
				{ 70.220474, 60.268463, -14.872312 },
				{ 70.817139, 62.386520, -22.515419 },
				{ 71.288437, 64.059502, -29.359201 },
				{ 71.833519, 65.628433, -35.978294 },
				{ 72.416199, 67.225563, -42.551498 },
				{ 73.008064, 68.870064, -49.131748 }
			},
			{
				{ 79.847588, 38.259377, 143.358810 },
				{ 78.675636, 39.115768, 122.014534 },
				{ 78.285782, 39.613575, 102.438904 },
				{ 77.610466, 40.599167, 87.020706 },
				{ 79.230957, 41.093330, 76.768333 },
				{ 79.872154, 41.768742, 64.776924 },
				{ 78.855896, 41.985077, 51.659176 },
				{ 77.875938, 42.750824, 39.361664 },
				{ 76.188278, 44.349606, 26.879990 },
				{ 75.744507, 46.390327, 15.267989 },
				{ 74.133705, 48.830772, 2.610764 },
				{ 73.399124, 51.462814, -8.353153 },
				{ 74.219017, 54.206993, -16.299948 },
				{ 74.481888, 56.082008, -23.514704 },
				{ 74.835014, 57.759884, -30.395935 },
				{ 75.290047, 59.463341, -37.092003 },
				{ 75.781487, 61.225849, -43.724255 }
			},
			{
				{ 82.540932, 32.145336, 146.616745 },
				{ 81.160934, 32.701077, 125.856720 },
				{ 80.915329, 32.986950, 107.851204 },
				{ 82.071327, 33.265720, 94.034996 },
				{ 82.114517, 34.128273, 81.235649 },
				{ 82.610802, 34.869003, 69.692238 },
				{ 81.552299, 34.780773, 57.579247 },
				{ 80.776566, 35.406578, 45.409256 },
				{ 81.208229, 36.808861, 35.568851 },
				{ 80.858154, 38.698914, 24.193680 },
				{ 79.212036, 40.564491, 11.561258 },
				{ 76.433746, 42.564102, -1.546785 },
				{ 77.079826, 45.284351, -10.380394 },
				{ 77.524696, 47.790615, -17.940842 },
				{ 77.784073, 49.605064, -24.928919 },
				{ 78.110992, 51.474594, -31.661455 },
				{ 78.485031, 53.406399, -38.277046 }
			},
			{
				{ 85.579605, 25.915577, 149.405197 },
				{ 84.502884, 25.673029, 130.443344 },
				{ 83.922005, 25.553934, 112.009270 },
				{ 85.087440, 26.088091, 98.370575 },
				{ 84.392708, 27.073923, 84.548195 },
				{ 84.534073, 27.715172, 73.356117 },
				{ 84.740562, 27.529100, 63.042175 },
				{ 85.658554, 28.811762, 53.033127 },
				{ 84.997276, 30.267530, 41.551247 },
				{ 84.037521, 31.598318, 30.291777 },
				{ 82.992477, 32.355350, 19.536308 },
				{ 80.922890, 33.892757, 6.901993 },
				{ 80.570099, 36.596882, -3.545864 },
				{ 80.597519, 39.096649, -11.872830 },
				{ 80.780083, 41.332504, -19.365181 },
				{ 80.953491, 43.338497, -26.124706 },
				{ 81.203690, 45.378841, -32.716080 }
			},
			{
				{ 88.465195, 19.519770, 150.399551 },
				{ 86.569389, 19.001919, 130.961792 },
				{ 83.953636, 18.527910, 110.981621 },
				{ 85.022385, 19.240419, 98.328857 },
				{ 86.359444, 20.441628, 87.655235 },
				{ 87.312798, 20.880756, 77.538841 },
				{ 87.432838, 20.523823, 66.835182 },
				{ 86.647644, 22.319809, 54.383690 },
				{ 85.358269, 23.932369, 41.375557 },
				{ 87.228477, 24.443521, 35.292377 },
				{ 86.056076, 25.524426, 25.180025 },
				{ 84.860245, 26.035936, 14.089020 },
				{ 83.964821, 27.953773, 3.766033 },
				{ 83.875084, 30.954487, -5.325181 },
				{ 84.268219, 33.519184, -13.207021 },
				{ 83.987190, 35.242516, -20.302776 },
				{ 84.012169, 37.122662, -27.037399 }
			},
			{
				{ 90.733536, 12.739808, 149.365204 },
				{ 89.276268, 12.692517, 132.605316 },
				{ 87.690865, 12.350531, 115.608131 },
				{ 87.805557, 12.269123, 102.339783 },
				{ 89.387344, 13.826418, 91.372055 },
				{ 90.073753, 14.257586, 80.514442 },
				{ 89.941376, 14.724685, 68.967323 },
				{ 87.762947, 15.964356, 54.369991 },
				{ 86.875786, 16.744717, 43.404163 },
				{ 88.116272, 16.763790, 37.362484 },
				{ 88.068756, 18.747913, 28.435472 },
				{ 88.154732, 19.437887, 19.585011 },
				{ 88.329346, 20.975426, 11.339172 },
				{ 87.849121, 23.473446, 1.726239 },
				{ 87.699196, 25.796570, -7.093344 },
				{ 87.341454, 27.269760, -14.314291 },
				{ 86.993561, 28.737358, -21.309038 }
			},
			{
				{ 92.648087, 5.393196, 146.684952 },
				{ 91.978790, 5.866826, 133.847000 },
				{ 91.706558, 6.736704, 121.808022 },
				{ 91.583336, 7.255363, 108.462563 },
				{ 91.029152, 7.572214, 94.360901 },
				{ 90.439072, 7.441715, 81.745697 },
				{ 90.763855, 7.714839, 71.000038 },
				{ 90.548767, 8.915814, 59.444931 },
				{ 91.023796, 9.753941, 51.417252 },
				{ 91.912331, 11.113091, 43.809669 },
				{ 91.534637, 12.528190, 34.081871 },
				{ 91.730698, 12.812917, 25.725368 },
				{ 92.235023, 13.728673, 18.473150 },
				{ 91.765160, 15.850098, 8.626418 },
				{ 89.797882, 17.212919, -2.419464 },
				{ 90.085976, 18.939486, -9.735577 },
				{ 89.971733, 20.481281, -15.937159 }
			},
			{
				{ 94.612671, -2.260512, 143.136475 },
				{ 94.238136, -2.270287, 131.318588 },
				{ 93.974480, -1.713973, 120.117554 },
				{ 94.043449, -0.733555, 109.541527 },
				{ 93.940140, 0.600155, 98.175224 },
				{ 93.556999, 1.835488, 86.748871 },
				{ 93.675896, 1.881620, 76.544907 },
				{ 93.860329, 2.027597, 66.453163 },
				{ 94.063179, 3.140814, 57.159241 },
				{ 94.404381, 4.626008, 48.503357 },
				{ 94.347481, 5.114989, 38.977192 },
				{ 94.024429, 5.019315, 30.051096 },
				{ 94.128319, 5.685556, 22.776838 },
				{ 94.199173, 7.942520, 13.770531 },
				{ 93.404022, 9.956228, 3.435900 },
				{ 92.707062, 10.547346, -4.860276 },
				{ 93.293091, 13.190936, -10.817748 }
			},
			{
				{ 96.656845, -10.085104, 139.008530 },
				{ 96.395325, -11.312651, 126.754189 },
				{ 96.259712, -12.164832, 115.083595 },
				{ 96.495872, -12.044371, 105.544731 },
				{ 96.387520, -9.912796, 96.883194 },
				{ 96.041229, -7.325545, 87.554565 },
				{ 95.980072, -5.743129, 78.563446 },
				{ 96.058090, -4.485270, 69.116470 },
				{ 95.773254, -2.844869, 58.724693 },
				{ 96.294159, -2.193801, 51.756031 },
				{ 96.389763, -2.227589, 42.437462 },
				{ 96.285301, -2.479594, 34.167542 },
				{ 96.804405, -1.100444, 27.364597 },
				{ 96.880737, 0.534175, 19.293606 },
				{ 97.171600, 3.474716, 10.245110 },
				{ 96.829399, 5.264803, 1.750960 },
				{ 96.805046, 6.827938, -5.494954 }
			},
			{
				{ 98.760368, -18.062004, 134.550674 },
				{ 98.586166, -20.571695, 121.918839 },
				{ 98.471275, -22.482967, 110.191833 },
				{ 98.466064, -22.922596, 100.534302 },
				{ 98.475922, -21.571339, 92.957542 },
				{ 98.746399, -20.424332, 85.907196 },
				{ 98.433105, -17.796642, 76.693054 },
				{ 97.726746, -13.039515, 66.771317 },
				{ 98.114990, -10.751813, 60.025890 },
				{ 98.678322, -12.132895, 53.246109 },
				{ 99.244965, -12.623101, 46.439640 },
				{ 99.103394, -10.886220, 36.740852 },
				{ 99.237404, -7.523942, 28.774591 },
				{ 99.813148, -6.187550, 23.309555 },
				{ 99.399155, -4.009853, 14.682968 },
				{ 99.979889, -2.168140, 8.025488 },
				{ 100.000000, 0.000000, 0.000000 }
			}
		}
	}
};

