/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Utils;

public class VerboseReporter
extends TestListenerAdapter {
    public static final String LISTENER_PREFIX = "[VerboseTestNG] ";
    private String suiteName;
    private final String prefix;

    @Deprecated
    public VerboseReporter() {
        this(LISTENER_PREFIX);
    }

    public VerboseReporter(String string) {
        this.prefix = string;
    }

    @Override
    public void beforeConfiguration(ITestResult iTestResult) {
        super.beforeConfiguration(iTestResult);
        this.logTestResult(Status.STARTED, iTestResult, true);
    }

    @Override
    public void onConfigurationFailure(ITestResult iTestResult) {
        super.onConfigurationFailure(iTestResult);
        this.logTestResult(Status.FAILURE, iTestResult, true);
    }

    @Override
    public void onConfigurationSkip(ITestResult iTestResult) {
        super.onConfigurationSkip(iTestResult);
        this.logTestResult(Status.SKIP, iTestResult, true);
    }

    @Override
    public void onConfigurationSuccess(ITestResult iTestResult) {
        super.onConfigurationSuccess(iTestResult);
        this.logTestResult(Status.SUCCESS, iTestResult, true);
    }

    @Override
    public void onTestStart(ITestResult iTestResult) {
        this.logTestResult(Status.STARTED, iTestResult, false);
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
        super.onTestFailure(iTestResult);
        this.logTestResult(Status.FAILURE, iTestResult, false);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
        super.onTestFailedButWithinSuccessPercentage(iTestResult);
        this.logTestResult(Status.SUCCESS_PERCENTAGE_FAILURE, iTestResult, false);
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
        super.onTestSkipped(iTestResult);
        this.logTestResult(Status.SKIP, iTestResult, false);
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
        super.onTestSuccess(iTestResult);
        this.logTestResult(Status.SUCCESS, iTestResult, false);
    }

    @Override
    public void onStart(ITestContext iTestContext) {
        this.suiteName = iTestContext.getName();
        this.log("RUNNING: Suite: \"" + this.suiteName + "\" containing \"" + iTestContext.getAllTestMethods().length + "\" Tests (config: " + iTestContext.getSuite().getXmlSuite().getFileName() + ")");
    }

    @Override
    public void onFinish(ITestContext iTestContext) {
        this.logResults();
        this.suiteName = null;
    }

    private ITestNGMethod[] resultsToMethods(List<ITestResult> list) {
        ITestNGMethod[] iTestNGMethodArray = new ITestNGMethod[list.size()];
        int n = 0;
        for (ITestResult iTestResult : list) {
            iTestNGMethodArray[n++] = iTestResult.getMethod();
        }
        return iTestNGMethodArray;
    }

    private void logResults() {
        ITestNGMethod[] iTestNGMethodArray = this.resultsToMethods(this.getFailedTests());
        StringBuilder stringBuilder = new StringBuilder("\n===============================================\n");
        stringBuilder.append("    ").append(this.suiteName).append("\n");
        stringBuilder.append("    Tests run: ").append(Utils.calculateInvokedMethodCount(this.getAllTestMethods()));
        stringBuilder.append(", Failures: ").append(Utils.calculateInvokedMethodCount(iTestNGMethodArray));
        stringBuilder.append(", Skips: ").append(Utils.calculateInvokedMethodCount(this.resultsToMethods(this.getSkippedTests())));
        int n = this.getConfigurationFailures().size();
        int n2 = this.getConfigurationSkips().size();
        if (n > 0 || n2 > 0) {
            stringBuilder.append("\n").append("    Configuration Failures: ").append(n);
            stringBuilder.append(", Skips: ").append(n2);
        }
        stringBuilder.append("\n===============================================");
        this.log(stringBuilder.toString());
    }

    private void logTestResult(Status status, ITestResult iTestResult, boolean bl) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        Object var5_5 = null;
        String string = "";
        switch (status) {
            case STARTED: {
                stringBuilder.append("INVOKING");
                break;
            }
            case SKIP: {
                stringBuilder.append("SKIPPED");
                string = iTestResult.getThrowable() != null ? Utils.shortStackTrace(iTestResult.getThrowable(), false) : "";
                break;
            }
            case FAILURE: {
                stringBuilder.append("FAILED");
                string = iTestResult.getThrowable() != null ? Utils.shortStackTrace(iTestResult.getThrowable(), false) : "";
                break;
            }
            case SUCCESS: {
                stringBuilder.append("PASSED");
                break;
            }
            case SUCCESS_PERCENTAGE_FAILURE: {
                stringBuilder.append("PASSED with failures");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported test status:" + iTestResult.getStatus());
            }
        }
        if (bl) {
            stringBuilder.append(" CONFIGURATION: ");
        } else {
            stringBuilder.append(": ");
        }
        ITestNGMethod iTestNGMethod = iTestResult.getMethod();
        int n2 = stringBuilder.length();
        stringBuilder.append(this.getMethodDeclaration(iTestNGMethod));
        Object[] objectArray = iTestResult.getParameters();
        Class[] classArray = iTestNGMethod.getConstructorOrMethod().getParameterTypes();
        if (null != objectArray && objectArray.length > 0) {
            if (objectArray.length != classArray.length) {
                stringBuilder.append("Wrong number of arguments were passed by the Data Provider: found ");
                stringBuilder.append(objectArray.length);
                stringBuilder.append(" but expected ");
                stringBuilder.append(classArray.length);
            } else {
                stringBuilder.append("(value(s): ");
                for (n = 0; n < objectArray.length; ++n) {
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(Utils.toString(objectArray[n], classArray[n]));
                }
                stringBuilder.append(")");
            }
        }
        if (Status.STARTED != status) {
            stringBuilder.append(" finished in ");
            stringBuilder.append(iTestResult.getEndMillis() - iTestResult.getStartMillis());
            stringBuilder.append(" ms");
            if (!Utils.isStringEmpty(iTestNGMethod.getDescription())) {
                stringBuilder.append("\n");
                for (n = 0; n < n2; ++n) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(iTestNGMethod.getDescription());
            }
            if (iTestNGMethod.getInvocationCount() > 1) {
                stringBuilder.append(" (");
                stringBuilder.append(iTestNGMethod.getCurrentInvocationCount());
                stringBuilder.append(" of ");
                stringBuilder.append(iTestNGMethod.getInvocationCount());
                stringBuilder.append(")");
            }
            if (!Utils.isStringEmpty(string)) {
                stringBuilder.append("\n").append(string.substring(0, string.lastIndexOf(System.getProperty("line.separator"))));
            }
        } else if (!bl && iTestNGMethod.getInvocationCount() > 1) {
            stringBuilder.append(" success: ");
            stringBuilder.append(iTestNGMethod.getSuccessPercentage());
            stringBuilder.append("%");
        }
        this.log(stringBuilder.toString());
    }

    protected void log(String string) {
        System.out.println(string.replaceAll("(?m)^", this.prefix));
    }

    private String getMethodDeclaration(ITestNGMethod iTestNGMethod) {
        ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        if (this.suiteName != null) {
            stringBuilder.append(this.suiteName);
        } else {
            stringBuilder.append("UNKNOWN");
        }
        stringBuilder.append("\"");
        stringBuilder.append(" - ");
        String string = Utils.annotationFormFor(iTestNGMethod);
        if (!string.isEmpty()) {
            stringBuilder.append(Utils.annotationFormFor(iTestNGMethod)).append(" ");
        }
        stringBuilder.append(constructorOrMethod.getDeclaringClass().getName());
        stringBuilder.append(".");
        stringBuilder.append(constructorOrMethod.getName());
        stringBuilder.append("(");
        int n = 0;
        for (Class clazz : constructorOrMethod.getParameterTypes()) {
            if (n++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz.getName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return "VerboseReporter{suiteName=" + this.suiteName + '}';
    }

    private static enum Status {
        SUCCESS(1),
        FAILURE(2),
        SKIP(3),
        SUCCESS_PERCENTAGE_FAILURE(4),
        STARTED(16);

        private int status;

        private Status(int n2) {
            this.status = n2;
        }
    }
}

